/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooDefs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZKMulti {
    private static final Log LOG = LogFactory.getLog(TestZKMulti.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ZooKeeperWatcher zkw = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.zookeeper.useMulti", true);
        Abortable abortable = new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        };
        zkw = new ZooKeeperWatcher(conf, "TestZKMulti", abortable, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test(timeout=60000L)
    public void testSimpleMulti() throws Exception {
        ZKUtil.multiOrSequential(zkw, null, false);
        ZKUtil.multiOrSequential(zkw, new LinkedList<ZKUtil.ZKUtilOp>(), false);
        String path = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testSimpleMulti");
        LinkedList<ZKUtil.ZKUtilOp> singleCreate = new LinkedList<ZKUtil.ZKUtilOp>();
        singleCreate.add(ZKUtil.ZKUtilOp.createAndFailSilent(path, new byte[0]));
        ZKUtil.multiOrSequential(zkw, singleCreate, false);
        Assert.assertTrue((ZKUtil.checkExists(zkw, path) != -1 ? 1 : 0) != 0);
        LinkedList<ZKUtil.ZKUtilOp> singleSetData = new LinkedList<ZKUtil.ZKUtilOp>();
        byte[] data = Bytes.toBytes("foobar");
        singleSetData.add(ZKUtil.ZKUtilOp.setData(path, data));
        ZKUtil.multiOrSequential(zkw, singleSetData, false);
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path), data));
        LinkedList<ZKUtil.ZKUtilOp> singleDelete = new LinkedList<ZKUtil.ZKUtilOp>();
        singleDelete.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(path));
        ZKUtil.multiOrSequential(zkw, singleDelete, false);
        Assert.assertTrue((ZKUtil.checkExists(zkw, path) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testComplexMulti() throws Exception {
        String path1 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testComplexMulti1");
        String path2 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testComplexMulti2");
        String path3 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testComplexMulti3");
        String path4 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testComplexMulti4");
        String path5 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testComplexMulti5");
        String path6 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testComplexMulti6");
        LinkedList<ZKUtil.ZKUtilOp> create4Nodes = new LinkedList<ZKUtil.ZKUtilOp>();
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent(path1, Bytes.toBytes(path1)));
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent(path2, Bytes.toBytes(path2)));
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent(path3, Bytes.toBytes(path3)));
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent(path4, Bytes.toBytes(path4)));
        ZKUtil.multiOrSequential(zkw, create4Nodes, false);
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path1), Bytes.toBytes(path1)));
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path2), Bytes.toBytes(path2)));
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path3), Bytes.toBytes(path3)));
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path4), Bytes.toBytes(path4)));
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.setData(path1, Bytes.add(Bytes.toBytes(path1), Bytes.toBytes(path1))));
        ops.add(ZKUtil.ZKUtilOp.setData(path2, Bytes.add(Bytes.toBytes(path2), Bytes.toBytes(path2))));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(path3));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(path4));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(path5, Bytes.toBytes(path5)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(path6, Bytes.toBytes(path6)));
        ZKUtil.multiOrSequential(zkw, ops, false);
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path1), Bytes.add(Bytes.toBytes(path1), Bytes.toBytes(path1))));
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path2), Bytes.add(Bytes.toBytes(path2), Bytes.toBytes(path2))));
        Assert.assertTrue((ZKUtil.checkExists(zkw, path3) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, path4) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path5), Bytes.toBytes(path5)));
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path6), Bytes.toBytes(path6)));
    }

    @Test(timeout=60000L)
    public void testSingleFailure() throws Exception {
        boolean caughtNoNode = false;
        String path = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testSingleFailureZ");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(path));
        try {
            ZKUtil.multiOrSequential(zkw, ops, false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        caughtNoNode = false;
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.setData(path, Bytes.toBytes(path)));
        try {
            ZKUtil.multiOrSequential(zkw, ops, false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        boolean caughtNodeExists = false;
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(path, Bytes.toBytes(path)));
        ZKUtil.multiOrSequential(zkw, ops, false);
        try {
            ZKUtil.multiOrSequential(zkw, ops, false);
        }
        catch (KeeperException.NodeExistsException nee) {
            caughtNodeExists = true;
        }
        Assert.assertTrue((boolean)caughtNodeExists);
    }

    @Test(timeout=60000L)
    public void testSingleFailureInMulti() throws Exception {
        String pathA = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testSingleFailureInMultiA");
        String pathB = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testSingleFailureInMultiB");
        String pathC = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testSingleFailureInMultiC");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(pathA, Bytes.toBytes(pathA)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(pathB, Bytes.toBytes(pathB)));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(pathC));
        boolean caughtNoNode = false;
        try {
            ZKUtil.multiOrSequential(zkw, ops, false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathA) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathB) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathC) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testMultiFailure() throws Exception {
        String pathX = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testMultiFailureX");
        String pathY = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testMultiFailureY");
        String pathZ = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testMultiFailureZ");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(pathX, Bytes.toBytes(pathX)));
        ZKUtil.multiOrSequential(zkw, ops, false);
        String pathV = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testMultiFailureV");
        String pathW = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "testMultiFailureW");
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(pathX, Bytes.toBytes(pathX)));
        ops.add(ZKUtil.ZKUtilOp.setData(pathY, Bytes.toBytes(pathY)));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(pathZ));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(pathX, Bytes.toBytes(pathV)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(pathX, Bytes.toBytes(pathW)));
        boolean caughtNodeExists = false;
        try {
            ZKUtil.multiOrSequential(zkw, ops, false);
        }
        catch (KeeperException.NodeExistsException nee) {
            caughtNodeExists = true;
        }
        Assert.assertTrue((boolean)caughtNodeExists);
        Assert.assertFalse((ZKUtil.checkExists(zkw, pathX) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathZ) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathW) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathV) == -1 ? 1 : 0) != 0);
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.setData(pathY, Bytes.toBytes(pathY)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(pathX, Bytes.toBytes(pathX)));
        boolean caughtNoNode = false;
        try {
            ZKUtil.multiOrSequential(zkw, ops, false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        Assert.assertFalse((ZKUtil.checkExists(zkw, pathX) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathZ) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathW) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, pathV) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testRunSequentialOnMultiFailure() throws Exception {
        String path1 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "runSequential1");
        String path2 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "runSequential2");
        String path3 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "runSequential3");
        String path4 = ZKUtil.joinZNode(TestZKMulti.zkw.baseZNode, "runSequential4");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(path1, Bytes.toBytes(path1)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(path2, Bytes.toBytes(path2)));
        ZKUtil.multiOrSequential(zkw, ops, false);
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.setData(path1, Bytes.add(Bytes.toBytes(path1), Bytes.toBytes(path1))));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(path2));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(path3));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent(path4, Bytes.add(Bytes.toBytes(path4), Bytes.toBytes(path4))));
        ZKUtil.multiOrSequential(zkw, ops, true);
        Assert.assertTrue((boolean)Bytes.equals(ZKUtil.getData(zkw, path1), Bytes.add(Bytes.toBytes(path1), Bytes.toBytes(path1))));
        Assert.assertTrue((ZKUtil.checkExists(zkw, path2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists(zkw, path3) == -1 ? 1 : 0) != 0);
        Assert.assertFalse((ZKUtil.checkExists(zkw, path4) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testdeleteChildrenRecursivelyMulti() throws Exception {
        String parentZNode = "/testRootMulti";
        this.createZNodeTree(parentZNode);
        ZKUtil.deleteChildrenRecursivelyMultiOrSequential(zkw, true, parentZNode);
        Assert.assertTrue((String)"Wrongly deleted parent znode!", (ZKUtil.checkExists(zkw, parentZNode) > -1 ? 1 : 0) != 0);
        List<String> children = zkw.getRecoverableZooKeeper().getChildren(parentZNode, false);
        Assert.assertTrue((String)"Failed to delete child znodes!", (0 == children.size() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testdeleteChildrenRecursivelySequential() throws Exception {
        String parentZNode = "/testRootSeq";
        this.createZNodeTree(parentZNode);
        boolean useMulti = zkw.getConfiguration().getBoolean("hbase.zookeeper.useMulti", false);
        zkw.getConfiguration().setBoolean("hbase.zookeeper.useMulti", false);
        try {
            ZKUtil.deleteChildrenRecursivelyMultiOrSequential(zkw, true, parentZNode);
            Assert.assertTrue((String)"Wrongly deleted parent znode!", (ZKUtil.checkExists(zkw, parentZNode) > -1 ? 1 : 0) != 0);
            List<String> children = zkw.getRecoverableZooKeeper().getChildren(parentZNode, false);
            Assert.assertTrue((String)"Failed to delete child znodes!", (0 == children.size() ? 1 : 0) != 0);
        }
        finally {
            zkw.getConfiguration().setBoolean("hbase.zookeeper.useMulti", useMulti);
        }
    }

    @Test(timeout=60000L)
    public void testDeleteNodeRecursivelyMulti() throws Exception {
        String parentZNode = "/testdeleteNodeRecursivelyMulti";
        this.createZNodeTree(parentZNode);
        ZKUtil.deleteNodeRecursively(zkw, parentZNode);
        Assert.assertTrue((String)"Parent znode should be deleted.", (ZKUtil.checkExists(zkw, parentZNode) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testDeleteNodeRecursivelySequential() throws Exception {
        String parentZNode = "/testdeleteNodeRecursivelySequential";
        this.createZNodeTree(parentZNode);
        boolean useMulti = zkw.getConfiguration().getBoolean("hbase.zookeeper.useMulti", false);
        zkw.getConfiguration().setBoolean("hbase.zookeeper.useMulti", false);
        try {
            ZKUtil.deleteNodeRecursively(zkw, parentZNode);
            Assert.assertTrue((String)"Parent znode should be deleted.", (ZKUtil.checkExists(zkw, parentZNode) == -1 ? 1 : 0) != 0);
        }
        finally {
            zkw.getConfiguration().setBoolean("hbase.zookeeper.useMulti", useMulti);
        }
    }

    @Test(timeout=60000L)
    public void testDeleteNodeRecursivelyMultiOrSequential() throws Exception {
        String parentZNode1 = "/testdeleteNode1";
        String parentZNode2 = "/testdeleteNode2";
        String parentZNode3 = "/testdeleteNode3";
        this.createZNodeTree(parentZNode1);
        this.createZNodeTree(parentZNode2);
        this.createZNodeTree(parentZNode3);
        ZKUtil.deleteNodeRecursivelyMultiOrSequential(zkw, false, parentZNode1, parentZNode2, parentZNode3);
        Assert.assertTrue((String)"Parent znode 1 should be deleted.", (ZKUtil.checkExists(zkw, parentZNode1) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Parent znode 2 should be deleted.", (ZKUtil.checkExists(zkw, parentZNode2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Parent znode 3 should be deleted.", (ZKUtil.checkExists(zkw, parentZNode3) == -1 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testDeleteChildrenRecursivelyMultiOrSequential() throws Exception {
        String parentZNode1 = "/testdeleteChildren1";
        String parentZNode2 = "/testdeleteChildren2";
        String parentZNode3 = "/testdeleteChildren3";
        this.createZNodeTree(parentZNode1);
        this.createZNodeTree(parentZNode2);
        this.createZNodeTree(parentZNode3);
        ZKUtil.deleteChildrenRecursivelyMultiOrSequential(zkw, true, parentZNode1, parentZNode2, parentZNode3);
        Assert.assertTrue((String)"Wrongly deleted parent znode 1!", (ZKUtil.checkExists(zkw, parentZNode1) > -1 ? 1 : 0) != 0);
        List<String> children = zkw.getRecoverableZooKeeper().getChildren(parentZNode1, false);
        Assert.assertTrue((String)"Failed to delete child znodes of parent znode 1!", (0 == children.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrongly deleted parent znode 2!", (ZKUtil.checkExists(zkw, parentZNode2) > -1 ? 1 : 0) != 0);
        children = zkw.getRecoverableZooKeeper().getChildren(parentZNode2, false);
        Assert.assertTrue((String)"Failed to delete child znodes of parent znode 1!", (0 == children.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrongly deleted parent znode 3!", (ZKUtil.checkExists(zkw, parentZNode3) > -1 ? 1 : 0) != 0);
        children = zkw.getRecoverableZooKeeper().getChildren(parentZNode3, false);
        Assert.assertTrue((String)"Failed to delete child znodes of parent znode 1!", (0 == children.size() ? 1 : 0) != 0);
    }

    private void createZNodeTree(String rootZNode) throws KeeperException, InterruptedException {
        ArrayList<Op> opList = new ArrayList<Op>();
        opList.add(Op.create((String)rootZNode, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        String parentZNode = rootZNode;
        for (int level = 0; level < 10; ++level) {
            parentZNode = parentZNode + "/" + level;
            opList.add(Op.create((String)parentZNode, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            for (int elements = 0; elements < level; ++elements) {
                opList.add(Op.create((String)(parentZNode + "/" + elements), (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            }
        }
        zkw.getRecoverableZooKeeper().multi(opList);
    }
}

