/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.Properties;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestZKConfig {
    @Test
    public void testZKConfigLoading() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.zookeeper.property.clientPort", 2181);
        Properties props = ZKConfig.makeZKProps(conf);
        Assert.assertEquals((String)"Property client port should have been default from the HBase config", (String)"2181", (String)props.getProperty("clientPort"));
        conf.setBoolean("hbase.config.read.zookeeper.config", true);
        props = ZKConfig.makeZKProps(conf);
        Assert.assertEquals((String)"Property client port should have been from zoo.cfg", (String)"9999", (String)props.getProperty("clientPort"));
    }
}

