/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFSUtils {
    @Test
    public void testMatchingTail() throws IOException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        FileSystem fs = htu.getTestFileSystem();
        Path rootdir = htu.getDataTestDir();
        Assert.assertTrue((rootdir.depth() > 1 ? 1 : 0) != 0);
        Path partPath = new Path("a", "b");
        Path fullPath = new Path(rootdir, partPath);
        Path fullyQualifiedPath = fs.makeQualified(fullPath);
        Assert.assertFalse((boolean)FSUtils.isMatchingTail(fullPath, partPath));
        Assert.assertFalse((boolean)FSUtils.isMatchingTail(fullPath, partPath.toString()));
        Assert.assertTrue((boolean)FSUtils.isStartingWithPath(rootdir, fullPath.toString()));
        Assert.assertTrue((boolean)FSUtils.isStartingWithPath(fullyQualifiedPath, fullPath.toString()));
        Assert.assertFalse((boolean)FSUtils.isStartingWithPath(rootdir, partPath.toString()));
        Assert.assertFalse((boolean)FSUtils.isMatchingTail(fullyQualifiedPath, partPath));
        Assert.assertTrue((boolean)FSUtils.isMatchingTail(fullyQualifiedPath, fullPath));
        Assert.assertTrue((boolean)FSUtils.isMatchingTail(fullyQualifiedPath, fullPath.toString()));
        Assert.assertTrue((boolean)FSUtils.isMatchingTail(fullyQualifiedPath, fs.makeQualified(fullPath)));
        Assert.assertTrue((boolean)FSUtils.isStartingWithPath(rootdir, fullyQualifiedPath.toString()));
        Assert.assertFalse((boolean)FSUtils.isMatchingTail(fullPath, new Path("x")));
        Assert.assertFalse((boolean)FSUtils.isMatchingTail(new Path("x"), fullPath));
    }

    @Test
    public void testVersion() throws DeserializationException, IOException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        FileSystem fs = htu.getTestFileSystem();
        Path rootdir = htu.getDataTestDir();
        Assert.assertNull((Object)FSUtils.getVersion(fs, rootdir));
        Path versionFile = new Path(rootdir, "hbase.version");
        FSDataOutputStream s = fs.create(versionFile);
        String version = "8";
        s.writeUTF("8");
        s.close();
        Assert.assertTrue((boolean)fs.exists(versionFile));
        FileStatus[] status = fs.listStatus(versionFile);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((status.length > 0 ? 1 : 0) != 0);
        String newVersion = FSUtils.getVersion(fs, rootdir);
        Assert.assertEquals((long)"8".length(), (long)newVersion.length());
        Assert.assertEquals((Object)"8", (Object)newVersion);
        Assert.assertEquals((Object)"8", (Object)FSUtils.getVersion(fs, rootdir));
        FSUtils.checkVersion(fs, rootdir, true);
    }

    @Test
    public void testIsHDFS() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        htu.getConfiguration().setBoolean("dfs.support.append", false);
        Assert.assertFalse((boolean)FSUtils.isHDFS(htu.getConfiguration()));
        htu.getConfiguration().setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = null;
        try {
            cluster = htu.startMiniDFSCluster(1);
            Assert.assertTrue((boolean)FSUtils.isHDFS(htu.getConfiguration()));
            Assert.assertTrue((boolean)FSUtils.isAppendSupported(htu.getConfiguration()));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void WriteDataToHDFS(FileSystem fs, Path file, int dataSize) throws Exception {
        FSDataOutputStream out = fs.create(file);
        byte[] data = new byte[dataSize];
        out.write(data, 0, dataSize);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testcomputeHDFSBlocksDistribution() throws Exception {
        FileStatus status;
        long maxTime;
        DistributedFileSystem fs;
        String[] hosts;
        HBaseTestingUtility htu = new HBaseTestingUtility();
        int DEFAULT_BLOCK_SIZE = 1024;
        htu.getConfiguration().setLong("dfs.blocksize", 1024L);
        MiniDFSCluster cluster = null;
        Path testFile = null;
        try {
            boolean ok;
            hosts = new String[]{"host1", "host2", "host3"};
            cluster = htu.startMiniDFSCluster(hosts);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            testFile = new Path("/test1.txt");
            this.WriteDataToHDFS((FileSystem)fs, testFile, 2048);
            maxTime = System.currentTimeMillis() + 2000L;
            do {
                ok = true;
                status = fs.getFileStatus(testFile);
                HDFSBlocksDistribution blocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, status, 0L, status.getLen());
                long uniqueBlocksTotalWeight = blocksDistribution.getUniqueBlocksTotalWeight();
                for (String host : hosts) {
                    long weight = blocksDistribution.getWeight(host);
                    ok = ok && uniqueBlocksTotalWeight == weight;
                }
            } while (!ok && System.currentTimeMillis() < maxTime);
            Assert.assertTrue((boolean)ok);
        }
        finally {
            htu.shutdownMiniDFSCluster();
        }
        try {
            String tophost;
            long weight;
            FileStatus status2;
            HDFSBlocksDistribution blocksDistribution;
            long uniqueBlocksTotalWeight;
            hosts = new String[]{"host1", "host2", "host3", "host4"};
            cluster = htu.startMiniDFSCluster(hosts);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            testFile = new Path("/test2.txt");
            this.WriteDataToHDFS((FileSystem)fs, testFile, 3072);
            maxTime = System.currentTimeMillis() + 2000L;
            while ((uniqueBlocksTotalWeight = (blocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, status2 = fs.getFileStatus(testFile), 0L, status2.getLen())).getUniqueBlocksTotalWeight()) != (weight = blocksDistribution.getWeight(tophost = blocksDistribution.getTopHosts().get(0))) && System.currentTimeMillis() < maxTime) {
            }
            Assert.assertTrue((uniqueBlocksTotalWeight == weight ? 1 : 0) != 0);
        }
        finally {
            htu.shutdownMiniDFSCluster();
        }
        try {
            HDFSBlocksDistribution blocksDistribution;
            hosts = new String[]{"host1", "host2", "host3", "host4"};
            cluster = htu.startMiniDFSCluster(hosts);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            testFile = new Path("/test3.txt");
            this.WriteDataToHDFS((FileSystem)fs, testFile, 1024);
            maxTime = System.currentTimeMillis() + 2000L;
            while ((blocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, status = fs.getFileStatus(testFile), 0L, status.getLen())).getTopHosts().size() != 3 && System.currentTimeMillis() < maxTime) {
            }
            Assert.assertEquals((String)"Wrong number of hosts distributing blocks.", (long)3L, (long)blocksDistribution.getTopHosts().size());
        }
        finally {
            htu.shutdownMiniDFSCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPermMask() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FsPermission defaultFsPerm = FSUtils.getFilePermissions(fs, conf, "hbase.data.umask");
        Assert.assertEquals((Object)FsPermission.getFileDefault(), (Object)defaultFsPerm);
        conf.setBoolean("hbase.data.umask.enable", true);
        FsPermission defaultStartPerm = FSUtils.getFilePermissions(fs, conf, "hbase.data.umask");
        Assert.assertEquals((Object)new FsPermission("777"), (Object)defaultStartPerm);
        conf.setStrings("hbase.data.umask", new String[]{"077"});
        FsPermission filePerm = FSUtils.getFilePermissions(fs, conf, "hbase.data.umask");
        Assert.assertEquals((Object)new FsPermission("700"), (Object)filePerm);
        Path p = new Path("target" + File.separator + UUID.randomUUID().toString());
        try {
            FSDataOutputStream out = FSUtils.create(fs, p, filePerm, null);
            out.close();
            FileStatus stat = fs.getFileStatus(p);
            Assert.assertEquals((Object)new FsPermission("700"), (Object)stat.getPermission());
        }
        finally {
            fs.delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAndExists() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        Configuration conf = htu.getConfiguration();
        conf.setBoolean("hbase.data.umask.enable", true);
        FileSystem fs = FileSystem.get((Configuration)conf);
        FsPermission perms = FSUtils.getFilePermissions(fs, conf, "hbase.data.umask");
        String file = UUID.randomUUID().toString();
        Path p = new Path(htu.getDataTestDir(), "temptarget" + File.separator + file);
        Path p1 = new Path(htu.getDataTestDir(), "temppath" + File.separator + file);
        try {
            FSDataOutputStream out = FSUtils.create(fs, p, perms, null);
            out.close();
            Assert.assertTrue((String)"The created file should be present", (boolean)FSUtils.isExists(fs, p));
            FSUtils.delete(fs, p, false);
            FSDataOutputStream out1 = FSUtils.create(fs, p1, perms, null);
            out1.close();
            FSUtils.delete(fs, p1, true);
            Assert.assertFalse((String)"The created file should be present", (boolean)FSUtils.isExists(fs, p1));
        }
        finally {
            FSUtils.delete(fs, p, true);
            FSUtils.delete(fs, p1, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameAndSetModifyTime() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        Configuration conf = htu.getConfiguration();
        MiniDFSCluster cluster = htu.startMiniDFSCluster(1);
        Assert.assertTrue((boolean)FSUtils.isHDFS(conf));
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testDir = htu.getDataTestDirOnTestFS("testArchiveFile");
        String file = UUID.randomUUID().toString();
        Path p = new Path(testDir, file);
        FSDataOutputStream out = fs.create(p);
        out.close();
        Assert.assertTrue((String)"The created file should be present", (boolean)FSUtils.isExists(fs, p));
        long expect = System.currentTimeMillis() + 1000L;
        Assert.assertNotEquals((long)expect, (long)fs.getFileStatus(p).getModificationTime());
        ManualEnvironmentEdge mockEnv = new ManualEnvironmentEdge();
        mockEnv.setValue(expect);
        EnvironmentEdgeManager.injectEdge(mockEnv);
        try {
            String dstFile = UUID.randomUUID().toString();
            Path dst = new Path(testDir, dstFile);
            Assert.assertTrue((boolean)FSUtils.renameAndSetModifyTime(fs, p, dst));
            Assert.assertFalse((String)"The moved file should not be present", (boolean)FSUtils.isExists(fs, p));
            Assert.assertTrue((String)"The dst file should be present", (boolean)FSUtils.isExists(fs, dst));
            Assert.assertEquals((long)expect, (long)fs.getFileStatus(dst).getModificationTime());
            cluster.shutdown();
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFileInDirWithStoragePolicy(String policy) throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        Configuration conf = htu.getConfiguration();
        conf.set("hbase.wal.storage.policy", policy);
        MiniDFSCluster cluster = htu.startMiniDFSCluster(1);
        try {
            Assert.assertTrue((boolean)FSUtils.isHDFS(conf));
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path testDir = htu.getDataTestDirOnTestFS("testArchiveFile");
            fs.mkdirs(testDir);
            FSUtils.setStoragePolicy(fs, conf, testDir, "hbase.wal.storage.policy", "NONE");
            String file = UUID.randomUUID().toString();
            Path p = new Path(testDir, file);
            this.WriteDataToHDFS(fs, p, 4096);
            this.cleanupFile(fs, testDir);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testSetStoragePolicyDefault() throws Exception {
        this.verifyFileInDirWithStoragePolicy("NONE");
    }

    @Test
    public void testSetStoragePolicyValidButMaybeNotPresent() throws Exception {
        this.verifyFileInDirWithStoragePolicy("ALL_SSD");
    }

    @Test
    public void testSetStoragePolicyInvalid() throws Exception {
        this.verifyFileInDirWithStoragePolicy("1772");
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        Assert.assertTrue((boolean)fileSys.delete(name, true));
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }
}

