/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.htrace.HTraceConfiguration;

@InterfaceAudience.Private
public class HBaseHTraceConfiguration
extends HTraceConfiguration {
    private static final Log LOG = LogFactory.getLog(HBaseHTraceConfiguration.class);
    public static final String KEY_PREFIX = "hbase.htrace.";
    private Configuration conf;

    private void handleDeprecation(String key) {
        String oldKey = "hbase." + key;
        String newKey = KEY_PREFIX + key;
        String oldValue = this.conf.get(oldKey);
        if (oldValue != null) {
            LOG.warn((Object)("Warning: using deprecated configuration key " + oldKey + ".  Please use " + newKey + " instead."));
            String newValue = this.conf.get(newKey);
            if (newValue == null) {
                this.conf.set(newKey, oldValue);
            } else {
                LOG.warn((Object)("Conflicting values for " + newKey + " and " + oldKey + ".  Using " + newValue));
            }
        }
    }

    public HBaseHTraceConfiguration(Configuration conf) {
        this.conf = conf;
        this.handleDeprecation("local-file-span-receiver.path");
        this.handleDeprecation("local-file-span-receiver.capacity");
        this.handleDeprecation("sampler.frequency");
        this.handleDeprecation("sampler.fraction");
        this.handleDeprecation("zipkin.collector-hostname");
        this.handleDeprecation("zipkin.collector-port");
        this.handleDeprecation("zipkin.num-threads");
        this.handleDeprecation("zipkin.traced-service-hostname");
        this.handleDeprecation("zipkin.traced-service-port");
    }

    @Override
    public String get(String key) {
        return this.conf.get(KEY_PREFIX + key);
    }

    @Override
    public String get(String key, String defaultValue) {
        return this.conf.get(KEY_PREFIX + key, defaultValue);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.conf.getBoolean(KEY_PREFIX + key, defaultValue);
    }
}

