/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDurability {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static FileSystem FS;
    private static MiniDFSCluster CLUSTER;
    private static Configuration CONF;
    private static Path DIR;
    private static byte[] FAMILY;
    private static byte[] ROW;
    private static byte[] COL;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CONF = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniDFSCluster(1);
        CLUSTER = TEST_UTIL.getDFSCluster();
        FS = CLUSTER.getFileSystem();
        DIR = TEST_UTIL.getDataTestDirOnTestFS("TestDurability");
        FSUtils.setRootDir(CONF, DIR);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDurability() throws Exception {
        WALFactory wals = new WALFactory(CONF, null, "TestDurability");
        byte[] tableName = Bytes.toBytes("TestDurability");
        WAL wal = wals.getWAL(tableName);
        HRegion region = this.createHRegion(tableName, "region", wal, Durability.USE_DEFAULT);
        HRegion deferredRegion = this.createHRegion(tableName, "deferredRegion", wal, Durability.ASYNC_WAL);
        region.put(this.newPut(null));
        this.verifyWALCount(wals, wal, 1);
        deferredRegion.put(this.newPut(null));
        wal.sync();
        this.verifyWALCount(wals, wal, 2);
        deferredRegion.put(this.newPut(null));
        wal.sync();
        this.verifyWALCount(wals, wal, 3);
        region.put(this.newPut(null));
        this.verifyWALCount(wals, wal, 4);
        deferredRegion.put(this.newPut(Durability.USE_DEFAULT));
        wal.sync();
        this.verifyWALCount(wals, wal, 5);
        region.put(this.newPut(Durability.USE_DEFAULT));
        this.verifyWALCount(wals, wal, 6);
        region.put(this.newPut(Durability.SKIP_WAL));
        deferredRegion.put(this.newPut(Durability.SKIP_WAL));
        this.verifyWALCount(wals, wal, 6);
        wal.sync();
        this.verifyWALCount(wals, wal, 6);
        region.put(this.newPut(Durability.ASYNC_WAL));
        deferredRegion.put(this.newPut(Durability.ASYNC_WAL));
        wal.sync();
        this.verifyWALCount(wals, wal, 8);
        region.put(this.newPut(Durability.SYNC_WAL));
        deferredRegion.put(this.newPut(Durability.SYNC_WAL));
        this.verifyWALCount(wals, wal, 10);
        region.put(this.newPut(Durability.FSYNC_WAL));
        deferredRegion.put(this.newPut(Durability.FSYNC_WAL));
        this.verifyWALCount(wals, wal, 12);
    }

    @Test
    public void testIncrement() throws Exception {
        byte[] row1 = Bytes.toBytes("row1");
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        WALFactory wals = new WALFactory(CONF, null, "TestIncrement");
        byte[] tableName = Bytes.toBytes("TestIncrement");
        WAL wal = wals.getWAL(tableName);
        HRegion region = this.createHRegion(tableName, "increment", wal, Durability.USE_DEFAULT);
        Increment inc1 = new Increment(row1);
        inc1.addColumn(FAMILY, col1, 1L);
        Result res = region.increment(inc1);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((long)1L, (long)Bytes.toLong(res.getValue(FAMILY, col1)));
        this.verifyWALCount(wals, wal, 1);
        inc1 = new Increment(row1);
        inc1.addColumn(FAMILY, col1, 0L);
        res = region.increment(inc1);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((long)1L, (long)Bytes.toLong(res.getValue(FAMILY, col1)));
        this.verifyWALCount(wals, wal, 1);
        inc1 = new Increment(row1);
        inc1.addColumn(FAMILY, col1, 0L);
        inc1.addColumn(FAMILY, col2, 0L);
        inc1.addColumn(FAMILY, col3, 0L);
        res = region.increment(inc1);
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertEquals((long)1L, (long)Bytes.toLong(res.getValue(FAMILY, col1)));
        Assert.assertEquals((long)0L, (long)Bytes.toLong(res.getValue(FAMILY, col2)));
        Assert.assertEquals((long)0L, (long)Bytes.toLong(res.getValue(FAMILY, col3)));
        this.verifyWALCount(wals, wal, 1);
        inc1 = new Increment(row1);
        inc1.addColumn(FAMILY, col1, 5L);
        inc1.addColumn(FAMILY, col2, 4L);
        inc1.addColumn(FAMILY, col3, 3L);
        res = region.increment(inc1);
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertEquals((long)6L, (long)Bytes.toLong(res.getValue(FAMILY, col1)));
        Assert.assertEquals((long)4L, (long)Bytes.toLong(res.getValue(FAMILY, col2)));
        Assert.assertEquals((long)3L, (long)Bytes.toLong(res.getValue(FAMILY, col3)));
        this.verifyWALCount(wals, wal, 2);
    }

    @Test
    public void testIncrementWithReturnResultsSetToFalse() throws Exception {
        byte[] row1 = Bytes.toBytes("row1");
        byte[] col1 = Bytes.toBytes("col1");
        WALFactory wals = new WALFactory(CONF, null, "testIncrementWithReturnResultsSetToFalse");
        byte[] tableName = Bytes.toBytes("testIncrementWithReturnResultsSetToFalse");
        WAL wal = wals.getWAL(tableName);
        HRegion region = this.createHRegion(tableName, "increment", wal, Durability.USE_DEFAULT);
        Increment inc1 = new Increment(row1);
        inc1.setReturnResults(false);
        inc1.addColumn(FAMILY, col1, 1L);
        Result res = region.increment(inc1);
        Assert.assertNull((Object)res);
    }

    private Put newPut(Durability durability) {
        Put p = new Put(ROW);
        p.add(FAMILY, COL, COL);
        if (durability != null) {
            p.setDurability(durability);
        }
        return p;
    }

    private void verifyWALCount(WALFactory wals, WAL log, int expected) throws Exception {
        Path walPath = DefaultWALProvider.getCurrentFileName(log);
        WAL.Reader reader = wals.createReader(FS, walPath);
        int count = 0;
        WAL.Entry entry = new WAL.Entry();
        while (reader.next(entry) != null) {
            ++count;
        }
        reader.close();
        Assert.assertEquals((long)expected, (long)count);
    }

    private HRegion createHRegion(byte[] tableName, String callingMethod, WAL log, Durability durability) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(tableName));
        htd.setDurability(durability);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        Path path = new Path(DIR + callingMethod);
        if (FS.exists(path) && !FS.delete(path, true)) {
            throw new IOException("Failed delete of " + path);
        }
        return HRegion.createHRegion(info, path, CONF, htd, log);
    }

    static {
        FAMILY = Bytes.toBytes("family");
        ROW = Bytes.toBytes("row");
        COL = Bytes.toBytes("col");
    }
}

