/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestQosFunction {
    @Test
    public void testPriority() {
        Configuration conf = HBaseConfiguration.create();
        RSRpcServices rpcServices = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        Mockito.when((Object)rpcServices.getConfiguration()).thenReturn((Object)conf);
        AnnotationReadingPriorityFunction qosFunction = new AnnotationReadingPriorityFunction(rpcServices, RSRpcServices.class);
        this.checkMethod("ReplicateWALEntry", 5, qosFunction);
        this.checkMethod("OpenRegion", 100, qosFunction);
        this.checkMethod("Multi", 0, qosFunction, (Message)ClientProtos.MultiRequest.getDefaultInstance());
    }

    @Test
    public void testRegionInTransition() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        Superusers.initialize(conf);
        RSRpcServices rpcServices = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        Mockito.when((Object)rpcServices.getConfiguration()).thenReturn((Object)conf);
        AnnotationReadingPriorityFunction qosFunction = new AnnotationReadingPriorityFunction(rpcServices, RSRpcServices.class);
        HBaseProtos.RegionInfo meta_ri = HRegionInfo.convert(HRegionInfo.FIRST_META_REGIONINFO);
        HBaseProtos.RegionInfo normal_ri = HRegionInfo.convert(new HRegionInfo(TableName.valueOf("test:table"), Bytes.toBytes("a"), Bytes.toBytes("b"), false));
        RegionServerStatusProtos.RegionStateTransition metaTransition = RegionServerStatusProtos.RegionStateTransition.newBuilder().addRegionInfo(meta_ri).setTransitionCode(RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED).build();
        RegionServerStatusProtos.RegionStateTransition normalTransition = RegionServerStatusProtos.RegionStateTransition.newBuilder().addRegionInfo(normal_ri).setTransitionCode(RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED).build();
        RegionServerStatusProtos.ReportRegionStateTransitionRequest metaTransitionRequest = RegionServerStatusProtos.ReportRegionStateTransitionRequest.newBuilder().setServer(ProtobufUtil.toServerName(ServerName.valueOf("locahost:60020", 100L))).addTransition(normalTransition).addTransition(metaTransition).build();
        RegionServerStatusProtos.ReportRegionStateTransitionRequest normalTransitionRequest = RegionServerStatusProtos.ReportRegionStateTransitionRequest.newBuilder().setServer(ProtobufUtil.toServerName(ServerName.valueOf("locahost:60020", 100L))).addTransition(normalTransition).build();
        String reportFuncName = "ReportRegionStateTransition";
        this.checkMethod("ReportRegionStateTransition", 200, qosFunction, (Message)metaTransitionRequest);
        this.checkMethod("ReportRegionStateTransition", 0, qosFunction, (Message)normalTransitionRequest);
    }

    private void checkMethod(String methodName, int expected, AnnotationReadingPriorityFunction qosf) {
        this.checkMethod(methodName, expected, qosf, null);
    }

    private void checkMethod(String methodName, int expected, AnnotationReadingPriorityFunction qosf, Message param) {
        RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
        builder.setMethodName(methodName);
        Assert.assertEquals((String)methodName, (long)expected, (long)qosf.getPriority(builder.build(), param));
    }
}

