/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestFlushRegionEntry {
    @BeforeClass
    public static void setUp() throws Exception {
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        edge.setValue(12345L);
        EnvironmentEdgeManager.injectEdge(edge);
    }

    @AfterClass
    public static void teardown() {
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testFlushRegionEntryEquality() {
        HRegionInfo hri = new HRegionInfo(1L, TableName.valueOf("TestTable"), 0);
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)hri).when((Object)r)).getRegionInfo();
        MemStoreFlusher.FlushRegionEntry entry = new MemStoreFlusher.FlushRegionEntry(r, true);
        MemStoreFlusher.FlushRegionEntry other = new MemStoreFlusher.FlushRegionEntry(r, true);
        Assert.assertEquals((long)entry.hashCode(), (long)other.hashCode());
        Assert.assertEquals((Object)entry, (Object)other);
    }
}

