/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.jmock.Expectations;
import org.jmock.api.ThreadingPolicy;
import org.jmock.integration.junit4.JUnitRuleMockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.concurrent.Synchroniser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestBulkLoad {
    @ClassRule
    public static TemporaryFolder testFolder = new TemporaryFolder();
    @Rule
    public final JUnitRuleMockery context = new JUnitRuleMockery(){
        {
            this.setThreadingPolicy((ThreadingPolicy)new Synchroniser());
        }
    };
    private final WAL log = (WAL)this.context.mock(WAL.class);
    private final Configuration conf = HBaseConfiguration.create();
    private final Random random = new Random();
    private final byte[] randomBytes = new byte[100];
    private final byte[] family1 = Bytes.toBytes("family1");
    private final byte[] family2 = Bytes.toBytes("family2");
    private final Expectations callOnce;
    @Rule
    public TestName name = new TestName();

    public TestBulkLoad() throws IOException {
        this.callOnce = new Expectations(){
            {
                ((WAL)this.oneOf(TestBulkLoad.this.log)).append((HTableDescriptor)this.with(2.any(HTableDescriptor.class)), (HRegionInfo)this.with(2.any(HRegionInfo.class)), (WALKey)this.with(2.any(WALKey.class)), (WALEdit)this.with(TestBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)), (AtomicLong)this.with(2.any(AtomicLong.class)), this.with(2.any(Boolean.TYPE)), (List)this.with(2.any(List.class)));
                this.will(2.returnValue((Object)0L));
                ((WAL)this.oneOf(TestBulkLoad.this.log)).sync(this.with(2.any(Long.TYPE)));
            }
        };
    }

    @Before
    public void before() throws IOException {
        this.random.nextBytes(this.randomBytes);
    }

    @Test
    public void verifyBulkLoadEvent() throws IOException {
        TableName tableName = TableName.valueOf("test", "test");
        List<Pair<byte[], String>> familyPaths = this.withFamilyPathsFor(new byte[][]{this.family1});
        byte[] familyName = familyPaths.get(0).getFirst();
        String storeFileName = familyPaths.get(0).getSecond();
        storeFileName = new Path(storeFileName).getName();
        ArrayList<String> storeFileNames = new ArrayList<String>();
        storeFileNames.add(storeFileName);
        final Matcher<WALEdit> bulkEventMatcher = TestBulkLoad.bulkLogWalEdit(WALEdit.BULK_LOAD, tableName.toBytes(), familyName, storeFileNames);
        Expectations expection = new Expectations(){
            {
                ((WAL)this.oneOf(TestBulkLoad.this.log)).append((HTableDescriptor)this.with(3.any(HTableDescriptor.class)), (HRegionInfo)this.with(3.any(HRegionInfo.class)), (WALKey)this.with(3.any(WALKey.class)), (WALEdit)this.with(bulkEventMatcher), (AtomicLong)this.with(3.any(AtomicLong.class)), this.with(3.any(Boolean.TYPE)), (List)this.with(3.any(List.class)));
                this.will(3.returnValue((Object)0L));
                ((WAL)this.oneOf(TestBulkLoad.this.log)).sync(this.with(3.any(Long.TYPE)));
            }
        };
        this.context.checking((ExpectationBuilder)expection);
        this.testRegionWithFamiliesAndSpecifiedTableName(tableName, new byte[][]{this.family1}).bulkLoadHFiles(familyPaths, false, null);
    }

    @Test
    public void bulkHLogShouldThrowNoErrorAndWriteMarkerWithBlankInput() throws IOException {
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(new ArrayList<Pair<byte[], String>>(), false, null);
    }

    @Test
    public void shouldBulkLoadSingleFamilyHLog() throws IOException {
        this.context.checking((ExpectationBuilder)this.callOnce);
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(this.withFamilyPathsFor(new byte[][]{this.family1}), false, null);
    }

    @Test
    public void shouldBulkLoadManyFamilyHLog() throws IOException {
        this.context.checking((ExpectationBuilder)this.callOnce);
        this.testRegionWithFamilies(this.family1, this.family2).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2), false, null);
    }

    @Test
    public void shouldBulkLoadManyFamilyHLogEvenWhenTableNameNamespaceSpecified() throws IOException {
        this.context.checking((ExpectationBuilder)this.callOnce);
        TableName tableName = TableName.valueOf("test", "test");
        this.testRegionWithFamiliesAndSpecifiedTableName(tableName, this.family1, this.family2).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2), false, null);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void shouldCrashIfBulkLoadFamiliesNotInTable() throws IOException {
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2), false, null);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void bulkHLogShouldThrowErrorWhenFamilySpecifiedAndHFileExistsButNotInTableDescriptor() throws IOException {
        this.testRegionWithFamilies(new byte[0][]).bulkLoadHFiles(this.withFamilyPathsFor(new byte[][]{this.family1}), false, null);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void shouldThrowErrorIfBadFamilySpecifiedAsFamilyPath() throws IOException {
        this.testRegionWithFamilies(new byte[0][]).bulkLoadHFiles(Arrays.asList(this.withInvalidColumnFamilyButProperHFileLocation(this.family1)), false, null);
    }

    @Test(expected=FileNotFoundException.class)
    public void shouldThrowErrorIfHFileDoesNotExist() throws IOException {
        List<Pair<byte[], String>> list = Arrays.asList(this.withMissingHFileForFamily(this.family1));
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(list, false, null);
    }

    private Pair<byte[], String> withMissingHFileForFamily(byte[] family) {
        return new Pair<byte[], String>(family, "/tmp/does_not_exist");
    }

    private Pair<byte[], String> withInvalidColumnFamilyButProperHFileLocation(byte[] family) throws IOException {
        this.createHFileForFamilies(family);
        return new Pair<byte[], String>(new byte[]{0, 1, 2}, "/tmp/does_not_exist");
    }

    private HRegion testRegionWithFamiliesAndSpecifiedTableName(TableName tableName, byte[] ... families) throws IOException {
        HRegionInfo hRegionInfo = new HRegionInfo(tableName);
        HTableDescriptor hTableDescriptor = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            hTableDescriptor.addFamily(new HColumnDescriptor(family));
        }
        return HRegion.createHRegion(hRegionInfo, new Path(testFolder.newFolder().toURI()), this.conf, hTableDescriptor, this.log);
    }

    private HRegion testRegionWithFamilies(byte[] ... families) throws IOException {
        TableName tableName = TableName.valueOf(this.name.getMethodName());
        return this.testRegionWithFamiliesAndSpecifiedTableName(tableName, families);
    }

    private List<Pair<byte[], String>> getBlankFamilyPaths() {
        return new ArrayList<Pair<byte[], String>>();
    }

    private List<Pair<byte[], String>> withFamilyPathsFor(byte[] ... families) throws IOException {
        List<Pair<byte[], String>> familyPaths = this.getBlankFamilyPaths();
        for (byte[] family : families) {
            familyPaths.add(new Pair<byte[], String>(family, this.createHFileForFamilies(family)));
        }
        return familyPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createHFileForFamilies(byte[] family) throws IOException {
        HFile.WriterFactory hFileFactory = HFile.getWriterFactoryNoCache(this.conf);
        File hFileLocation = testFolder.newFile();
        try (FSDataOutputStream out = new FSDataOutputStream((OutputStream)new FileOutputStream(hFileLocation));){
            hFileFactory.withOutputStream(out);
            hFileFactory.withFileContext(new HFileContext());
            try (HFile.Writer writer = hFileFactory.create();){
                writer.append(new KeyValue(CellUtil.createCell(this.randomBytes, family, this.randomBytes, 0L, KeyValue.Type.Put.getCode(), this.randomBytes)));
            }
        }
        return hFileLocation.getAbsoluteFile().getAbsolutePath();
    }

    private static Matcher<WALEdit> bulkLogWalEditType(byte[] typeBytes) {
        return new WalMatcher(typeBytes);
    }

    private static Matcher<WALEdit> bulkLogWalEdit(byte[] typeBytes, byte[] tableName, byte[] familyName, List<String> storeFileNames) {
        return new WalMatcher(typeBytes, tableName, familyName, storeFileNames);
    }

    private static class WalMatcher
    extends TypeSafeMatcher<WALEdit> {
        private final byte[] typeBytes;
        private final byte[] tableName;
        private final byte[] familyName;
        private final List<String> storeFileNames;

        public WalMatcher(byte[] typeBytes) {
            this(typeBytes, null, null, null);
        }

        public WalMatcher(byte[] typeBytes, byte[] tableName, byte[] familyName, List<String> storeFileNames) {
            this.typeBytes = typeBytes;
            this.tableName = tableName;
            this.familyName = familyName;
            this.storeFileNames = storeFileNames;
        }

        protected boolean matchesSafely(WALEdit item) {
            WALProtos.BulkLoadDescriptor desc;
            Assert.assertTrue((boolean)Arrays.equals(item.getCells().get(0).getQualifier(), this.typeBytes));
            try {
                desc = WALEdit.getBulkLoadDescriptor(item.getCells().get(0));
            }
            catch (IOException e) {
                return false;
            }
            Assert.assertNotNull((Object)desc);
            if (this.tableName != null) {
                Assert.assertTrue((boolean)Bytes.equals(ProtobufUtil.toTableName(desc.getTableName()).getName(), this.tableName));
            }
            if (this.storeFileNames != null) {
                boolean index = false;
                WALProtos.StoreDescriptor store = desc.getStores(0);
                Assert.assertTrue((boolean)Bytes.equals(store.getFamilyName().toByteArray(), this.familyName));
                Assert.assertTrue((boolean)Bytes.equals(Bytes.toBytes(store.getStoreHomeDir()), this.familyName));
                Assert.assertEquals((long)this.storeFileNames.size(), (long)store.getStoreFileCount());
            }
            return true;
        }

        public void describeTo(Description description) {
        }
    }
}

