/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureRunnableSet;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureSimpleRunQueue
implements ProcedureRunnableSet {
    private final Deque<Long> runnables = new ArrayDeque<Long>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitCond = this.lock.newCondition();

    @Override
    public void addFront(Procedure proc) {
        this.lock.lock();
        try {
            this.runnables.addFirst(proc.getProcId());
            this.waitCond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addBack(Procedure proc) {
        this.lock.lock();
        try {
            this.runnables.addLast(proc.getProcId());
            this.waitCond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void yield(Procedure proc) {
        this.addBack(proc);
    }

    @Override
    @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    public Long poll() {
        block8: {
            this.lock.lock();
            try {
                if (this.runnables.isEmpty()) {
                    this.waitCond.await();
                    if (!this.runnables.isEmpty()) {
                        Long l = this.runnables.pop();
                        return l;
                    }
                    break block8;
                }
                Long l = this.runnables.pop();
                return l;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Long l = null;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    @Override
    public void signalAll() {
        this.lock.lock();
        try {
            this.waitCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.runnables.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.runnables.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void completionCleanup(Procedure proc) {
    }
}

