/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestWarmupRegion {
    final Log LOG = LogFactory.getLog(this.getClass());
    protected TableName TABLENAME = TableName.valueOf("testPurgeFutureDeletes");
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes("testRow");
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static byte[] VALUE = Bytes.toBytes("testValue");
    private static byte[] COLUMN = Bytes.toBytes("column");
    private static int numRows = 10000;
    protected static int SLAVES = 3;
    private static MiniHBaseCluster myCluster;
    private static Table table;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        table = TEST_UTIL.createTable(this.TABLENAME, FAMILY);
        for (int i = 0; i < numRows; ++i) {
            long ts = System.currentTimeMillis() * 2L;
            Put put = new Put(ROW, ts);
            put.add(FAMILY, COLUMN, VALUE);
            table.put(put);
        }
        TEST_UTIL.getHBaseAdmin().flush(this.TABLENAME);
        TEST_UTIL.getHBaseAdmin().majorCompact(this.TABLENAME);
        TEST_UTIL.waitFor(6000L, new Waiter.Predicate<IOException>(){

            @Override
            public boolean evaluate() throws IOException {
                return TEST_UTIL.getHBaseAdmin().getCompactionState(TestWarmupRegion.this.TABLENAME) == AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
            }
        });
        table.close();
    }

    @After
    public void tearDown() throws Exception {
    }

    protected void runwarmup() throws InterruptedException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
                HRegion region = TEST_UTIL.getMiniHBaseCluster().getRegions(TestWarmupRegion.this.TABLENAME).get(0);
                HRegionInfo info = region.getRegionInfo();
                try {
                    HTableDescriptor htd = table.getTableDescriptor();
                    for (int i = 0; i < 10; ++i) {
                        HRegion.warmupHRegion(info, htd, rs.getWAL(info), rs.getConfiguration(), rs, null);
                    }
                }
                catch (IOException ie) {
                    TestWarmupRegion.this.LOG.error((Object)("Failed warming up region " + info.getRegionNameAsString()), (Throwable)ie);
                }
            }
        });
        thread.start();
        thread.join();
    }

    @Test
    public void testWarmup() throws Exception {
        int serverid = 0;
        HRegion region = TEST_UTIL.getMiniHBaseCluster().getRegions(this.TABLENAME).get(0);
        HRegionInfo info = region.getRegionInfo();
        this.runwarmup();
        for (int i = 0; i < 10; ++i) {
            HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(serverid);
            byte[] destName = Bytes.toBytes(rs.getServerName().toString());
            TEST_UTIL.getMiniHBaseCluster().getMaster().move(info.getEncodedNameAsBytes(), destName);
            serverid = (serverid + 1) % 2;
        }
    }
}

