/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.security.SecureBulkLoadUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestLoadIncrementalHFiles {
    @Rule
    public TestName tn = new TestName();
    private static final byte[] QUALIFIER = Bytes.toBytes("myqual");
    private static final byte[] FAMILY = Bytes.toBytes("myfam");
    private static final String NAMESPACE = "bulkNS";
    static final String EXPECTED_MSG_FOR_NON_EXISTING_FAMILY = "Unmatched family names found";
    static final int MAX_FILES_PER_REGION_PER_FAMILY = 4;
    private static final byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes("ddd"), Bytes.toBytes("ppp")};
    static HBaseTestingUtility util = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        util.getConfiguration().set("hbase.coprocessor.region.classes", "");
        util.getConfiguration().setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", 4);
        util.getConfiguration().set("hbase.client.rpc.codec", KeyValueCodecWithTags.class.getCanonicalName());
        util.startMiniCluster();
        TestLoadIncrementalHFiles.setupNamespace();
    }

    protected static void setupNamespace() throws Exception {
        util.getHBaseAdmin().createNamespace(NamespaceDescriptor.create(NAMESPACE).build());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testSimpleLoad() throws Exception {
        this.runTest("testSimpleLoad", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes("aaaa"), Bytes.toBytes("cccc")}, new byte[][]{Bytes.toBytes("ddd"), Bytes.toBytes("ooo")}});
    }

    @Test(timeout=60000L)
    public void testRegionCrossingLoad() throws Exception {
        this.runTest("testRegionCrossingLoad", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes("aaaa"), Bytes.toBytes("eee")}, new byte[][]{Bytes.toBytes("fff"), Bytes.toBytes("zzz")}});
    }

    @Test(timeout=60000L)
    public void testRegionCrossingRowBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowBloom", BloomType.ROW, new byte[][][]{new byte[][]{Bytes.toBytes("aaaa"), Bytes.toBytes("eee")}, new byte[][]{Bytes.toBytes("fff"), Bytes.toBytes("zzz")}});
    }

    @Test(timeout=60000L)
    public void testRegionCrossingRowColBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowColBloom", BloomType.ROWCOL, new byte[][][]{new byte[][]{Bytes.toBytes("aaaa"), Bytes.toBytes("eee")}, new byte[][]{Bytes.toBytes("fff"), Bytes.toBytes("zzz")}});
    }

    @Test(timeout=60000L)
    public void testSimpleHFileSplit() throws Exception {
        this.runTest("testHFileSplit", BloomType.NONE, new byte[][]{Bytes.toBytes("aaa"), Bytes.toBytes("fff"), Bytes.toBytes("jjj"), Bytes.toBytes("ppp"), Bytes.toBytes("uuu"), Bytes.toBytes("zzz")}, new byte[][][]{new byte[][]{Bytes.toBytes("aaaa"), Bytes.toBytes("lll")}, new byte[][]{Bytes.toBytes("mmm"), Bytes.toBytes("zzz")}});
    }

    @Test(timeout=60000L)
    public void testRegionCrossingHFileSplit() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.NONE);
    }

    @Test(timeout=60000L)
    public void testRegionCrossingHFileSplitRowBloom() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.ROW);
    }

    @Test(timeout=60000L)
    public void testRegionCrossingHFileSplitRowColBloom() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.ROWCOL);
    }

    private void testRegionCrossingHFileSplit(BloomType bloomType) throws Exception {
        this.runTest("testHFileSplit" + (Object)((Object)bloomType) + "Bloom", bloomType, new byte[][]{Bytes.toBytes("aaa"), Bytes.toBytes("fff"), Bytes.toBytes("jjj"), Bytes.toBytes("ppp"), Bytes.toBytes("uuu"), Bytes.toBytes("zzz")}, new byte[][][]{new byte[][]{Bytes.toBytes("aaaa"), Bytes.toBytes("eee")}, new byte[][]{Bytes.toBytes("fff"), Bytes.toBytes("zzz")}});
    }

    private HTableDescriptor buildHTD(TableName tableName, BloomType bloomType) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        familyDesc.setBloomFilterType(bloomType);
        htd.addFamily(familyDesc);
        return htd;
    }

    private void runTest(String testName, BloomType bloomType, byte[][][] hfileRanges) throws Exception {
        this.runTest(testName, bloomType, null, hfileRanges);
    }

    private void runTest(String testName, BloomType bloomType, byte[][] tableSplitKeys, byte[][][] hfileRanges) throws Exception {
        byte[] TABLE_NAME = Bytes.toBytes("mytable_" + testName);
        boolean preCreateTable = tableSplitKeys != null;
        TableName TABLE_WITHOUT_NS = TableName.valueOf(TABLE_NAME);
        this.runTest(testName, TABLE_WITHOUT_NS, bloomType, preCreateTable, tableSplitKeys, hfileRanges);
        TableName TABLE_WITH_NS = TableName.valueOf(Bytes.toBytes(NAMESPACE), TABLE_NAME);
        this.runTest(testName, TABLE_WITH_NS, bloomType, preCreateTable, tableSplitKeys, hfileRanges);
    }

    private void runTest(String testName, TableName tableName, BloomType bloomType, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges) throws Exception {
        HTableDescriptor htd = this.buildHTD(tableName, bloomType);
        this.runTest(testName, htd, bloomType, preCreateTable, tableSplitKeys, hfileRanges);
    }

    private void runTest(String testName, HTableDescriptor htd, BloomType bloomType, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges) throws Exception {
        for (boolean managed : new boolean[]{true, false}) {
            Object from;
            Path dir = util.getDataTestDirOnTestFS(testName);
            FileSystem fs = util.getTestFileSystem();
            dir = dir.makeQualified(fs);
            Path familyDir = new Path(dir, Bytes.toString(FAMILY));
            int hfileIdx = 0;
            for (byte[][] range : hfileRanges) {
                from = range[0];
                byte[] to = range[1];
                HFileTestUtil.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_" + hfileIdx++), FAMILY, QUALIFIER, (byte[])from, to, 1000);
            }
            int expectedRows = hfileIdx * 1000;
            if (preCreateTable) {
                util.getHBaseAdmin().createTable(htd, tableSplitKeys);
            }
            TableName tableName = htd.getTableName();
            if (!util.getHBaseAdmin().tableExists(tableName)) {
                util.getHBaseAdmin().createTable(htd);
            }
            LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
            if (managed) {
                HTable table = new HTable(util.getConfiguration(), tableName);
                from = null;
                try {
                    loader.doBulkLoad(dir, table);
                    Assert.assertEquals((long)expectedRows, (long)util.countRows(table));
                }
                catch (Throwable to) {
                    from = to;
                    throw to;
                }
                finally {
                    if (table != null) {
                        if (from != null) {
                            try {
                                table.close();
                            }
                            catch (Throwable to) {
                                ((Throwable)from).addSuppressed(to);
                            }
                        } else {
                            table.close();
                        }
                    }
                }
            }
            Connection conn = ConnectionFactory.createConnection(util.getConfiguration());
            from = null;
            try (HTable table = (HTable)conn.getTable(tableName);){
                loader.doBulkLoad(dir, table);
            }
            catch (Throwable throwable) {
                from = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (from != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)from).addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            Path stagingBasePath = SecureBulkLoadUtil.getBaseStagingDir(util.getConfiguration());
            if (fs.exists(stagingBasePath)) {
                FileStatus[] files;
                for (FileStatus file : files = fs.listStatus(stagingBasePath)) {
                    Assert.assertTrue((String)("Folder=" + file.getPath() + " is not cleaned up."), (file.getPath().getName() != "DONOTERASE" ? 1 : 0) != 0);
                }
            }
            util.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void htestTagsSurviveBulkLoadSplit() throws Exception {
        Path dir = util.getDataTestDirOnTestFS(this.tn.getMethodName());
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString(FAMILY));
        byte[][] tableSplitKeys = new byte[][]{Bytes.toBytes("aaa"), Bytes.toBytes("fff"), Bytes.toBytes("jjj"), Bytes.toBytes("ppp"), Bytes.toBytes("uuu"), Bytes.toBytes("zzz")};
        byte[] from = Bytes.toBytes("ddd");
        byte[] to = Bytes.toBytes("ooo");
        HFileTestUtil.createHFileWithTags(util.getConfiguration(), fs, new Path(familyDir, this.tn.getMethodName() + "_hfile"), FAMILY, QUALIFIER, from, to, 1000);
        int expectedRows = 1000;
        TableName tableName = TableName.valueOf(this.tn.getMethodName());
        HTableDescriptor htd = this.buildHTD(tableName, BloomType.NONE);
        util.getHBaseAdmin().createTable(htd, tableSplitKeys);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        String[] args = new String[]{dir.toString(), tableName.toString()};
        loader.run(args);
        try (Table table = util.getConnection().getTable(tableName);){
            Assert.assertEquals((long)expectedRows, (long)util.countRows(table));
            HFileTestUtil.verifyTags(table);
        }
        util.deleteTable(tableName);
    }

    @Test(timeout=60000L)
    public void testNonexistentColumnFamilyLoad() throws Exception {
        String testName = "testNonexistentColumnFamilyLoad";
        byte[][][] hFileRanges = new byte[][][]{new byte[][]{Bytes.toBytes("aaa"), Bytes.toBytes("ccc")}, new byte[][]{Bytes.toBytes("ddd"), Bytes.toBytes("ooo")}};
        byte[] TABLE = Bytes.toBytes("mytable_" + testName);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(TABLE));
        HColumnDescriptor family = new HColumnDescriptor(Bytes.toBytes(new String(FAMILY).toUpperCase()));
        htd.addFamily(family);
        try {
            this.runTest(testName, htd, BloomType.NONE, true, SPLIT_KEYS, (byte[][][])hFileRanges);
            Assert.assertTrue((String)"Loading into table with non-existent family should have failed", (boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"IOException expected", (boolean)(e instanceof IOException));
            String errMsg = e.getMessage();
            Assert.assertTrue((String)("Incorrect exception message, expected message: [Unmatched family names found], current message: [" + errMsg + "]"), (boolean)errMsg.contains(EXPECTED_MSG_FOR_NON_EXISTING_FAMILY));
        }
    }

    @Test(timeout=60000L)
    public void testNonHfileFolderWithUnmatchedFamilyName() throws Exception {
        this.testNonHfileFolder("testNonHfileFolderWithUnmatchedFamilyName", true);
    }

    @Test(timeout=60000L)
    public void testNonHfileFolder() throws Exception {
        this.testNonHfileFolder("testNonHfileFolder", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNonHfileFolder(String tableName, boolean preCreateTable) throws Exception {
        Path dir = util.getDataTestDirOnTestFS(tableName);
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString(FAMILY));
        HFileTestUtil.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_0"), FAMILY, QUALIFIER, Bytes.toBytes("begin"), Bytes.toBytes("end"), 500);
        TestLoadIncrementalHFiles.createRandomDataFile(fs, new Path(familyDir, "012356789"), 16384);
        String NON_FAMILY_FOLDER = "_logs";
        Path nonFamilyDir = new Path(dir, "_logs");
        fs.mkdirs(nonFamilyDir);
        fs.mkdirs(new Path(nonFamilyDir, "non-file"));
        TestLoadIncrementalHFiles.createRandomDataFile(fs, new Path(nonFamilyDir, "012356789"), 16384);
        Table table = null;
        try {
            table = preCreateTable ? util.createTable(TableName.valueOf(tableName), FAMILY) : util.getConnection().getTable(TableName.valueOf(tableName));
            String[] args = new String[]{dir.toString(), tableName};
            new LoadIncrementalHFiles(util.getConfiguration()).run(args);
            Assert.assertEquals((long)500L, (long)util.countRows(table));
        }
        finally {
            if (table != null) {
                table.close();
            }
            fs.delete(dir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createRandomDataFile(FileSystem fs, Path path, int size) throws IOException {
        try (FSDataOutputStream stream = fs.create(path);){
            byte[] data = new byte[1024];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(i & 0xFF);
            }
            while (size >= data.length) {
                stream.write(data, 0, data.length);
                size -= data.length;
            }
            if (size > 0) {
                stream.write(data, 0, size);
            }
        }
    }

    @Test(timeout=60000L)
    public void testSplitStoreFile() throws IOException {
        Path dir = util.getDataTestDirOnTestFS("testSplitHFile");
        FileSystem fs = util.getTestFileSystem();
        Path testIn = new Path(dir, "testhfile");
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        HFileTestUtil.createHFile(util.getConfiguration(), fs, testIn, FAMILY, QUALIFIER, Bytes.toBytes("aaa"), Bytes.toBytes("zzz"), 1000);
        Path bottomOut = new Path(dir, "bottom.out");
        Path topOut = new Path(dir, "top.out");
        LoadIncrementalHFiles.splitStoreFile(util.getConfiguration(), testIn, familyDesc, Bytes.toBytes("ggg"), bottomOut, topOut);
        int rowCount = this.verifyHFile(bottomOut);
        Assert.assertEquals((long)1000L, (long)(rowCount += this.verifyHFile(topOut)));
    }

    @Test
    public void testSplitStoreFileWithNoneToNone() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.NONE, DataBlockEncoding.NONE);
    }

    @Test
    public void testSplitStoreFileWithEncodedToEncoded() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.DIFF, DataBlockEncoding.DIFF);
    }

    @Test
    public void testSplitStoreFileWithEncodedToNone() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.DIFF, DataBlockEncoding.NONE);
    }

    @Test
    public void testSplitStoreFileWithNoneToEncoded() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.NONE, DataBlockEncoding.DIFF);
    }

    private void testSplitStoreFileWithDifferentEncoding(DataBlockEncoding bulkloadEncoding, DataBlockEncoding cfEncoding) throws IOException {
        Path dir = util.getDataTestDirOnTestFS("testSplitHFileWithDifferentEncoding");
        FileSystem fs = util.getTestFileSystem();
        Path testIn = new Path(dir, "testhfile");
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        familyDesc.setDataBlockEncoding(cfEncoding);
        HFileTestUtil.createHFileWithDataBlockEncoding(util.getConfiguration(), fs, testIn, bulkloadEncoding, FAMILY, QUALIFIER, Bytes.toBytes("aaa"), Bytes.toBytes("zzz"), 1000);
        Path bottomOut = new Path(dir, "bottom.out");
        Path topOut = new Path(dir, "top.out");
        LoadIncrementalHFiles.splitStoreFile(util.getConfiguration(), testIn, familyDesc, Bytes.toBytes("ggg"), bottomOut, topOut);
        int rowCount = this.verifyHFile(bottomOut);
        Assert.assertEquals((long)1000L, (long)(rowCount += this.verifyHFile(topOut)));
    }

    private int verifyHFile(Path p) throws IOException {
        Configuration conf = util.getConfiguration();
        HFile.Reader reader = HFile.createReader(p.getFileSystem(conf), p, new CacheConfig(conf), conf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, false);
        scanner.seekTo();
        int count = 0;
        do {
            ++count;
        } while (scanner.next());
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        reader.close();
        return count;
    }

    private void addStartEndKeysForTest(TreeMap<byte[], Integer> map, byte[] first, byte[] last) {
        Integer value = map.containsKey(first) ? map.get(first) : Integer.valueOf(0);
        map.put(first, value + 1);
        value = map.containsKey(last) ? map.get(last) : Integer.valueOf(0);
        map.put(last, value - 1);
    }

    @Test
    public void testInferBoundaries() {
        TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        String first = "a";
        String last = "e";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "r";
        last = "s";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "o";
        last = "p";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "g";
        last = "k";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "v";
        last = "x";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "c";
        last = "i";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "m";
        last = "q";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "s";
        last = "t";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "u";
        last = "w";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        byte[][] keysArray = LoadIncrementalHFiles.inferBoundaries(map);
        byte[][] compare = new byte[][]{"m".getBytes(), "r".getBytes(), "u".getBytes()};
        Assert.assertEquals((long)keysArray.length, (long)3L);
        for (int row = 0; row < keysArray.length; ++row) {
            Assert.assertArrayEquals((byte[])keysArray[row], (byte[])compare[row]);
        }
    }

    @Test(timeout=60000L)
    public void testLoadTooMayHFiles() throws Exception {
        Path dir = util.getDataTestDirOnTestFS("testLoadTooMayHFiles");
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString(FAMILY));
        byte[] from = Bytes.toBytes("begin");
        byte[] to = Bytes.toBytes("end");
        for (int i = 0; i <= 4; ++i) {
            HFileTestUtil.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_" + i), FAMILY, QUALIFIER, from, to, 1000);
        }
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        String[] args = new String[]{dir.toString(), "mytable_testLoadTooMayHFiles"};
        try {
            loader.run(args);
            Assert.fail((String)"Bulk loading too many files should fail");
        }
        catch (IOException ie) {
            Assert.assertTrue((boolean)ie.getMessage().contains("Trying to load more than 4 hfiles"));
        }
    }

    @Test(expected=TableNotFoundException.class)
    public void testWithoutAnExistingTableAndCreateTableSetToNo() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.set("create.table", "no");
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(conf);
        String[] args = new String[]{"directory", "nonExistingTable"};
        loader.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTableWithCFNameStartWithUnderScore() throws Exception {
        Path dir = util.getDataTestDirOnTestFS("cfNameStartWithUnderScore");
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        String family = "_cf";
        Path familyDir = new Path(dir, family);
        byte[] from = Bytes.toBytes("begin");
        byte[] to = Bytes.toBytes("end");
        Configuration conf = util.getConfiguration();
        String tableName = "mytable_cfNameStartWithUnderScore";
        Table table = util.createTable(TableName.valueOf(tableName), family);
        HFileTestUtil.createHFile(conf, fs, new Path(familyDir, "hfile"), Bytes.toBytes(family), QUALIFIER, from, to, 1000);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(conf);
        String[] args = new String[]{dir.toString(), tableName};
        try {
            loader.run(args);
            Assert.assertEquals((long)1000L, (long)util.countRows(table));
        }
        finally {
            if (null != table) {
                table.close();
            }
        }
    }
}

