/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RegionSizeCalculator;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class MultiTableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    final Log LOG = LogFactory.getLog(MultiTableInputFormatBase.class);
    private List<Scan> scans;
    private TableRecordReader tableRecordReader = null;

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TableSplit tSplit = (TableSplit)split;
        this.LOG.info((Object)MessageFormat.format("Input split length: {0} bytes.", tSplit.getLength()));
        if (tSplit.getTable() == null) {
            throw new IOException("Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.");
        }
        final Connection connection = ConnectionFactory.createConnection(context.getConfiguration());
        Table table = connection.getTable(tSplit.getTable());
        if (this.tableRecordReader == null) {
            this.tableRecordReader = new TableRecordReader();
        }
        final TableRecordReader trr = this.tableRecordReader;
        try {
            Scan sc = tSplit.getScan();
            sc.setStartRow(tSplit.getStartRow());
            sc.setStopRow(tSplit.getEndRow());
            trr.setScan(sc);
            trr.setTable(table);
            return new RecordReader<ImmutableBytesWritable, Result>(){

                public void close() throws IOException {
                    trr.close();
                    if (connection != null) {
                        connection.close();
                    }
                }

                public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
                    return trr.getCurrentKey();
                }

                public Result getCurrentValue() throws IOException, InterruptedException {
                    return trr.getCurrentValue();
                }

                public float getProgress() throws IOException, InterruptedException {
                    return trr.getProgress();
                }

                public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
                    trr.initialize(inputsplit, context);
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    return trr.nextKeyValue();
                }
            };
        }
        catch (IOException ioe) {
            trr.close();
            if (connection != null) {
                connection.close();
            }
            throw ioe;
        }
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        ArrayList<Scan> scanList;
        TableName tableName;
        if (this.scans.isEmpty()) {
            throw new IOException("No scans were provided.");
        }
        HashMap<TableName, ArrayList<Scan>> tableMaps = new HashMap<TableName, ArrayList<Scan>>();
        for (Scan scan : this.scans) {
            byte[] tableNameBytes = scan.getAttribute("scan.attributes.table.name");
            if (tableNameBytes == null) {
                throw new IOException("A scan object did not have a table name");
            }
            tableName = TableName.valueOf(tableNameBytes);
            scanList = (ArrayList<Scan>)tableMaps.get(tableName);
            if (scanList == null) {
                scanList = new ArrayList<Scan>();
                tableMaps.put(tableName, scanList);
            }
            scanList.add(scan);
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (Map.Entry entry : tableMaps.entrySet()) {
            tableName = (TableName)entry.getKey();
            scanList = (List)entry.getValue();
            Connection conn = ConnectionFactory.createConnection(context.getConfiguration());
            Throwable throwable = null;
            try {
                Table table = conn.getTable(tableName);
                Throwable throwable2 = null;
                try {
                    RegionLocator regionLocator = conn.getRegionLocator(tableName);
                    Throwable throwable3 = null;
                    try {
                        RegionSizeCalculator sizeCalculator = new RegionSizeCalculator(regionLocator, conn.getAdmin());
                        Pair<byte[][], byte[][]> keys = regionLocator.getStartEndKeys();
                        for (Scan scan : scanList) {
                            if (keys == null || keys.getFirst() == null || keys.getFirst().length == 0) {
                                throw new IOException("Expecting at least one region for table : " + tableName.getNameAsString());
                            }
                            int count = 0;
                            byte[] startRow = scan.getStartRow();
                            byte[] stopRow = scan.getStopRow();
                            for (int i = 0; i < keys.getFirst().length; ++i) {
                                if (!this.includeRegionInSplit(keys.getFirst()[i], keys.getSecond()[i]) || startRow.length != 0 && keys.getSecond()[i].length != 0 && Bytes.compareTo(startRow, keys.getSecond()[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo(stopRow, keys.getFirst()[i]) <= 0) continue;
                                byte[] splitStart = startRow.length == 0 || Bytes.compareTo(keys.getFirst()[i], startRow) >= 0 ? keys.getFirst()[i] : startRow;
                                byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo(keys.getSecond()[i], stopRow) <= 0) && keys.getSecond()[i].length > 0 ? keys.getSecond()[i] : stopRow;
                                HRegionLocation hregionLocation = regionLocator.getRegionLocation(keys.getFirst()[i], false);
                                String regionHostname = hregionLocation.getHostname();
                                HRegionInfo regionInfo = hregionLocation.getRegionInfo();
                                long regionSize = sizeCalculator.getRegionSize(regionInfo.getRegionName());
                                TableSplit split = new TableSplit(table.getName(), scan, splitStart, splitStop, regionHostname, regionSize);
                                splits.add(split);
                                if (!this.LOG.isDebugEnabled()) continue;
                                this.LOG.debug((Object)("getSplits: split -> " + count++ + " -> " + split));
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (regionLocator == null) continue;
                        if (throwable3 != null) {
                            try {
                                regionLocator.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        regionLocator.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (table == null) continue;
                    if (throwable2 != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    table.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (conn == null) continue;
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                conn.close();
            }
        }
        return splits;
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    protected List<Scan> getScans() {
        return this.scans;
    }

    protected void setScans(List<Scan> scans) {
        this.scans = scans;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }
}

