/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.CustomHeadersFilter;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;

public class FiltersUtil {
    public static void addCustomHeadersFilterIfPresent(Context context, Configuration configuration) {
        String headersFileLocation = configuration.get("hbase.custom.headers.file");
        if (!StringUtils.isEmpty((String)headersFileLocation)) {
            context.addFilter(FiltersUtil.makeCustomHeadersFilter(headersFileLocation), "/*", 15);
        }
    }

    private static FilterHolder makeCustomHeadersFilter(String headersFileLocation) {
        FilterHolder customHeadersFilter = new FilterHolder(CustomHeadersFilter.class);
        customHeadersFilter.setInitParameter("hbase.custom.headers.file", headersFileLocation);
        return customHeadersFilter;
    }
}

