/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import drill.shaded.hbase.guava.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Cancellable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;

class MultiServerCallable<R>
extends RegionServerCallable<MultiResponse>
implements Cancellable {
    private final MultiAction<R> multiAction;
    private final boolean cellBlock;
    private final PayloadCarryingRpcController controller;

    MultiServerCallable(ClusterConnection connection, TableName tableName, ServerName location, RpcControllerFactory rpcFactory, MultiAction<R> multi) {
        super(connection, tableName, null);
        this.multiAction = multi;
        this.location = new HRegionLocation(null, location);
        this.cellBlock = this.isCellBlock();
        this.controller = rpcFactory.newController();
    }

    @Override
    protected HRegionLocation getLocation() {
        throw new RuntimeException("Cannot get region location for multi-region request");
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        throw new RuntimeException("Cannot get region info for multi-region request");
    }

    MultiAction<R> getMulti() {
        return this.multiAction;
    }

    @Override
    public MultiResponse call(int callTimeout) throws IOException {
        ClientProtos.MultiResponse responseProto;
        int countOfActions = this.multiAction.size();
        if (countOfActions <= 0) {
            throw new DoNotRetryIOException("No Actions");
        }
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        ClientProtos.RegionAction.Builder regionActionBuilder = ClientProtos.RegionAction.newBuilder();
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        ArrayList<CellScannable> cells = null;
        long nonceGroup = this.multiAction.getNonceGroup();
        if (nonceGroup != 0L) {
            multiRequestBuilder.setNonceGroup(nonceGroup);
        }
        for (Map.Entry e : this.multiAction.actions.entrySet()) {
            byte[] regionName = e.getKey();
            List actions = e.getValue();
            regionActionBuilder.clear();
            regionActionBuilder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
            if (this.cellBlock) {
                if (cells == null) {
                    cells = new ArrayList<CellScannable>(countOfActions);
                }
                regionActionBuilder = RequestConverter.buildNoDataRegionAction(regionName, actions, cells, regionActionBuilder, actionBuilder, mutationBuilder);
            } else {
                regionActionBuilder = RequestConverter.buildRegionAction(regionName, actions, regionActionBuilder, actionBuilder, mutationBuilder);
            }
            multiRequestBuilder.addRegionAction(regionActionBuilder.build());
        }
        if (cells != null) {
            this.controller.setCellScanner(CellUtil.createCellScanner(cells));
        }
        this.controller.setPriority(this.getTableName());
        this.controller.setCallTimeout(callTimeout);
        ClientProtos.MultiRequest requestProto = multiRequestBuilder.build();
        try {
            responseProto = this.getStub().multi(this.controller, requestProto);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException(e);
        }
        if (responseProto == null) {
            return null;
        }
        return ResponseConverter.getResults(requestProto, responseProto, this.controller.cellScanner());
    }

    @Override
    public void cancel() {
        this.controller.startCancel();
    }

    @Override
    public boolean isCancelled() {
        return this.controller.isCanceled();
    }

    private boolean isCellBlock() {
        HConnection connection = this.getConnection();
        if (!(connection instanceof ClusterConnection)) {
            return true;
        }
        return ((ClusterConnection)connection).hasCellBlockSupport();
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.setStub(this.getConnection().getClient(this.location.getServerName()));
    }

    @VisibleForTesting
    ServerName getServerName() {
        return this.location.getServerName();
    }
}

