/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.CoprocessorHConnection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.io.MultipleIOException;

public class HTableWrapper
implements HTableInterface {
    private final HTableInterface table;
    private ClusterConnection connection;
    private final List<HTableInterface> openTables;

    public static HTableInterface createWrapper(List<HTableInterface> openTables, TableName tableName, CoprocessorHost.Environment env, ExecutorService pool) throws IOException {
        return new HTableWrapper(openTables, tableName, CoprocessorHConnection.getConnectionForEnvironment(env), pool);
    }

    private HTableWrapper(List<HTableInterface> openTables, TableName tableName, ClusterConnection connection, ExecutorService pool) throws IOException {
        this.table = connection.getTable(tableName, pool);
        this.connection = connection;
        this.openTables = openTables;
        this.openTables.add(this);
    }

    public void internalClose() throws IOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>(2);
        try {
            this.table.close();
        }
        catch (IOException e) {
            exceptions.add(e);
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            throw MultipleIOException.createIOException(exceptions);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.table.getConfiguration();
    }

    @Override
    public void close() throws IOException {
        try {
            this.internalClose();
        }
        finally {
            this.openTables.remove(this);
        }
    }

    @Override
    @Deprecated
    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        Scan scan = Scan.createGetClosestRowOrBeforeReverseScan(row);
        Result startRowResult = null;
        try (ResultScanner resultScanner = this.table.getScanner(scan);){
            startRowResult = resultScanner.next();
        }
        return startRowResult;
    }

    @Override
    public Result get(Get get) throws IOException {
        return this.table.get(get);
    }

    @Override
    public boolean exists(Get get) throws IOException {
        return this.table.exists(get);
    }

    @Override
    public boolean[] existsAll(List<Get> gets) throws IOException {
        return this.table.existsAll(gets);
    }

    @Override
    @Deprecated
    public Boolean[] exists(List<Get> gets) throws IOException {
        boolean[] exists = this.table.existsAll(gets);
        if (exists == null) {
            return null;
        }
        Boolean[] results = new Boolean[exists.length];
        for (int i = 0; i < exists.length; ++i) {
            results[i] = exists[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        return results;
    }

    @Override
    public void put(Put put) throws IOException {
        this.table.put(put);
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        this.table.put(puts);
    }

    @Override
    public void delete(Delete delete) throws IOException {
        this.table.delete(delete);
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        this.table.delete(deletes);
    }

    @Override
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.table.checkAndPut(row, family, qualifier, value, put);
    }

    @Override
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        return this.table.checkAndPut(row, family, qualifier, compareOp, value, put);
    }

    @Override
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.table.checkAndDelete(row, family, qualifier, value, delete);
    }

    @Override
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        return this.table.checkAndDelete(row, family, qualifier, compareOp, value, delete);
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.table.incrementColumnValue(row, family, qualifier, amount);
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        return this.table.incrementColumnValue(row, family, qualifier, amount, durability);
    }

    @Override
    public Result append(Append append) throws IOException {
        return this.table.append(append);
    }

    @Override
    public Result increment(Increment increment) throws IOException {
        return this.table.increment(increment);
    }

    @Override
    public void flushCommits() throws IOException {
        this.table.flushCommits();
    }

    @Override
    public boolean isAutoFlush() {
        return this.table.isAutoFlush();
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        return this.table.getScanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        return this.table.getScanner(family);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        return this.table.getScanner(family, qualifier);
    }

    @Override
    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.table.getTableDescriptor();
    }

    @Override
    public byte[] getTableName() {
        return this.table.getTableName();
    }

    @Override
    public TableName getName() {
        return this.table.getName();
    }

    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        this.table.batch(actions, results);
    }

    @Override
    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        return this.table.batch(actions);
    }

    @Override
    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.table.batchCallback(actions, results, callback);
    }

    @Override
    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        return this.table.batchCallback(actions, callback);
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        return this.table.get(gets);
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return this.table.coprocessorService(row);
    }

    @Override
    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return this.table.coprocessorService(service, startKey, endKey, callable);
    }

    @Override
    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.table.coprocessorService(service, startKey, endKey, callable, callback);
    }

    @Override
    public void mutateRow(RowMutations rm) throws IOException {
        this.table.mutateRow(rm);
    }

    @Override
    public void setAutoFlush(boolean autoFlush) {
        this.table.setAutoFlush(autoFlush);
    }

    @Override
    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.setAutoFlush(autoFlush);
        if (!autoFlush && !clearBufferOnFail) {
            throw new UnsupportedOperationException("Can't do this via wrapper");
        }
    }

    @Override
    public void setAutoFlushTo(boolean autoFlush) {
        this.table.setAutoFlushTo(autoFlush);
    }

    @Override
    public long getWriteBufferSize() {
        return this.table.getWriteBufferSize();
    }

    @Override
    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.table.setWriteBufferSize(writeBufferSize);
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.table.incrementColumnValue(row, family, qualifier, amount, writeToWAL ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
    }

    @Override
    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        return this.table.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype);
    }

    @Override
    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.table.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, callback);
    }

    @Override
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm) throws IOException {
        return this.table.checkAndMutate(row, family, qualifier, compareOp, value, rm);
    }
}

