/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;

@InterfaceAudience.Private
public class IOTestProvider
implements WALProvider {
    private static final Log LOG = LogFactory.getLog(IOTestProvider.class);
    private static final String ALLOWED_OPERATIONS = "hbase.wal.iotestprovider.operations";
    private FSHLog log = null;

    @Override
    public void init(WALFactory factory, Configuration conf, List<WALActionsListener> listeners, String providerId) throws IOException {
        if (null != this.log) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        if (null == providerId) {
            providerId = "default";
        }
        String logPrefix = factory.factoryId + "." + providerId;
        this.log = new IOTestWAL(FileSystem.get((Configuration)conf), FSUtils.getRootDir(conf), DefaultWALProvider.getWALDirectoryName(factory.factoryId), "oldWALs", conf, listeners, true, logPrefix, ".meta".equals(providerId) ? ".meta" : null);
    }

    @Override
    public WAL getWAL(byte[] identifier) throws IOException {
        return this.log;
    }

    @Override
    public void close() throws IOException {
        this.log.close();
    }

    @Override
    public void shutdown() throws IOException {
        this.log.shutdown();
    }

    private static class IOTestWriter
    extends ProtobufLogWriter {
        private boolean doAppends;
        private boolean doSyncs;

        private IOTestWriter() {
        }

        @Override
        public void init(FileSystem fs, Path path, Configuration conf, boolean overwritable) throws IOException {
            Collection operations = conf.getStringCollection(IOTestProvider.ALLOWED_OPERATIONS);
            if (operations.isEmpty() || operations.contains(AllowedOperations.all.name())) {
                this.doSyncs = true;
                this.doAppends = true;
            } else if (operations.contains(AllowedOperations.none.name())) {
                this.doSyncs = false;
                this.doAppends = false;
            } else {
                this.doAppends = operations.contains(AllowedOperations.append.name());
                this.doSyncs = operations.contains(AllowedOperations.sync.name());
            }
            LOG.info((Object)("IOTestWriter initialized with appends " + (this.doAppends ? "enabled" : "disabled") + " and syncs " + (this.doSyncs ? "enabled" : "disabled")));
            super.init(fs, path, conf, overwritable);
        }

        @Override
        public void append(WAL.Entry entry) throws IOException {
            if (this.doAppends) {
                super.append(entry);
            }
        }

        @Override
        public void sync() throws IOException {
            if (this.doSyncs) {
                super.sync();
            }
        }
    }

    private static class IOTestWAL
    extends FSHLog {
        private final boolean doFileRolls;
        private final boolean initialized;
        private WALProvider.Writer noRollsWriter;

        public IOTestWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws IOException {
            super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix);
            Collection operations = conf.getStringCollection(IOTestProvider.ALLOWED_OPERATIONS);
            this.doFileRolls = operations.isEmpty() || operations.contains(AllowedOperations.all.name()) || operations.contains(AllowedOperations.fileroll.name());
            this.initialized = true;
            LOG.info((Object)("Initialized with file rolling " + (this.doFileRolls ? "enabled" : "disabled")));
        }

        @Override
        protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
            if (!this.initialized || this.doFileRolls) {
                LOG.info((Object)"creating new writer instance.");
                IOTestWriter writer = new IOTestWriter();
                ((ProtobufLogWriter)writer).init(this.fs, path, this.conf, false);
                if (!this.initialized) {
                    LOG.info((Object)"storing initial writer instance in case file rolling isn't allowed.");
                    this.noRollsWriter = writer;
                }
                return writer;
            }
            LOG.info((Object)"WAL rolling disabled, returning the first writer.");
            return this.noRollsWriter;
        }
    }

    private static enum AllowedOperations {
        all,
        append,
        sync,
        fileroll,
        none;

    }
}

