/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotExistsException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.TestTableName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSnapshotClientRetries {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestSnapshotClientRetries.class);
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", MasterSyncObserver.class.getName());
        TEST_UTIL.startMiniCluster(1);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=60000L, expected=SnapshotExistsException.class)
    public void testSnapshotAlreadyExist() throws Exception {
        String snapshotName = "testSnapshotAlreadyExist";
        TEST_UTIL.createTable(this.TEST_TABLE.getTableName(), "f");
        TEST_UTIL.getHBaseAdmin().snapshot("testSnapshotAlreadyExist", this.TEST_TABLE.getTableName());
        this.snapshotAndAssertOneRetry("testSnapshotAlreadyExist", this.TEST_TABLE.getTableName());
    }

    @Test(timeout=60000L, expected=SnapshotDoesNotExistException.class)
    public void testCloneNonExistentSnapshot() throws Exception {
        String snapshotName = "testCloneNonExistentSnapshot";
        this.cloneAndAssertOneRetry("testCloneNonExistentSnapshot", this.TEST_TABLE.getTableName());
    }

    public void snapshotAndAssertOneRetry(String snapshotName, TableName tableName) throws Exception {
        MasterSyncObserver observer = this.getMasterSyncObserver();
        observer.snapshotCount = new AtomicInteger(0);
        TEST_UTIL.getHBaseAdmin().snapshot(snapshotName, tableName);
        Assert.assertEquals((long)1L, (long)observer.snapshotCount.get());
    }

    public void cloneAndAssertOneRetry(String snapshotName, TableName tableName) throws Exception {
        MasterSyncObserver observer = this.getMasterSyncObserver();
        observer.cloneCount = new AtomicInteger(0);
        TEST_UTIL.getHBaseAdmin().cloneSnapshot(snapshotName, tableName);
        Assert.assertEquals((long)1L, (long)observer.cloneCount.get());
    }

    private MasterSyncObserver getMasterSyncObserver() {
        return (MasterSyncObserver)TEST_UTIL.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class.getName());
    }

    public static class MasterSyncObserver
    extends BaseMasterObserver {
        volatile AtomicInteger snapshotCount = null;
        volatile AtomicInteger cloneCount = null;

        @Override
        public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            if (this.snapshotCount != null) {
                this.snapshotCount.incrementAndGet();
            }
        }

        @Override
        public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
            if (this.cloneCount != null) {
                this.cloneCount.incrementAndGet();
            }
        }
    }
}

