/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestWithDisabledAuthorization {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    private static final String PRIVATE = "private";
    private static final byte[] TEST_FAMILY = Bytes.toBytes("test");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes("q");
    private static final byte[] ZERO = Bytes.toBytes(0L);
    @Rule
    public final TestName TEST_NAME = new TestName();
    private static User SUPERUSER;
    private static User USER_RW;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SecureTestUtil.configureSuperuser(conf);
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.setBoolean("hbase.security.authorization", false);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitUntilAllRegionsAssigned(VisibilityConstants.LABELS_TABLE_NAME);
        SUPERUSER = User.createUserForTesting(conf, "admin", new String[]{"supergroup"});
        USER_RW = User.createUserForTesting(conf, "rwuser", new String[0]);
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    VisibilityClient.addLabels(TEST_UTIL.getConfiguration(), new String[]{TestWithDisabledAuthorization.SECRET, TestWithDisabledAuthorization.CONFIDENTIAL, TestWithDisabledAuthorization.PRIVATE});
                    VisibilityClient.setAuths(TEST_UTIL.getConfiguration(), new String[]{TestWithDisabledAuthorization.SECRET, TestWithDisabledAuthorization.CONFIDENTIAL}, USER_RW.getShortName());
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testManageUserAuths() throws Throwable {
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    VisibilityClient.setAuths(TEST_UTIL.getConfiguration(), new String[]{TestWithDisabledAuthorization.SECRET, TestWithDisabledAuthorization.CONFIDENTIAL}, USER_RW.getShortName());
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
        PrivilegedExceptionAction<List<String>> getAuths = new PrivilegedExceptionAction<List<String>>(){

            @Override
            public List<String> run() throws Exception {
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    authsResponse = VisibilityClient.getAuths(TEST_UTIL.getConfiguration(), USER_RW.getShortName());
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>();
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString(authBS.toByteArray()));
                }
                return authsList;
            }
        };
        List<String> authsList = SUPERUSER.runAs(getAuths);
        Assert.assertEquals((long)2L, (long)authsList.size());
        Assert.assertTrue((boolean)authsList.contains(SECRET));
        Assert.assertTrue((boolean)authsList.contains(CONFIDENTIAL));
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    VisibilityClient.clearAuths(TEST_UTIL.getConfiguration(), new String[]{TestWithDisabledAuthorization.SECRET}, USER_RW.getShortName());
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
        authsList = SUPERUSER.runAs(getAuths);
        Assert.assertEquals((long)1L, (long)authsList.size());
        Assert.assertTrue((boolean)authsList.contains(CONFIDENTIAL));
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    VisibilityClient.clearAuths(TEST_UTIL.getConfiguration(), new String[]{TestWithDisabledAuthorization.CONFIDENTIAL}, USER_RW.getShortName());
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
        authsList = SUPERUSER.runAs(getAuths);
        Assert.assertEquals((long)0L, (long)authsList.size());
    }

    @Test
    public void testPassiveVisibility() throws Exception {
        try (Table t = TestWithDisabledAuthorization.createTableAndWriteDataWithLabels(TableName.valueOf(this.TEST_NAME.getMethodName()), SECRET, PRIVATE, "secret|confidential", "private|confidential");){
            Result[] next;
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[0]));
            try (ResultScanner scanner = t.getScanner(s);){
                next = scanner.next(10);
                Assert.assertEquals((long)next.length, (long)4L);
            }
            s = new Scan();
            s.setAuthorizations(new Authorizations(SECRET));
            scanner = t.getScanner(s);
            var5_7 = null;
            try {
                next = scanner.next(10);
                Assert.assertEquals((long)next.length, (long)4L);
            }
            catch (Throwable next2) {
                var5_7 = next2;
                throw next2;
            }
            finally {
                if (scanner != null) {
                    if (var5_7 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable next2) {
                            var5_7.addSuppressed(next2);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            s = new Scan();
            s.setAuthorizations(new Authorizations(SECRET, CONFIDENTIAL));
            scanner = t.getScanner(s);
            var5_7 = null;
            try {
                next = scanner.next(10);
                Assert.assertEquals((long)next.length, (long)4L);
            }
            catch (Throwable next3) {
                var5_7 = next3;
                throw next3;
            }
            finally {
                if (scanner != null) {
                    if (var5_7 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable next3) {
                            var5_7.addSuppressed(next3);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            s = new Scan();
            s.setAuthorizations(new Authorizations(SECRET, CONFIDENTIAL, PRIVATE));
            scanner = t.getScanner(s);
            var5_7 = null;
            try {
                next = scanner.next(10);
                Assert.assertEquals((long)next.length, (long)4L);
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (var5_7 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
    }

    static Table createTableAndWriteDataWithLabels(TableName tableName, String ... labelExps) throws Exception {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < labelExps.length; ++i) {
            Put put = new Put(Bytes.toBytes("row" + (i + 1)));
            put.addColumn(TEST_FAMILY, TEST_QUALIFIER, Long.MAX_VALUE, ZERO);
            put.setCellVisibility(new CellVisibility(labelExps[i]));
            puts.add(put);
        }
        HTable table = TEST_UTIL.createTable(tableName, TEST_FAMILY);
        table.put(puts);
        return table;
    }
}

