/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerHostname {
    private static final Log LOG = LogFactory.getLog(TestRegionServerHostname.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testInvalidRegionServerHostnameAbortsServer() throws Exception {
        boolean NUM_MASTERS = true;
        boolean NUM_RS = true;
        String invalidHostname = "hostAddr.invalid";
        TEST_UTIL.getConfiguration().set("hbase.regionserver.hostname", invalidHostname);
        try {
            TEST_UTIL.startMiniCluster(1, 1);
        }
        catch (IOException ioe) {
            Throwable t1 = ioe.getCause();
            Throwable t2 = t1.getCause();
            Assert.assertTrue((String)(t1.getMessage() + " - " + t2.getMessage()), (t2.getMessage().contains("Failed resolve of " + invalidHostname) || t2.getMessage().contains("Problem binding to " + invalidHostname) ? 1 : 0) != 0);
            return;
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
        Assert.assertTrue((String)"Failed to validate against invalid hostname", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testRegionServerHostname() throws Exception {
        boolean NUM_MASTERS = true;
        boolean NUM_RS = true;
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface ni = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = ni.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isMulticastAddress()) continue;
                String hostName = addr.getHostName();
                LOG.info((Object)("Found " + hostName + " on " + ni));
                TEST_UTIL.getConfiguration().set("hbase.regionserver.hostname", hostName);
                TEST_UTIL.startMiniCluster(1, 1);
                try {
                    ZooKeeperWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
                    List<String> servers = ZKUtil.listChildrenNoWatch(zkw, zkw.rsZNode);
                    while (servers == null) {
                        Threads.sleep(10L);
                    }
                    Assert.assertTrue((servers.size() == 1 ? 1 : 0) != 0);
                    for (String server : servers) {
                        Assert.assertTrue((String)("From zookeeper: " + server + " hostname: " + hostName), (boolean)server.startsWith(hostName.toLowerCase() + ","));
                    }
                    zkw.close();
                }
                finally {
                    TEST_UTIL.shutdownMiniCluster();
                }
            }
        }
    }
}

