/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class StateMachineProcedure<TEnvironment, TState>
extends Procedure<TEnvironment> {
    private int stateCount = 0;
    private int[] states = null;

    protected abstract Flow executeFromState(TEnvironment var1, TState var2) throws ProcedureYieldException;

    protected abstract void rollbackState(TEnvironment var1, TState var2) throws IOException;

    protected abstract TState getState(int var1);

    protected abstract int getStateId(TState var1);

    protected abstract TState getInitialState();

    protected void setNextState(TState state) {
        this.setNextState(this.getStateId(state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Procedure[] execute(TEnvironment env) throws ProcedureYieldException {
        this.updateTimestamp();
        try {
            Procedure[] procedureArray;
            TState state;
            TState TState = state = this.stateCount > 0 ? this.getState(this.states[this.stateCount - 1]) : this.getInitialState();
            if (this.stateCount == 0) {
                this.setNextState(this.getStateId(state));
            }
            if (this.executeFromState(env, state) == Flow.NO_MORE_STATE) {
                Procedure[] procedureArray2 = null;
                return procedureArray2;
            }
            if (this.isWaiting() || this.isFailed()) {
                procedureArray = null;
            } else {
                Procedure[] procedureArray3 = new Procedure[1];
                procedureArray = procedureArray3;
                procedureArray3[0] = this;
            }
            Procedure[] procedureArray4 = procedureArray;
            return procedureArray4;
        }
        finally {
            this.updateTimestamp();
        }
    }

    @Override
    protected void rollback(TEnvironment env) throws IOException {
        try {
            this.updateTimestamp();
            this.rollbackState(env, this.stateCount > 0 ? this.getState(this.states[this.stateCount - 1]) : this.getInitialState());
            --this.stateCount;
        }
        finally {
            this.updateTimestamp();
        }
    }

    private void setNextState(int stateId) {
        if (this.states == null || this.states.length == this.stateCount) {
            int newCapacity = this.stateCount + 8;
            this.states = this.states != null ? Arrays.copyOf(this.states, newCapacity) : new int[newCapacity];
        }
        this.states[this.stateCount++] = stateId;
    }

    @Override
    protected void serializeStateData(OutputStream stream) throws IOException {
        ProcedureProtos.StateMachineProcedureData.Builder data = ProcedureProtos.StateMachineProcedureData.newBuilder();
        for (int i = 0; i < this.stateCount; ++i) {
            data.addState(this.states[i]);
        }
        data.build().writeDelimitedTo(stream);
    }

    @Override
    protected void deserializeStateData(InputStream stream) throws IOException {
        ProcedureProtos.StateMachineProcedureData data = ProcedureProtos.StateMachineProcedureData.parseDelimitedFrom(stream);
        this.stateCount = data.getStateCount();
        if (this.stateCount > 0) {
            this.states = new int[this.stateCount];
            for (int i = 0; i < this.stateCount; ++i) {
                this.states[i] = data.getState(i);
            }
        } else {
            this.states = null;
        }
    }

    protected static enum Flow {
        HAS_MORE_STATE,
        NO_MORE_STATE;

    }
}

