/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsSnapshot;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.snapshot.MasterSnapshotVerifier;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public abstract class TakeSnapshotHandler
extends EventHandler
implements SnapshotSentinel,
ForeignExceptionSnare {
    private static final Log LOG = LogFactory.getLog(TakeSnapshotHandler.class);
    private volatile boolean finished;
    protected final MasterServices master;
    protected final MetricsSnapshot metricsSnapshot = new MetricsSnapshot();
    protected final HBaseProtos.SnapshotDescription snapshot;
    protected final Configuration conf;
    protected final FileSystem fs;
    protected final Path rootDir;
    private final Path snapshotDir;
    protected final Path workingDir;
    private final MasterSnapshotVerifier verifier;
    protected final ForeignExceptionDispatcher monitor;
    protected final TableLockManager tableLockManager;
    protected final TableLockManager.TableLock tableLock;
    protected final MonitoredTask status;
    protected final TableName snapshotTable;
    protected final SnapshotManifest snapshotManifest;
    protected HTableDescriptor htd;

    public TakeSnapshotHandler(HBaseProtos.SnapshotDescription snapshot, MasterServices masterServices) {
        super(masterServices, EventType.C_M_SNAPSHOT_TABLE);
        assert (snapshot != null) : "SnapshotDescription must not be nul1";
        assert (masterServices != null) : "MasterServices must not be nul1";
        this.master = masterServices;
        this.snapshot = snapshot;
        this.snapshotTable = TableName.valueOf(snapshot.getTable());
        this.conf = this.master.getConfiguration();
        this.fs = this.master.getMasterFileSystem().getFileSystem();
        this.rootDir = this.master.getMasterFileSystem().getRootDir();
        this.snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, this.rootDir);
        this.workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir);
        this.monitor = new ForeignExceptionDispatcher(snapshot.getName());
        this.snapshotManifest = SnapshotManifest.create(this.conf, this.fs, this.workingDir, snapshot, this.monitor);
        this.tableLockManager = this.master.getTableLockManager();
        this.tableLock = this.tableLockManager.writeLock(this.snapshotTable, EventType.C_M_SNAPSHOT_TABLE.toString());
        this.verifier = new MasterSnapshotVerifier(masterServices, snapshot, this.rootDir);
        this.status = TaskMonitor.get().createStatus("Taking " + (Object)((Object)snapshot.getType()) + " snapshot on table: " + this.snapshotTable);
    }

    private HTableDescriptor loadTableDescriptor() throws FileNotFoundException, IOException {
        HTableDescriptor htd = this.master.getTableDescriptors().get(this.snapshotTable);
        if (htd == null) {
            throw new IOException("HTableDescriptor missing for " + this.snapshotTable);
        }
        return htd;
    }

    @Override
    public TakeSnapshotHandler prepare() throws Exception {
        super.prepare();
        this.tableLock.acquire();
        boolean success = false;
        try {
            this.htd = this.loadTableDescriptor();
            success = true;
        }
        finally {
            if (!success) {
                this.releaseTableLock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        String msg = "Running " + (Object)((Object)this.snapshot.getType()) + " table snapshot " + this.snapshot.getName() + " " + (Object)((Object)this.eventType) + " on table " + this.snapshotTable;
        LOG.info((Object)msg);
        this.status.setStatus(msg);
        try {
            SnapshotDescriptionUtils.createInProgressTag(this.workingDir, this.fs);
            SnapshotDescriptionUtils.writeSnapshotInfo(this.snapshot, this.workingDir, this.fs);
            this.snapshotManifest.addTableDescriptor(this.htd);
            this.monitor.rethrowException();
            List<Pair<HRegionInfo, ServerName>> regionsAndLocations = TableName.META_TABLE_NAME.equals(this.snapshotTable) ? new MetaTableLocator().getMetaRegionsAndLocations(this.server.getZooKeeper()) : MetaTableAccessor.getTableRegionsAndLocations(this.server.getZooKeeper(), this.server.getConnection(), this.snapshotTable, false);
            this.snapshotRegions(regionsAndLocations);
            this.monitor.rethrowException();
            HashSet<String> serverNames = new HashSet<String>();
            for (Pair<HRegionInfo, ServerName> p : regionsAndLocations) {
                HRegionInfo hri;
                if (p == null || p.getFirst() == null || p.getSecond() == null || (hri = p.getFirst()).isOffline() && (hri.isSplit() || hri.isSplitParent())) continue;
                serverNames.add(p.getSecond().toString());
            }
            this.status.setStatus("Consolidate snapshot: " + this.snapshot.getName());
            this.snapshotManifest.consolidate();
            this.status.setStatus("Verifying snapshot: " + this.snapshot.getName());
            this.verifier.verifySnapshot(this.workingDir, serverNames);
            this.completeSnapshot(this.snapshotDir, this.workingDir, this.fs);
            msg = "Snapshot " + this.snapshot.getName() + " of table " + this.snapshotTable + " completed";
            this.status.markComplete(msg);
            LOG.info((Object)msg);
            this.metricsSnapshot.addSnapshot(this.status.getCompletionTimestamp() - this.status.getStartTime());
        }
        catch (Exception e) {
            this.status.abort("Failed to complete snapshot " + this.snapshot.getName() + " on table " + this.snapshotTable + " because " + e.getMessage());
            String reason = "Failed taking snapshot " + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " due to exception:" + e.getMessage();
            LOG.error((Object)reason, (Throwable)e);
            ForeignException ee = new ForeignException(reason, e);
            this.monitor.receive(ee);
            this.cancel(reason);
        }
        finally {
            LOG.debug((Object)("Launching cleanup of working dir:" + this.workingDir));
            try {
                LOG.info((Object)("Deleting if exists: " + this.workingDir));
                if (this.fs.exists(this.workingDir) && !this.fs.delete(this.workingDir, true)) {
                    LOG.error((Object)("Couldn't delete snapshot working directory:" + this.workingDir));
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Couldn't delete snapshot working directory:" + this.workingDir));
            }
            this.releaseTableLock();
        }
    }

    protected void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Could not release the table lock", (Throwable)ex);
            }
        }
    }

    public void completeSnapshot(Path snapshotDir, Path workingDir, FileSystem fs) throws SnapshotCreationException, IOException {
        LOG.debug((Object)("Sentinel is done, just moving the snapshot from " + workingDir + " to " + snapshotDir));
        if (!fs.rename(workingDir, snapshotDir)) {
            throw new SnapshotCreationException("Failed to move working directory(" + workingDir + ") to completed directory(" + snapshotDir + ").");
        }
        this.finished = true;
    }

    protected abstract void snapshotRegions(List<Pair<HRegionInfo, ServerName>> var1) throws IOException, KeeperException;

    protected void snapshotDisabledRegion(HRegionInfo regionInfo) throws IOException {
        this.snapshotManifest.addRegion(FSUtils.getTableDir(this.rootDir, this.snapshotTable), regionInfo);
        this.monitor.rethrowException();
        this.status.setStatus("Completed referencing HFiles for offline region " + regionInfo.toString() + " of table: " + this.snapshotTable);
    }

    @Override
    public void cancel(String why) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        LOG.info((Object)("Stop taking snapshot=" + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " because: " + why));
        CancellationException ce = new CancellationException(why);
        this.monitor.receive(new ForeignException(this.master.getServerName().toString(), ce));
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public long getCompletionTimestamp() {
        return this.status.getCompletionTimestamp();
    }

    @Override
    public HBaseProtos.SnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    @Override
    public ForeignException getExceptionIfFailed() {
        return this.monitor.getException();
    }

    @Override
    public void rethrowExceptionIfFailed() throws ForeignException {
        this.monitor.rethrowException();
    }

    @Override
    public void rethrowException() throws ForeignException {
        this.monitor.rethrowException();
    }

    @Override
    public boolean hasException() {
        return this.monitor.hasException();
    }

    @Override
    public ForeignException getException() {
        return this.monitor.getException();
    }
}

