/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.SimpleTotalOrderPartitioner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSimpleTotalOrderPartitioner {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    Configuration conf = TEST_UTIL.getConfiguration();

    @Test
    public void testSplit() throws Exception {
        String start = "a";
        String end = "{";
        SimpleTotalOrderPartitioner<byte[]> p = new SimpleTotalOrderPartitioner<byte[]>();
        this.conf.set("hbase.simpletotalorder.start", start);
        this.conf.set("hbase.simpletotalorder.end", end);
        p.setConf(this.conf);
        ImmutableBytesWritable c = new ImmutableBytesWritable(Bytes.toBytes("c"));
        int partition = p.getPartition(c, HConstants.EMPTY_BYTE_ARRAY, 1);
        Assert.assertEquals((long)0L, (long)partition);
        partition = p.getPartition(c, HConstants.EMPTY_BYTE_ARRAY, 2);
        Assert.assertEquals((long)0L, (long)partition);
        partition = p.getPartition(c, HConstants.EMPTY_BYTE_ARRAY, 3);
        Assert.assertEquals((long)0L, (long)partition);
        ImmutableBytesWritable q = new ImmutableBytesWritable(Bytes.toBytes("q"));
        partition = p.getPartition(q, HConstants.EMPTY_BYTE_ARRAY, 2);
        Assert.assertEquals((long)1L, (long)partition);
        partition = p.getPartition(q, HConstants.EMPTY_BYTE_ARRAY, 3);
        Assert.assertEquals((long)2L, (long)partition);
        ImmutableBytesWritable startBytes = new ImmutableBytesWritable(Bytes.toBytes(start));
        partition = p.getPartition(startBytes, HConstants.EMPTY_BYTE_ARRAY, 2);
        Assert.assertEquals((long)0L, (long)partition);
        partition = p.getPartition(startBytes, HConstants.EMPTY_BYTE_ARRAY, 3);
        Assert.assertEquals((long)0L, (long)partition);
        ImmutableBytesWritable endBytes = new ImmutableBytesWritable(Bytes.toBytes("z"));
        partition = p.getPartition(endBytes, HConstants.EMPTY_BYTE_ARRAY, 2);
        Assert.assertEquals((long)1L, (long)partition);
        partition = p.getPartition(endBytes, HConstants.EMPTY_BYTE_ARRAY, 3);
        Assert.assertEquals((long)2L, (long)partition);
    }
}

