/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.Assert;
import org.junit.Test;

public abstract class TableSnapshotInputFormatTestBase {
    protected final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static final int NUM_REGION_SERVERS = 2;
    protected static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes("f1"), Bytes.toBytes("f2")};
    protected FileSystem fs;
    protected Path rootDir;

    public void setupCluster() throws Exception {
        TableSnapshotInputFormatTestBase.setupConf(this.UTIL.getConfiguration());
        this.UTIL.startMiniCluster(2, true);
        this.rootDir = this.UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        this.fs = this.rootDir.getFileSystem(this.UTIL.getConfiguration());
    }

    public void tearDownCluster() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    private static void setupConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
    }

    protected abstract void testWithMockedMapReduce(HBaseTestingUtility var1, String var2, int var3, int var4) throws Exception;

    protected abstract void testWithMapReduceImpl(HBaseTestingUtility var1, TableName var2, String var3, Path var4, int var5, int var6, boolean var7) throws Exception;

    protected abstract byte[] getStartRow();

    protected abstract byte[] getEndRow();

    @Test
    public void testWithMockedMapReduceSingleRegion() throws Exception {
        this.testWithMockedMapReduce(this.UTIL, "testWithMockedMapReduceSingleRegion", 1, 1);
    }

    @Test
    public void testWithMockedMapReduceMultiRegion() throws Exception {
        this.testWithMockedMapReduce(this.UTIL, "testWithMockedMapReduceMultiRegion", 10, 8);
    }

    @Test
    public void testWithMapReduceSingleRegion() throws Exception {
        this.testWithMapReduce(this.UTIL, "testWithMapReduceSingleRegion", 1, 1, false);
    }

    @Test
    public void testWithMapReduceMultiRegion() throws Exception {
        this.testWithMapReduce(this.UTIL, "testWithMapReduceMultiRegion", 10, 8, false);
    }

    @Test
    public void testWithMapReduceAndOfflineHBaseMultiRegion() throws Exception {
        this.testWithMapReduce(this.UTIL, "testWithMapReduceAndOfflineHBaseMultiRegion", 10, 8, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreSnapshotDoesNotCreateBackRefLinks() throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf("testRestoreSnapshotDoesNotCreateBackRefLinks");
        String snapshotName = "foo";
        try {
            TableSnapshotInputFormatTestBase.createTableAndSnapshot(this.UTIL, tableName, snapshotName, this.getStartRow(), this.getEndRow(), 1);
            Path tmpTableDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            this.testRestoreSnapshotDoesNotCreateBackRefLinksInit(tableName, snapshotName, tmpTableDir);
            Path rootDir = FSUtils.getRootDir(this.UTIL.getConfiguration());
            for (Path regionDir : FSUtils.getRegionDirs(this.fs, FSUtils.getTableDir(rootDir, tableName))) {
                for (Path storeDir : FSUtils.getFamilyDirs(this.fs, regionDir)) {
                    for (FileStatus status : this.fs.listStatus(storeDir)) {
                        System.out.println(status.getPath());
                        if (!StoreFileInfo.isValid(status)) continue;
                        Path archiveStoreDir = HFileArchiveUtil.getStoreArchivePath(this.UTIL.getConfiguration(), tableName, regionDir.getName(), storeDir.getName());
                        Path path = HFileLink.getBackReferencesDir(storeDir, status.getPath().getName());
                        Assert.assertFalse((String)("There is a back reference in " + path), (boolean)this.fs.exists(path));
                        path = HFileLink.getBackReferencesDir(archiveStoreDir, status.getPath().getName());
                        Assert.assertFalse((String)("There is a back reference in " + path), (boolean)this.fs.exists(path));
                    }
                }
            }
        }
        finally {
            this.UTIL.getHBaseAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    public abstract void testRestoreSnapshotDoesNotCreateBackRefLinksInit(TableName var1, String var2, Path var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testWithMapReduce(HBaseTestingUtility util, String snapshotName, int numRegions, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        this.setupCluster();
        util.startMiniMapReduceCluster();
        try {
            Path tableDir = util.getDataTestDirOnTestFS(snapshotName);
            TableName tableName = TableName.valueOf("testWithMapReduce");
            this.testWithMapReduceImpl(util, tableName, snapshotName, tableDir, numRegions, expectedNumSplits, shutdownCluster);
        }
        finally {
            util.shutdownMiniMapReduceCluster();
            this.tearDownCluster();
        }
    }

    protected static void verifyRowFromMap(ImmutableBytesWritable key, Result result) throws IOException {
        byte[] row = key.get();
        CellScanner scanner = result.cellScanner();
        while (scanner.advance()) {
            Cell cell = scanner.current();
            Assert.assertEquals((long)0L, (long)Bytes.compareTo(row, 0, row.length, cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
        }
        for (int j = 0; j < FAMILIES.length; ++j) {
            byte[] actual = result.getValue(FAMILIES[j], FAMILIES[j]);
            Assert.assertArrayEquals((String)("Row in snapshot does not match, expected:" + Bytes.toString(row) + " ,actual:" + Bytes.toString(actual)), (byte[])row, (byte[])actual);
        }
    }

    protected static void createTableAndSnapshot(HBaseTestingUtility util, TableName tableName, String snapshotName, byte[] startRow, byte[] endRow, int numRegions) throws Exception {
        try {
            util.deleteTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (numRegions > 1) {
            util.createTable(tableName, FAMILIES, 1, startRow, endRow, numRegions);
        } else {
            util.createTable(tableName, FAMILIES);
        }
        HBaseAdmin admin = util.getHBaseAdmin();
        HTable table = new HTable(util.getConfiguration(), tableName);
        util.loadTable((Table)table, FAMILIES);
        Path rootDir = FSUtils.getRootDir(util.getConfiguration());
        FileSystem fs = rootDir.getFileSystem(util.getConfiguration());
        SnapshotTestingUtils.createSnapshotAndValidate(admin, tableName, Arrays.asList(FAMILIES), null, snapshotName, rootDir, fs, true);
        byte[] value = Bytes.toBytes("after_snapshot_value");
        util.loadTable((Table)table, FAMILIES, value);
        admin.flush(tableName);
        table.close();
    }
}

