/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.test.RedundantKVGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestHFileDataBlockEncoder {
    private HFileDataBlockEncoder blockEncoder;
    private RedundantKVGenerator generator = new RedundantKVGenerator();
    private boolean includesMemstoreTS;

    public TestHFileDataBlockEncoder(HFileDataBlockEncoder blockEncoder, boolean includesMemstoreTS) {
        this.blockEncoder = blockEncoder;
        this.includesMemstoreTS = includesMemstoreTS;
        System.err.println("Encoding: " + (Object)((Object)blockEncoder.getDataBlockEncoding()) + ", includesMemstoreTS: " + includesMemstoreTS);
    }

    @Test
    public void testEncodingWithCache() throws IOException {
        this.testEncodingWithCacheInternals(false);
        this.testEncodingWithCacheInternals(true);
    }

    private void testEncodingWithCacheInternals(boolean useTag) throws IOException {
        List<KeyValue> kvs = this.generator.generateTestKeyValues(60, useTag);
        HFileBlock block = this.getSampleHFileBlock(kvs, useTag);
        HFileBlock cacheBlock = this.createBlockOnDisk(kvs, block, useTag);
        LruBlockCache blockCache = new LruBlockCache(0x800000L, 32768L);
        BlockCacheKey cacheKey = new BlockCacheKey("test", 0L);
        blockCache.cacheBlock(cacheKey, cacheBlock);
        Cacheable heapSize = blockCache.getBlock(cacheKey, false, false, true);
        Assert.assertTrue((boolean)(heapSize instanceof HFileBlock));
        HFileBlock returnedBlock = (HFileBlock)heapSize;
        if (this.blockEncoder.getDataBlockEncoding() == DataBlockEncoding.NONE) {
            Assert.assertEquals((Object)block.getBufferWithHeader(), (Object)returnedBlock.getBufferWithHeader());
        } else {
            if (BlockType.ENCODED_DATA != returnedBlock.getBlockType()) {
                System.out.println(this.blockEncoder);
            }
            Assert.assertEquals((Object)((Object)BlockType.ENCODED_DATA), (Object)((Object)returnedBlock.getBlockType()));
        }
    }

    @Test
    public void testHeaderSizeInCacheWithoutChecksum() throws Exception {
        this.testHeaderSizeInCacheWithoutChecksumInternals(false);
        this.testHeaderSizeInCacheWithoutChecksumInternals(true);
    }

    private void testHeaderSizeInCacheWithoutChecksumInternals(boolean useTags) throws IOException {
        int headerSize = 24;
        List<KeyValue> kvs = this.generator.generateTestKeyValues(60, useTags);
        ByteBuffer keyValues = RedundantKVGenerator.convertKvToByteBuffer(kvs, this.includesMemstoreTS);
        int size = keyValues.limit();
        ByteBuffer buf = ByteBuffer.allocate(size + headerSize);
        buf.position(headerSize);
        keyValues.rewind();
        buf.put(keyValues);
        HFileContext hfileContext = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(useTags).withBlockSize(0).withChecksumType(ChecksumType.NULL).build();
        HFileBlock block = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, 0L, 0, hfileContext);
        HFileBlock cacheBlock = this.createBlockOnDisk(kvs, block, useTags);
        Assert.assertEquals((long)headerSize, (long)cacheBlock.getDummyHeaderForVersion().length);
    }

    @Test
    public void testEncoding() throws IOException {
        this.testEncodingInternals(false);
        this.testEncodingInternals(true);
    }

    private void testEncodingInternals(boolean useTag) throws IOException {
        List<KeyValue> kvs = this.generator.generateTestKeyValues(60, useTag);
        HFileBlock block = this.getSampleHFileBlock(kvs, useTag);
        HFileBlock blockOnDisk = this.createBlockOnDisk(kvs, block, useTag);
        if (this.blockEncoder.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            Assert.assertEquals((Object)((Object)BlockType.ENCODED_DATA), (Object)((Object)blockOnDisk.getBlockType()));
            Assert.assertEquals((long)this.blockEncoder.getDataBlockEncoding().getId(), (long)blockOnDisk.getDataBlockEncodingId());
        } else {
            Assert.assertEquals((Object)((Object)BlockType.DATA), (Object)((Object)blockOnDisk.getBlockType()));
        }
    }

    private HFileBlock getSampleHFileBlock(List<KeyValue> kvs, boolean useTag) {
        ByteBuffer keyValues = RedundantKVGenerator.convertKvToByteBuffer(kvs, this.includesMemstoreTS);
        int size = keyValues.limit();
        ByteBuffer buf = ByteBuffer.allocate(size + 33);
        buf.position(33);
        keyValues.rewind();
        buf.put(keyValues);
        HFileContext meta = new HFileContextBuilder().withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(useTag).withHBaseCheckSum(true).withCompression(Compression.Algorithm.NONE).withBlockSize(0).withChecksumType(ChecksumType.NULL).build();
        HFileBlock b = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, 0L, 0, meta);
        return b;
    }

    private HFileBlock createBlockOnDisk(List<KeyValue> kvs, HFileBlock block, boolean useTags) throws IOException {
        HFileBlockDefaultEncodingContext context = new HFileBlockDefaultEncodingContext(this.blockEncoder.getDataBlockEncoding(), HConstants.HFILEBLOCK_DUMMY_HEADER, block.getHFileContext());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(block.getDummyHeaderForVersion());
        DataOutputStream dos = new DataOutputStream(baos);
        this.blockEncoder.startBlockEncoding(context, dos);
        for (KeyValue kv : kvs) {
            this.blockEncoder.encode(kv, context, dos);
        }
        HFileBlock.Writer.BufferGrabbingByteArrayOutputStream stream = new HFileBlock.Writer.BufferGrabbingByteArrayOutputStream();
        baos.writeTo(stream);
        this.blockEncoder.endBlockEncoding(context, dos, stream.getBuffer(), BlockType.DATA);
        byte[] encodedBytes = baos.toByteArray();
        int size = encodedBytes.length - block.getDummyHeaderForVersion().length;
        return new HFileBlock(context.getBlockType(), size, size, -1L, ByteBuffer.wrap(encodedBytes), true, 0L, block.getOnDiskDataSizeWithHeader(), block.getHFileContext());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getAllConfigurations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        for (DataBlockEncoding diskAlgo : DataBlockEncoding.values()) {
            for (boolean includesMemstoreTS : new boolean[]{false, true}) {
                HFileDataBlockEncoder dbe = diskAlgo == DataBlockEncoding.NONE ? NoOpDataBlockEncoder.INSTANCE : new HFileDataBlockEncoderImpl(diskAlgo);
                configurations.add(new Object[]{dbe, new Boolean(includesMemstoreTS)});
            }
        }
        return configurations;
    }
}

