/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFuzzyRowFilterEndToEnd {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte fuzzyValue = 63;
    private static final Log LOG = LogFactory.getLog(TestFuzzyRowFilterEndToEnd.class);
    private static int firstPartCardinality = 50;
    private static int secondPartCardinality = 50;
    private static int thirdPartCardinality = 50;
    private static int colQualifiersTotal = 5;
    private static int totalFuzzyKeys = thirdPartCardinality / 2;
    private static String table = "TestFuzzyRowFilterEndToEnd";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.scanner.caching", 1000);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.setLong("hbase.hregion.max.filesize", 0x280000000L);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAllFixedBits() throws IOException {
        String cf = "f";
        String cq = "q";
        String table = "testAllFixedBits";
        HTable ht = TEST_UTIL.createTable(TableName.valueOf(table), Bytes.toBytes(cf), Integer.MAX_VALUE);
        String[] rows = new String[]{"\\x9C\\x00\\x044\\x00\\x00\\x00\\x00", "\\x9C\\x00\\x044\\x01\\x00\\x00\\x00", "\\x9C\\x00\\x044\\x00\\x01\\x00\\x00", "\\x9B\\x00\\x044e\\x9B\\x02\\xBB", "\\x9C\\x00\\x044\\x00\\x00\\x01\\x00", "\\x9C\\x00\\x044\\x00\\x01\\x00\\x01", "\\x9B\\x00\\x044e\\xBB\\xB2\\xBB"};
        for (int i = 0; i < rows.length; ++i) {
            Put p = new Put(Bytes.toBytesBinary(rows[i]));
            p.addColumn(cf.getBytes(), cq.getBytes(), "value".getBytes());
            ht.put(p);
        }
        TEST_UTIL.flush();
        ArrayList<Pair<byte[], byte[]>> data = new ArrayList<Pair<byte[], byte[]>>();
        byte[] fuzzyKey = Bytes.toBytesBinary("\\x9B\\x00\\x044e");
        byte[] mask = new byte[]{0, 0, 0, 0, 0};
        data.add(new Pair<byte[], byte[]>(fuzzyKey, mask));
        FuzzyRowFilter filter = new FuzzyRowFilter(data);
        Scan scan = new Scan();
        scan.setFilter(filter);
        ResultScanner scanner = ht.getScanner(scan);
        int total = 0;
        while (scanner.next() != null) {
            ++total;
        }
        Assert.assertEquals((long)2L, (long)total);
        TEST_UTIL.deleteTable(TableName.valueOf(table));
    }

    @Test
    public void testHBASE14782() throws IOException {
        String cf = "f";
        String cq = "q";
        String table = "HBASE14872";
        HTable ht = TEST_UTIL.createTable(TableName.valueOf(table), Bytes.toBytes(cf), Integer.MAX_VALUE);
        String[] rows = new String[]{"\\x9C\\x00\\x044\\x00\\x00\\x00\\x00", "\\x9C\\x00\\x044\\x01\\x00\\x00\\x00", "\\x9C\\x00\\x044\\x00\\x01\\x00\\x00", "\\x9C\\x00\\x044\\x00\\x00\\x01\\x00", "\\x9C\\x00\\x044\\x00\\x01\\x00\\x01", "\\x9B\\x00\\x044e\\xBB\\xB2\\xBB"};
        String badRow = "\\x9C\\x00\\x03\\xE9e\\xBB{X\\x1Fwts\\x1F\\x15vRX";
        for (int i = 0; i < rows.length; ++i) {
            Put p = new Put(Bytes.toBytesBinary(rows[i]));
            p.addColumn(cf.getBytes(), cq.getBytes(), "value".getBytes());
            ht.put(p);
        }
        Put p = new Put(Bytes.toBytesBinary(badRow));
        p.addColumn(cf.getBytes(), cq.getBytes(), "value".getBytes());
        ht.put(p);
        TEST_UTIL.flush();
        ArrayList<Pair<byte[], byte[]>> data = new ArrayList<Pair<byte[], byte[]>>();
        byte[] fuzzyKey = Bytes.toBytesBinary("\\x00\\x00\\x044");
        byte[] mask = new byte[]{1, 0, 0, 0};
        data.add(new Pair<byte[], byte[]>(fuzzyKey, mask));
        FuzzyRowFilter filter = new FuzzyRowFilter(data);
        Scan scan = new Scan();
        scan.setFilter(filter);
        ResultScanner scanner = ht.getScanner(scan);
        int total = 0;
        while (scanner.next() != null) {
            ++total;
        }
        Assert.assertEquals((long)rows.length, (long)total);
        TEST_UTIL.deleteTable(TableName.valueOf(table));
    }

    @Test
    public void testEndToEnd() throws Exception {
        String cf = "f";
        HTable ht = TEST_UTIL.createTable(TableName.valueOf(table), Bytes.toBytes(cf), Integer.MAX_VALUE);
        for (int i0 = 0; i0 < firstPartCardinality; ++i0) {
            for (int i1 = 0; i1 < secondPartCardinality; ++i1) {
                for (int i2 = 0; i2 < thirdPartCardinality; ++i2) {
                    byte[] rk = new byte[10];
                    ByteBuffer buf = ByteBuffer.wrap(rk);
                    buf.clear();
                    buf.putShort((short)i0);
                    buf.putInt(i1);
                    buf.putInt(i2);
                    for (int c = 0; c < colQualifiersTotal; ++c) {
                        byte[] cq = new byte[4];
                        Bytes.putBytes(cq, 0, Bytes.toBytes(c), 0, 4);
                        Put p = new Put(rk);
                        p.setDurability(Durability.SKIP_WAL);
                        p.add(cf.getBytes(), cq, Bytes.toBytes(c));
                        ht.put(p);
                    }
                }
            }
        }
        TEST_UTIL.flush();
        this.runTest1(ht);
        this.runTest2(ht);
    }

    private void runTest1(Table hTable) throws IOException {
        byte[] mask = new byte[]{0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
        ArrayList<Pair<byte[], byte[]>> list = new ArrayList<Pair<byte[], byte[]>>();
        for (int i = 0; i < totalFuzzyKeys; ++i) {
            byte[] fuzzyKey = new byte[10];
            ByteBuffer buf = ByteBuffer.wrap(fuzzyKey);
            buf.clear();
            buf.putShort((short)2);
            for (int j = 0; j < 4; ++j) {
                buf.put((byte)63);
            }
            buf.putInt(i);
            Pair<byte[], byte[]> pair = new Pair<byte[], byte[]>(fuzzyKey, mask);
            list.add(pair);
        }
        int expectedSize = secondPartCardinality * totalFuzzyKeys * colQualifiersTotal;
        FuzzyRowFilter fuzzyRowFilter0 = new FuzzyRowFilter(list);
        FuzzyRowFilter fuzzyRowFilter1 = new FuzzyRowFilter(list);
        this.runScanner(hTable, expectedSize, fuzzyRowFilter0);
        this.runScanner(hTable, expectedSize, fuzzyRowFilter1);
    }

    private void runTest2(Table hTable) throws IOException {
        byte[] mask = new byte[]{0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
        ArrayList<Pair<byte[], byte[]>> list = new ArrayList<Pair<byte[], byte[]>>();
        for (int i = 0; i < totalFuzzyKeys; ++i) {
            byte[] fuzzyKey = new byte[10];
            ByteBuffer buf = ByteBuffer.wrap(fuzzyKey);
            buf.clear();
            buf.putShort((short)(i * 2));
            for (int j = 0; j < 4; ++j) {
                buf.put((byte)63);
            }
            buf.putInt(i * 2);
            Pair<byte[], byte[]> pair = new Pair<byte[], byte[]>(fuzzyKey, mask);
            list.add(pair);
        }
        int expectedSize = totalFuzzyKeys * secondPartCardinality * colQualifiersTotal;
        FuzzyRowFilter fuzzyRowFilter0 = new FuzzyRowFilter(list);
        FuzzyRowFilter fuzzyRowFilter1 = new FuzzyRowFilter(list);
        this.runScanner(hTable, expectedSize, fuzzyRowFilter0);
        this.runScanner(hTable, expectedSize, fuzzyRowFilter1);
    }

    private void runScanner(Table hTable, int expectedSize, Filter filter) throws IOException {
        String cf = "f";
        Scan scan = new Scan();
        scan.addFamily(cf.getBytes());
        scan.setFilter(filter);
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(table.getBytes());
        HRegion first = regions.get(0);
        first.getScanner(scan);
        RegionScanner scanner = first.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        long timeBeforeScan = System.currentTimeMillis();
        int found = 0;
        while (scanner.next(results)) {
            found += results.size();
            results.clear();
        }
        long scanTime = System.currentTimeMillis() - timeBeforeScan;
        scanner.close();
        LOG.info((Object)("\nscan time = " + scanTime + "ms"));
        LOG.info((Object)("found " + (found += results.size()) + " results\n"));
        Assert.assertEquals((long)expectedSize, (long)found);
    }

    @Test
    public void testFilterList() throws Exception {
        String cf = "f";
        String table = "TestFuzzyRowFiltersInFilterList";
        HTable ht = TEST_UTIL.createTable(TableName.valueOf(table), Bytes.toBytes(cf), Integer.MAX_VALUE);
        for (int i1 = 0; i1 < 5; ++i1) {
            for (int i2 = 0; i2 < 5; ++i2) {
                byte[] rk = new byte[10];
                ByteBuffer buf = ByteBuffer.wrap(rk);
                buf.clear();
                buf.putShort((short)2);
                buf.putInt(i1);
                buf.putInt(i2);
                for (int c = 0; c < 5; ++c) {
                    byte[] cq = new byte[4];
                    Bytes.putBytes(cq, 0, Bytes.toBytes(c), 0, 4);
                    Put p = new Put(rk);
                    p.setDurability(Durability.SKIP_WAL);
                    p.add(cf.getBytes(), cq, Bytes.toBytes(c));
                    ht.put(p);
                    LOG.info((Object)("Inserting: rk: " + Bytes.toStringBinary(rk) + " cq: " + Bytes.toStringBinary(cq)));
                }
            }
        }
        TEST_UTIL.flush();
        this.runTest(ht, 5);
    }

    private void runTest(HTable hTable, int expectedSize) throws IOException {
        byte[] fuzzyKey1 = new byte[10];
        ByteBuffer buf = ByteBuffer.wrap(fuzzyKey1);
        buf.clear();
        buf.putShort((short)2);
        for (int i = 0; i < 4; ++i) {
            buf.put((byte)63);
        }
        buf.putInt(1);
        byte[] mask1 = new byte[]{0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
        byte[] fuzzyKey2 = new byte[10];
        buf = ByteBuffer.wrap(fuzzyKey2);
        buf.clear();
        buf.putShort((short)2);
        buf.putInt(2);
        for (int i = 0; i < 4; ++i) {
            buf.put((byte)63);
        }
        byte[] mask2 = new byte[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 1};
        Pair<byte[], byte[]> pair1 = new Pair<byte[], byte[]>(fuzzyKey1, mask1);
        Pair<byte[], byte[]> pair2 = new Pair<byte[], byte[]>(fuzzyKey2, mask2);
        FuzzyRowFilter fuzzyRowFilter1 = new FuzzyRowFilter(Lists.newArrayList(pair1));
        FuzzyRowFilter fuzzyRowFilter2 = new FuzzyRowFilter(Lists.newArrayList(pair2));
        this.runScanner(hTable, expectedSize, fuzzyRowFilter1, fuzzyRowFilter2);
    }

    private void runScanner(Table hTable, int expectedSize, Filter filter1, Filter filter2) throws IOException {
        Result result;
        String cf = "f";
        Scan scan = new Scan();
        scan.addFamily(cf.getBytes());
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter1, filter2);
        scan.setFilter(filterList);
        ResultScanner scanner = hTable.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        long timeBeforeScan = System.currentTimeMillis();
        while ((result = scanner.next()) != null) {
            for (Cell kv : result.listCells()) {
                LOG.info((Object)("Got rk: " + Bytes.toStringBinary(CellUtil.cloneRow(kv)) + " cq: " + Bytes.toStringBinary(CellUtil.cloneQualifier(kv))));
                results.add(kv);
            }
        }
        long scanTime = System.currentTimeMillis() - timeBeforeScan;
        scanner.close();
        LOG.info((Object)("scan time = " + scanTime + "ms"));
        LOG.info((Object)("found " + results.size() + " results"));
        Assert.assertEquals((long)expectedSize, (long)results.size());
    }
}

