/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class MultiRowMutationEndpoint
extends MultiRowMutationProtos.MultiRowMutationService
implements CoprocessorService,
Coprocessor {
    private RegionCoprocessorEnvironment env;

    @Override
    public void mutateRows(RpcController controller, MultiRowMutationProtos.MutateRowsRequest request, RpcCallback<MultiRowMutationProtos.MutateRowsResponse> done) {
        MultiRowMutationProtos.MutateRowsResponse response = MultiRowMutationProtos.MutateRowsResponse.getDefaultInstance();
        try {
            TreeSet<byte[]> rowsToLock = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            List<ClientProtos.MutationProto> mutateRequestList = request.getMutationRequestList();
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(mutateRequestList.size());
            for (ClientProtos.MutationProto mutationProto : mutateRequestList) {
                mutations.add(ProtobufUtil.toMutation(mutationProto));
            }
            HRegionInfo regionInfo = this.env.getRegion().getRegionInfo();
            for (Mutation m : mutations) {
                if (!HRegion.rowIsInRange(regionInfo, m.getRow())) {
                    String msg = "Requested row out of range '" + Bytes.toStringBinary(m.getRow()) + "'";
                    if (rowsToLock.isEmpty()) {
                        throw new WrongRegionException(msg);
                    }
                    throw new DoNotRetryIOException(msg);
                }
                rowsToLock.add(m.getRow());
            }
            long l = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
            long nonce = request.hasNonce() ? request.getNonce() : 0L;
            this.env.getRegion().mutateRowsWithLocks(mutations, rowsToLock, l, nonce);
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        done.run((Object)response);
    }

    @Override
    public Service getService() {
        return this;
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

