/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.coordination.RegionMergeCoordination;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZkRegionMergeCoordination
implements RegionMergeCoordination {
    private CoordinatedStateManager manager;
    private final ZooKeeperWatcher watcher;
    private static final Log LOG = LogFactory.getLog(ZkRegionMergeCoordination.class);

    public ZkRegionMergeCoordination(CoordinatedStateManager manager, ZooKeeperWatcher watcher) {
        this.manager = manager;
        this.watcher = watcher;
    }

    @Override
    public RegionMergeCoordination.RegionMergeDetails getDefaultDetails() {
        ZkRegionMergeDetails zstd = new ZkRegionMergeDetails();
        zstd.setZnodeVersion(-1);
        return zstd;
    }

    @Override
    public void waitForRegionMergeTransaction(RegionServerServices services, HRegionInfo mergedRegionInfo, HRegion region_a, HRegion region_b, RegionMergeCoordination.RegionMergeDetails details) throws IOException {
        try {
            int spins = 0;
            Stat stat = new Stat();
            ServerName expectedServer = this.manager.getServer().getServerName();
            String node = mergedRegionInfo.getEncodedName();
            ZkRegionMergeDetails zdetails = (ZkRegionMergeDetails)details;
            while (!this.manager.getServer().isStopped() && !services.isStopping()) {
                if (spins % 5 == 0) {
                    LOG.debug((Object)("Still waiting for master to process the pending_merge for " + node));
                    ZkRegionMergeDetails zrmd = (ZkRegionMergeDetails)this.getDefaultDetails();
                    this.transitionMergingNode(mergedRegionInfo, region_a.getRegionInfo(), region_b.getRegionInfo(), expectedServer, zrmd, EventType.RS_ZK_REQUEST_REGION_MERGE, EventType.RS_ZK_REQUEST_REGION_MERGE);
                }
                Thread.sleep(100L);
                ++spins;
                byte[] data = ZKAssign.getDataNoWatch(this.watcher, node, stat);
                if (data == null) {
                    throw new IOException("Data is null, merging node " + node + " no longer exists");
                }
                RegionTransition rt = RegionTransition.parseFrom(data);
                EventType et = rt.getEventType();
                if (et == EventType.RS_ZK_REGION_MERGING) {
                    ServerName serverName = rt.getServerName();
                    if (!serverName.equals(expectedServer)) {
                        throw new IOException("Merging node " + node + " is for " + serverName + ", not us " + expectedServer);
                    }
                    byte[] payloadOfMerging = rt.getPayload();
                    List<HRegionInfo> mergingRegions = HRegionInfo.parseDelimitedFrom(payloadOfMerging, 0, payloadOfMerging.length);
                    assert (mergingRegions.size() == 3);
                    HRegionInfo a = mergingRegions.get(1);
                    HRegionInfo b = mergingRegions.get(2);
                    HRegionInfo hri_a = region_a.getRegionInfo();
                    HRegionInfo hri_b = region_b.getRegionInfo();
                    if (!hri_a.equals(a) || !hri_b.equals(b)) {
                        throw new IOException("Merging node " + node + " is for " + a + ", " + b + ", not expected regions: " + hri_a + ", " + hri_b);
                    }
                    zdetails.setZnodeVersion(stat.getVersion());
                    return;
                }
                if (et == EventType.RS_ZK_REQUEST_REGION_MERGE) continue;
                throw new IOException("Merging node " + node + " moved out of merging to " + (Object)((Object)et));
            }
            throw new IOException("Server is " + (services.isStopping() ? "stopping" : "stopped"));
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Failed getting MERGING znode on " + mergedRegionInfo.getRegionNameAsString(), e);
        }
    }

    @Override
    public void startRegionMergeTransaction(HRegionInfo region, ServerName serverName, HRegionInfo a, HRegionInfo b) throws IOException {
        LOG.debug((Object)this.watcher.prefix("Creating ephemeral node for " + region.getEncodedName() + " in PENDING_MERGE state"));
        byte[] payload = HRegionInfo.toDelimitedByteArray(region, a, b);
        RegionTransition rt = RegionTransition.createRegionTransition(EventType.RS_ZK_REQUEST_REGION_MERGE, region.getRegionName(), serverName, payload);
        String node = ZKAssign.getNodeName(this.watcher, region.getEncodedName());
        try {
            if (!ZKUtil.createEphemeralNodeAndWatch(this.watcher, node, rt.toByteArray())) {
                throw new IOException("Failed create of ephemeral " + node);
            }
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void clean(HRegionInfo hri) {
        try {
            if (!ZKAssign.deleteNode(this.watcher, hri.getEncodedName(), EventType.RS_ZK_REQUEST_REGION_MERGE, this.manager.getServer().getServerName())) {
                ZKAssign.deleteNode(this.watcher, hri.getEncodedName(), EventType.RS_ZK_REGION_MERGING, this.manager.getServer().getServerName());
            }
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info((Object)("Failed cleanup zk node of " + hri.getRegionNameAsString()), (Throwable)e);
        }
        catch (KeeperException e) {
            this.manager.getServer().abort("Failed cleanup zk node of " + hri.getRegionNameAsString(), e);
        }
    }

    @Override
    public void completeRegionMergeTransaction(RegionServerServices services, HRegionInfo mergedRegionInfo, HRegion region_a, HRegion region_b, RegionMergeCoordination.RegionMergeDetails rmd, HRegion mergedRegion) throws IOException {
        ZkRegionMergeDetails zrmd = (ZkRegionMergeDetails)rmd;
        if (this.manager.getServer() == null || this.manager.getServer().getCoordinatedStateManager() == null) {
            return;
        }
        try {
            this.transitionMergingNode(mergedRegionInfo, region_a.getRegionInfo(), region_b.getRegionInfo(), this.manager.getServer().getServerName(), rmd, EventType.RS_ZK_REGION_MERGING, EventType.RS_ZK_REGION_MERGED);
            long startTime = EnvironmentEdgeManager.currentTime();
            int spins = 0;
            do {
                if (spins % 10 == 0) {
                    LOG.debug((Object)("Still waiting on the master to process the merge for " + mergedRegionInfo.getEncodedName() + ", waited " + (EnvironmentEdgeManager.currentTime() - startTime) + "ms"));
                }
                Thread.sleep(100L);
                this.transitionMergingNode(mergedRegionInfo, region_a.getRegionInfo(), region_b.getRegionInfo(), this.manager.getServer().getServerName(), rmd, EventType.RS_ZK_REGION_MERGED, EventType.RS_ZK_REGION_MERGED);
                ++spins;
            } while (zrmd.getZnodeVersion() != -1 && !this.manager.getServer().isStopped() && !services.isStopping());
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Failed telling master about merge " + mergedRegionInfo.getEncodedName(), e);
        }
    }

    @Override
    public void confirmRegionMergeTransaction(HRegionInfo merged, HRegionInfo a, HRegionInfo b, ServerName serverName, RegionMergeCoordination.RegionMergeDetails rmd) throws IOException {
        this.transitionMergingNode(merged, a, b, serverName, rmd, EventType.RS_ZK_REGION_MERGING, EventType.RS_ZK_REGION_MERGING);
    }

    @Override
    public void processRegionMergeRequest(HRegionInfo p, HRegionInfo hri_a, HRegionInfo hri_b, ServerName sn, RegionMergeCoordination.RegionMergeDetails rmd) throws IOException {
        this.transitionMergingNode(p, hri_a, hri_b, sn, rmd, EventType.RS_ZK_REQUEST_REGION_MERGE, EventType.RS_ZK_REGION_MERGING);
    }

    private void transitionMergingNode(HRegionInfo merged, HRegionInfo a, HRegionInfo b, ServerName serverName, RegionMergeCoordination.RegionMergeDetails rmd, EventType beginState, EventType endState) throws IOException {
        ZkRegionMergeDetails zrmd = (ZkRegionMergeDetails)rmd;
        byte[] payload = HRegionInfo.toDelimitedByteArray(merged, a, b);
        try {
            zrmd.setZnodeVersion(ZKAssign.transitionNode(this.watcher, merged, serverName, beginState, endState, zrmd.getZnodeVersion(), payload));
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    public static class ZkRegionMergeDetails
    implements RegionMergeCoordination.RegionMergeDetails {
        private int znodeVersion;

        public int getZnodeVersion() {
            return this.znodeVersion;
        }

        public void setZnodeVersion(int znodeVersion) {
            this.znodeVersion = znodeVersion;
        }
    }
}

