/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSnapshotFromClient {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFromClient.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_RS = 2;
    private static final String STRING_TABLE_NAME = "test";
    protected static final byte[] TEST_FAM = Bytes.toBytes("fam");
    protected static final TableName TABLE_NAME = TableName.valueOf("test");

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotFromClient.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 10);
        conf.setInt("hbase.hstore.compactionThreshold", 10);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
    }

    @Before
    public void setup() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAME);
        htd.setRegionReplication(this.getNumReplicas());
        UTIL.createTable(htd, (byte[][])new byte[][]{TEST_FAM}, UTIL.getConfiguration());
    }

    protected int getNumReplicas() {
        return 1;
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(TABLE_NAME);
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getHBaseAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Test(timeout=300000L)
    public void testMetaTablesSnapshot() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        byte[] snapshotName = Bytes.toBytes("metaSnapshot");
        try {
            admin.snapshot(snapshotName, TableName.META_TABLE_NAME);
            Assert.fail((String)"taking a snapshot of hbase:meta should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testSnapshotDeletionWithRegex() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        HTable table = new HTable(UTIL.getConfiguration(), TABLE_NAME);
        UTIL.loadTable((Table)table, TEST_FAM);
        table.close();
        byte[] snapshot1 = Bytes.toBytes("TableSnapshot1");
        admin.snapshot(snapshot1, TABLE_NAME);
        LOG.debug((Object)"Snapshot1 completed.");
        byte[] snapshot2 = Bytes.toBytes("TableSnapshot2");
        admin.snapshot(snapshot2, TABLE_NAME);
        LOG.debug((Object)"Snapshot2 completed.");
        String snapshot3 = "3rdTableSnapshot";
        admin.snapshot(Bytes.toBytes(snapshot3), TABLE_NAME);
        LOG.debug((Object)(snapshot3 + " completed."));
        admin.deleteSnapshots("TableSnapshot.*");
        List<HBaseProtos.SnapshotDescription> snapshots = admin.listSnapshots();
        Assert.assertEquals((long)1L, (long)snapshots.size());
        Assert.assertEquals((Object)snapshots.get(0).getName(), (Object)snapshot3);
        admin.deleteSnapshot(snapshot3);
        admin.close();
    }

    @Test(timeout=300000L)
    public void testOfflineTableSnapshot() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        HTable table = new HTable(UTIL.getConfiguration(), TABLE_NAME);
        UTIL.loadTable((Table)table, TEST_FAM, false);
        LOG.debug((Object)"FS state before disable:");
        FSUtils.logFileSystemState(UTIL.getTestFileSystem(), FSUtils.getRootDir(UTIL.getConfiguration()), LOG);
        admin.disableTable(TABLE_NAME);
        LOG.debug((Object)"FS state before snapshot:");
        FSUtils.logFileSystemState(UTIL.getTestFileSystem(), FSUtils.getRootDir(UTIL.getConfiguration()), LOG);
        String SNAPSHOT_NAME = "offlineTableSnapshot";
        byte[] snapshot = Bytes.toBytes("offlineTableSnapshot");
        HBaseProtos.SnapshotDescription desc = HBaseProtos.SnapshotDescription.newBuilder().setType(HBaseProtos.SnapshotDescription.Type.DISABLED).setTable(STRING_TABLE_NAME).setName("offlineTableSnapshot").setVersion(0).build();
        admin.snapshot(desc);
        LOG.debug((Object)"Snapshot completed.");
        List<HBaseProtos.SnapshotDescription> snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches((Admin)admin, snapshot, TABLE_NAME);
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        LOG.debug((Object)"FS state after snapshot:");
        FSUtils.logFileSystemState(UTIL.getTestFileSystem(), FSUtils.getRootDir(UTIL.getConfiguration()), LOG);
        SnapshotTestingUtils.confirmSnapshotValid(snapshots.get(0), TABLE_NAME, TEST_FAM, rootDir, admin, fs);
        admin.deleteSnapshot(snapshot);
        snapshots = admin.listSnapshots();
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    @Test(timeout=300000L)
    public void testSnapshotFailsOnNonExistantTable() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        String tableName = "_not_a_table";
        boolean fail = false;
        do {
            try {
                admin.getTableDescriptor(TableName.valueOf(tableName));
                fail = true;
                LOG.error((Object)("Table:" + tableName + " already exists, checking a new name"));
                tableName = tableName + "!";
            }
            catch (TableNotFoundException e) {
                fail = false;
            }
        } while (fail);
        try {
            admin.snapshot("fail", TableName.valueOf(tableName));
            Assert.fail((String)"Snapshot succeeded even though there is not table.");
        }
        catch (SnapshotCreationException e) {
            LOG.info((Object)("Correctly failed to snapshot a non-existant table:" + e.getMessage()));
        }
    }

    @Test(timeout=300000L)
    public void testOfflineTableSnapshotWithEmptyRegions() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        LOG.debug((Object)"FS state before disable:");
        FSUtils.logFileSystemState(UTIL.getTestFileSystem(), FSUtils.getRootDir(UTIL.getConfiguration()), LOG);
        admin.disableTable(TABLE_NAME);
        LOG.debug((Object)"FS state before snapshot:");
        FSUtils.logFileSystemState(UTIL.getTestFileSystem(), FSUtils.getRootDir(UTIL.getConfiguration()), LOG);
        byte[] snapshot = Bytes.toBytes("testOfflineTableSnapshotWithEmptyRegions");
        admin.snapshot(snapshot, TABLE_NAME);
        LOG.debug((Object)"Snapshot completed.");
        List<HBaseProtos.SnapshotDescription> snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches((Admin)admin, snapshot, TABLE_NAME);
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        LOG.debug((Object)"FS state after snapshot:");
        FSUtils.logFileSystemState(UTIL.getTestFileSystem(), FSUtils.getRootDir(UTIL.getConfiguration()), LOG);
        ArrayList<byte[]> emptyCfs = Lists.newArrayList(new byte[][]{TEST_FAM});
        ArrayList<byte[]> nonEmptyCfs = Lists.newArrayList();
        SnapshotTestingUtils.confirmSnapshotValid(snapshots.get(0), TABLE_NAME, nonEmptyCfs, emptyCfs, rootDir, admin, fs);
        admin.deleteSnapshot(snapshot);
        snapshots = admin.listSnapshots();
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }
}

