/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSmallReversedScanner {
    public static final Log LOG = LogFactory.getLog(TestSmallReversedScanner.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf("testReversedSmall");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes("columnFamily");
    private static Table htable = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        byte[] bytes = Bytes.toBytes("bcd");
        byte[][] splitKeys = new byte[bytes.length][];
        for (int i = 0; i < bytes.length; ++i) {
            splitKeys[i] = new byte[]{bytes[i]};
        }
        htable = TEST_UTIL.createTable(TABLE_NAME, COLUMN_FAMILY, (byte[][])splitKeys);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws IOException {
        TEST_UTIL.deleteTableData(TABLE_NAME);
    }

    @Test
    public void testSmallReversedScan01() throws IOException {
        String[][] keysCases = new String[][]{{"d0", "d1", "d2", "d3"}, {"a0", "a1", "a2", "a3"}, {"a0", "b1", "c2", "d3"}};
        for (int caseIndex = 0; caseIndex < keysCases.length; ++caseIndex) {
            this.testSmallReversedScanInternal(keysCases[caseIndex]);
            TEST_UTIL.deleteTableData(TABLE_NAME);
        }
    }

    private void testSmallReversedScanInternal(String[] inputRowKeys) throws IOException {
        Result r;
        int rowCount = inputRowKeys.length;
        for (int i = 0; i < rowCount; ++i) {
            Put put = new Put(Bytes.toBytes(inputRowKeys[i]));
            put.addColumn(COLUMN_FAMILY, null, Bytes.toBytes(i));
            htable.put(put);
        }
        Scan scan = new Scan();
        scan.setReversed(true);
        scan.setSmall(true);
        ResultScanner scanner = htable.getScanner(scan);
        int value = rowCount;
        while ((r = scanner.next()) != null) {
            Assert.assertArrayEquals((byte[])r.getValue(COLUMN_FAMILY, null), (byte[])Bytes.toBytes(--value));
            Assert.assertArrayEquals((byte[])r.getRow(), (byte[])Bytes.toBytes(inputRowKeys[value]));
        }
        Assert.assertEquals((long)value, (long)0L);
    }

    @Test
    public void testSmallReversedScan02() throws IOException {
        Result r;
        Put put = new Put(new byte[]{0});
        put.addColumn(COLUMN_FAMILY, null, Bytes.toBytes(0));
        htable.put(put);
        Scan scan = new Scan();
        scan.setCaching(1);
        scan.setReversed(true);
        scan.setSmall(true);
        ResultScanner scanner = htable.getScanner(scan);
        int count = 1;
        while ((r = scanner.next()) != null) {
            Assert.assertArrayEquals((byte[])r.getValue(COLUMN_FAMILY, null), (byte[])Bytes.toBytes(0));
            Assert.assertArrayEquals((byte[])r.getRow(), (byte[])new byte[]{0});
            Assert.assertTrue((--count >= 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)count, (long)0L);
    }
}

