/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestPutWithDelete {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHbasePutDeleteCell() throws Exception {
        TableName tableName = TableName.valueOf("TestPutWithDelete");
        byte[] rowKey = Bytes.toBytes("12345");
        byte[] family = Bytes.toBytes("cf");
        TEST_UTIL.waitTableAvailable(tableName.getName(), 5000L);
        try (HTable table = TEST_UTIL.createTable(tableName, family);){
            Put put = new Put(rowKey);
            put.add(family, Bytes.toBytes("A"), Bytes.toBytes("a"));
            put.add(family, Bytes.toBytes("B"), Bytes.toBytes("b"));
            put.add(family, Bytes.toBytes("C"), Bytes.toBytes("c"));
            put.add(family, Bytes.toBytes("D"), Bytes.toBytes("d"));
            table.put(put);
            Get get = new Get(rowKey);
            Result result = table.get(get);
            Assert.assertTrue((String)"Column A value should be a", (boolean)Bytes.toString(result.getValue(family, Bytes.toBytes("A"))).equals("a"));
            Assert.assertTrue((String)"Column B value should be b", (boolean)Bytes.toString(result.getValue(family, Bytes.toBytes("B"))).equals("b"));
            Assert.assertTrue((String)"Column C value should be c", (boolean)Bytes.toString(result.getValue(family, Bytes.toBytes("C"))).equals("c"));
            Assert.assertTrue((String)"Column D value should be d", (boolean)Bytes.toString(result.getValue(family, Bytes.toBytes("D"))).equals("d"));
            put = new Put(rowKey);
            put.add(family, Bytes.toBytes("A"), Bytes.toBytes("a1"));
            put.add(family, Bytes.toBytes("B"), Bytes.toBytes("b1"));
            KeyValue marker = new KeyValue(rowKey, family, Bytes.toBytes("C"), Long.MAX_VALUE, KeyValue.Type.DeleteColumn);
            put.add(family, Bytes.toBytes("D"), Bytes.toBytes("d1"));
            put.add(marker);
            table.put(put);
            get = new Get(rowKey);
            result = table.get(get);
            Assert.assertTrue((String)"Column A value should be a1", (boolean)Bytes.toString(result.getValue(family, Bytes.toBytes("A"))).equals("a1"));
            Assert.assertTrue((String)"Column B value should be b1", (boolean)Bytes.toString(result.getValue(family, Bytes.toBytes("B"))).equals("b1"));
            Assert.assertTrue((String)"Column C should not exist", (result.getValue(family, Bytes.toBytes("C")) == null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Column D value should be d1", (boolean)Bytes.toString(result.getValue(family, Bytes.toBytes("D"))).equals("d1"));
        }
    }
}

