/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.FSProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.VersionedWritable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClusterStatus
extends VersionedWritable {
    private static final byte VERSION = 2;
    private String hbaseVersion;
    private Map<ServerName, ServerLoad> liveServers;
    private Collection<ServerName> deadServers;
    private ServerName master;
    private Collection<ServerName> backupMasters;
    private Map<String, RegionState> intransition;
    private String clusterId;
    private String[] masterCoprocessors;
    private Boolean balancerOn;

    @Deprecated
    public ClusterStatus() {
    }

    public ClusterStatus(String hbaseVersion, String clusterid, Map<ServerName, ServerLoad> servers, Collection<ServerName> deadServers, ServerName master, Collection<ServerName> backupMasters, Map<String, RegionState> rit, String[] masterCoprocessors, Boolean balancerOn) {
        this.hbaseVersion = hbaseVersion;
        this.liveServers = servers;
        this.deadServers = deadServers;
        this.master = master;
        this.backupMasters = backupMasters;
        this.intransition = rit;
        this.clusterId = clusterid;
        this.masterCoprocessors = masterCoprocessors;
        this.balancerOn = balancerOn;
    }

    public Collection<ServerName> getDeadServerNames() {
        if (this.deadServers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.deadServers);
    }

    public int getServersSize() {
        return this.liveServers != null ? this.liveServers.size() : 0;
    }

    public int getDeadServers() {
        return this.deadServers != null ? this.deadServers.size() : 0;
    }

    public double getAverageLoad() {
        int load = this.getRegionsCount();
        return (double)load / (double)this.getServersSize();
    }

    public int getRegionsCount() {
        int count = 0;
        if (this.liveServers != null && !this.liveServers.isEmpty()) {
            for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
                count += e.getValue().getNumberOfRegions();
            }
        }
        return count;
    }

    public int getRequestsCount() {
        int count = 0;
        if (this.liveServers != null && !this.liveServers.isEmpty()) {
            for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
                count = (int)((long)count + e.getValue().getNumberOfRequests());
            }
        }
        return count;
    }

    public String getHBaseVersion() {
        return this.hbaseVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterStatus)) {
            return false;
        }
        return this.getVersion() == ((ClusterStatus)((Object)o)).getVersion() && this.getHBaseVersion().equals(((ClusterStatus)((Object)o)).getHBaseVersion()) && this.liveServers.equals(((ClusterStatus)((Object)o)).liveServers) && this.deadServers.containsAll(((ClusterStatus)((Object)o)).deadServers) && Arrays.equals(this.masterCoprocessors, ((ClusterStatus)((Object)o)).masterCoprocessors) && this.master.equals(((ClusterStatus)((Object)o)).master) && this.backupMasters.containsAll(((ClusterStatus)((Object)o)).backupMasters);
    }

    public int hashCode() {
        return 2 + this.hbaseVersion.hashCode() + this.liveServers.hashCode() + this.deadServers.hashCode() + this.master.hashCode() + this.backupMasters.hashCode();
    }

    public byte getVersion() {
        return 2;
    }

    @Deprecated
    public Collection<ServerName> getServerInfo() {
        return this.getServers();
    }

    public Collection<ServerName> getServers() {
        if (this.liveServers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.liveServers.keySet());
    }

    public ServerName getMaster() {
        return this.master;
    }

    public int getBackupMastersSize() {
        return this.backupMasters != null ? this.backupMasters.size() : 0;
    }

    public Collection<ServerName> getBackupMasters() {
        if (this.backupMasters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.backupMasters);
    }

    public ServerLoad getLoad(ServerName sn) {
        return this.liveServers != null ? this.liveServers.get(sn) : null;
    }

    @InterfaceAudience.Private
    public Map<String, RegionState> getRegionsInTransition() {
        return this.intransition;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String[] getMasterCoprocessors() {
        return this.masterCoprocessors;
    }

    public long getLastMajorCompactionTsForTable(TableName table) {
        long result = Long.MAX_VALUE;
        for (ServerName server : this.getServers()) {
            ServerLoad load = this.getLoad(server);
            for (RegionLoad rl : load.getRegionsLoad().values()) {
                if (!table.equals(HRegionInfo.getTable(rl.getName()))) continue;
                result = Math.min(result, rl.getLastMajorCompactionTs());
            }
        }
        return result == Long.MAX_VALUE ? 0L : result;
    }

    public long getLastMajorCompactionTsForRegion(byte[] region) {
        for (ServerName server : this.getServers()) {
            ServerLoad load = this.getLoad(server);
            RegionLoad rl = load.getRegionsLoad().get(region);
            if (rl == null) continue;
            return rl.getLastMajorCompactionTs();
        }
        return 0L;
    }

    public boolean isBalancerOn() {
        return this.balancerOn != null && this.balancerOn != false;
    }

    public Boolean getBalancerOn() {
        return this.balancerOn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Master: " + this.master);
        int backupMastersSize = this.getBackupMastersSize();
        sb.append("\nNumber of backup masters: " + backupMastersSize);
        if (backupMastersSize > 0) {
            for (ServerName serverName : this.backupMasters) {
                sb.append("\n  " + serverName);
            }
        }
        int serversSize = this.getServersSize();
        sb.append("\nNumber of live region servers: " + serversSize);
        if (serversSize > 0) {
            for (ServerName serverName : this.liveServers.keySet()) {
                sb.append("\n  " + serverName.getServerName());
            }
        }
        int n = this.getDeadServers();
        sb.append("\nNumber of dead region servers: " + n);
        if (n > 0) {
            for (ServerName serverName : this.deadServers) {
                sb.append("\n  " + serverName);
            }
        }
        sb.append("\nAverage load: " + this.getAverageLoad());
        sb.append("\nNumber of requests: " + this.getRequestsCount());
        sb.append("\nNumber of regions: " + this.getRegionsCount());
        int n2 = this.intransition != null ? this.intransition.size() : 0;
        sb.append("\nNumber of regions in transition: " + n2);
        if (n2 > 0) {
            for (RegionState state : this.intransition.values()) {
                sb.append("\n  " + state.toDescriptiveString());
            }
        }
        return sb.toString();
    }

    public ClusterStatusProtos.ClusterStatus convert() {
        ClusterStatusProtos.ClusterStatus.Builder builder = ClusterStatusProtos.ClusterStatus.newBuilder();
        builder.setHbaseVersion(FSProtos.HBaseVersionFileContent.newBuilder().setVersion(this.getHBaseVersion()));
        if (this.liveServers != null) {
            for (Map.Entry entry : this.liveServers.entrySet()) {
                ClusterStatusProtos.LiveServerInfo.Builder lsi = ClusterStatusProtos.LiveServerInfo.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)entry.getKey()));
                lsi.setServerLoad(((ServerLoad)entry.getValue()).obtainServerLoadPB());
                builder.addLiveServers(lsi.build());
            }
        }
        if (this.deadServers != null) {
            for (ServerName serverName : this.deadServers) {
                builder.addDeadServers(ProtobufUtil.toServerName(serverName));
            }
        }
        if (this.intransition != null) {
            for (Map.Entry entry : this.getRegionsInTransition().entrySet()) {
                ClusterStatusProtos.RegionState rs = ((RegionState)entry.getValue()).convert();
                HBaseProtos.RegionSpecifier.Builder builder2 = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
                builder2.setValue(ByteStringer.wrap(Bytes.toBytes((String)entry.getKey())));
                ClusterStatusProtos.RegionInTransition pbRIT = ClusterStatusProtos.RegionInTransition.newBuilder().setSpec(builder2.build()).setRegionState(rs).build();
                builder.addRegionsInTransition(pbRIT);
            }
        }
        if (this.clusterId != null) {
            builder.setClusterId(new ClusterId(this.clusterId).convert());
        }
        if (this.masterCoprocessors != null) {
            for (Iterator<Object> iterator : this.masterCoprocessors) {
                builder.addMasterCoprocessors(HBaseProtos.Coprocessor.newBuilder().setName((String)((Object)iterator)));
            }
        }
        if (this.master != null) {
            builder.setMaster(ProtobufUtil.toServerName(this.getMaster()));
        }
        if (this.backupMasters != null) {
            for (ServerName serverName : this.backupMasters) {
                builder.addBackupMasters(ProtobufUtil.toServerName(serverName));
            }
        }
        if (this.balancerOn != null) {
            builder.setBalancerOn(this.balancerOn);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static ClusterStatus convert(ClusterStatusProtos.ClusterStatus proto) {
        void var5_20;
        void var4_14;
        void var3_8;
        HashMap<ServerName, ServerLoad> servers = null;
        if (proto.getLiveServersList() != null) {
            servers = new HashMap<ServerName, ServerLoad>(proto.getLiveServersList().size());
            for (ClusterStatusProtos.LiveServerInfo liveServerInfo : proto.getLiveServersList()) {
                servers.put(ProtobufUtil.toServerName(liveServerInfo.getServer()), new ServerLoad(liveServerInfo.getServerLoad()));
            }
        }
        ArrayList<ServerName> deadServers = null;
        if (proto.getDeadServersList() != null) {
            deadServers = new ArrayList<ServerName>(proto.getDeadServersList().size());
            for (HBaseProtos.ServerName serverName : proto.getDeadServersList()) {
                deadServers.add(ProtobufUtil.toServerName(serverName));
            }
        }
        Object var3_6 = null;
        if (proto.getBackupMastersList() != null) {
            ArrayList<ServerName> arrayList = new ArrayList<ServerName>(proto.getBackupMastersList().size());
            for (HBaseProtos.ServerName serverName : proto.getBackupMastersList()) {
                arrayList.add(ProtobufUtil.toServerName(serverName));
            }
        }
        Object var4_12 = null;
        if (proto.getRegionsInTransitionList() != null) {
            HashMap<String, RegionState> hashMap = new HashMap<String, RegionState>(proto.getRegionsInTransitionList().size());
            for (ClusterStatusProtos.RegionInTransition region : proto.getRegionsInTransitionList()) {
                String key = new String(region.getSpec().getValue().toByteArray());
                RegionState value = RegionState.convert(region.getRegionState());
                hashMap.put(key, value);
            }
        }
        Object var5_18 = null;
        if (proto.getMasterCoprocessorsList() != null) {
            int numMasterCoprocessors = proto.getMasterCoprocessorsCount();
            String[] stringArray = new String[numMasterCoprocessors];
            for (int i = 0; i < numMasterCoprocessors; ++i) {
                stringArray[i] = proto.getMasterCoprocessors(i).getName();
            }
        }
        return new ClusterStatus(proto.getHbaseVersion().getVersion(), ClusterId.convert(proto.getClusterId()).toString(), servers, deadServers, ProtobufUtil.toServerName(proto.getMaster()), (Collection<ServerName>)var3_8, (Map<String, RegionState>)var4_14, (String[])var5_20, proto.getBalancerOn());
    }
}

