/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import org.apache.calcite.adapter.spark.SparkRel;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.util.Util;
import org.junit.Ignore;
import org.junit.Test;

public class SparkAdapterTest {
    private static final String VALUES0 = "(values (1, 'a'), (2, 'b'))";
    private static final String VALUES1 = "(values (1, 'a'), (2, 'b')) as t(x, y)";
    private static final String VALUES2 = "(values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)";
    private static final String VALUES3 = "(values (1, 'a'), (2, 'b')) as v(w, z)";
    private static final String VALUES4 = "(values (1, 'a'), (2, 'b'), (3, 'b'), (4, 'c'), (2, 'c')) as t(x, y)";

    private CalciteAssert.AssertQuery sql(String sql) {
        return CalciteAssert.that().with(CalciteAssert.Config.SPARK).query(sql);
    }

    @Test
    public void testValues() {
        Util.discard(SparkRel.class);
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'))";
        String plan = "PLAN=EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])";
        String expectedResult = "EXPR$0=1; EXPR$1=a\nEXPR$0=2; EXPR$1=b\n";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'))").returns("EXPR$0=1; EXPR$1=a\nEXPR$0=2; EXPR$1=b\n").explainContains("PLAN=EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])");
    }

    @Test
    public void testValuesFilter() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x < 2";
        String expectedResult = "X=1; Y=a\n";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[2], expr#3=[<($t0, $t2)], proj#0..1=[{exprs}], $condition=[$t3])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x < 2").returns("X=1; Y=a\n").explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[2], expr#3=[<($t0, $t2)], proj#0..1=[{exprs}], $condition=[$t3])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n");
    }

    @Test
    public void testSelectDistinct() {
        String sql = "select distinct *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)";
        String plan = "PLAN=EnumerableAggregate(group=[{0, 1}])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c";
        this.sql("select distinct *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)").returnsUnordered(new String[]{"X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c"}).explainContains("PLAN=EnumerableAggregate(group=[{0, 1}])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testGroupBy() {
        String sql = "select sum(x) as SUM_X, min(y) as MIN_Y, max(y) as MAX_Y, count(*) as CNT_Y, count(distinct y) as CNT_DIST_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x";
        String plan = "PLAN=EnumerableCalc(expr#0..5=[{inputs}], expr#6=[CAST($t1):INTEGER NOT NULL], expr#7=[CAST($t2):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#8=[CAST($t3):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#9=[CAST($t4):BIGINT NOT NULL], SUM_X=[$t6], MIN_Y=[$t7], MAX_Y=[$t8], CNT_Y=[$t9], CNT_DIST_Y=[$t5])\n  EnumerableAggregate(group=[{0}], SUM_X=[MIN($2) FILTER $7], MIN_Y=[MIN($3) FILTER $7], MAX_Y=[MIN($4) FILTER $7], CNT_Y=[MIN($5) FILTER $7], CNT_DIST_Y=[COUNT($1) FILTER $6])\n    EnumerableCalc(expr#0..6=[{inputs}], expr#7=[0], expr#8=[=($t6, $t7)], expr#9=[1], expr#10=[=($t6, $t9)], proj#0..5=[{exprs}], $g_0=[$t8], $g_1=[$t10])\n      EnumerableAggregate(group=[{0, 1}], groups=[[{0, 1}, {0}]], SUM_X=[$SUM0($0)], MIN_Y=[MIN($1)], MAX_Y=[MAX($1)], CNT_Y=[COUNT()], $g=[GROUPING($0, $1)])\n        EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n";
        String expectedResult = "SUM_X=2; MIN_Y=a; MAX_Y=b; CNT_Y=2; CNT_DIST_Y=2\nSUM_X=6; MIN_Y=b; MAX_Y=c; CNT_Y=3; CNT_DIST_Y=2";
        this.sql("select sum(x) as SUM_X, min(y) as MIN_Y, max(y) as MAX_Y, count(*) as CNT_Y, count(distinct y) as CNT_DIST_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x").returnsUnordered(new String[]{"SUM_X=2; MIN_Y=a; MAX_Y=b; CNT_Y=2; CNT_DIST_Y=2\nSUM_X=6; MIN_Y=b; MAX_Y=c; CNT_Y=3; CNT_DIST_Y=2"}).explainContains("PLAN=EnumerableCalc(expr#0..5=[{inputs}], expr#6=[CAST($t1):INTEGER NOT NULL], expr#7=[CAST($t2):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#8=[CAST($t3):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#9=[CAST($t4):BIGINT NOT NULL], SUM_X=[$t6], MIN_Y=[$t7], MAX_Y=[$t8], CNT_Y=[$t9], CNT_DIST_Y=[$t5])\n  EnumerableAggregate(group=[{0}], SUM_X=[MIN($2) FILTER $7], MIN_Y=[MIN($3) FILTER $7], MAX_Y=[MIN($4) FILTER $7], CNT_Y=[MIN($5) FILTER $7], CNT_DIST_Y=[COUNT($1) FILTER $6])\n    EnumerableCalc(expr#0..6=[{inputs}], expr#7=[0], expr#8=[=($t6, $t7)], expr#9=[1], expr#10=[=($t6, $t9)], proj#0..5=[{exprs}], $g_0=[$t8], $g_1=[$t10])\n      EnumerableAggregate(group=[{0, 1}], groups=[[{0, 1}, {0}]], SUM_X=[$SUM0($0)], MIN_Y=[MIN($1)], MAX_Y=[MAX($1)], CNT_Y=[COUNT()], $g=[GROUPING($0, $1)])\n        EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n");
    }

    @Test
    public void testAggFuncNoGroupBy() {
        String sql = "select sum(x) as SUM_X, min(y) as MIN_Y, max(y) as MAX_Y, count(*) as CNT_Y, count(distinct y) as CNT_DIST_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)";
        String plan = "PLAN=EnumerableCalc(expr#0..4=[{inputs}], expr#5=[CAST($t3):BIGINT NOT NULL], proj#0..2=[{exprs}], CNT_Y=[$t5], CNT_DIST_Y=[$t4])\n  EnumerableAggregate(group=[{}], SUM_X=[MIN($1) FILTER $6], MIN_Y=[MIN($2) FILTER $6], MAX_Y=[MIN($3) FILTER $6], CNT_Y=[MIN($4) FILTER $6], CNT_DIST_Y=[COUNT($0) FILTER $5])\n    EnumerableCalc(expr#0..5=[{inputs}], expr#6=[0], expr#7=[=($t5, $t6)], expr#8=[1], expr#9=[=($t5, $t8)], proj#0..4=[{exprs}], $g_0=[$t7], $g_1=[$t9])\n      EnumerableAggregate(group=[{1}], groups=[[{1}, {}]], SUM_X=[$SUM0($0)], MIN_Y=[MIN($1)], MAX_Y=[MAX($1)], CNT_Y=[COUNT()], $g=[GROUPING($1)])\n        EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n";
        String expectedResult = "SUM_X=8; MIN_Y=a; MAX_Y=c; CNT_Y=5; CNT_DIST_Y=3";
        this.sql("select sum(x) as SUM_X, min(y) as MIN_Y, max(y) as MAX_Y, count(*) as CNT_Y, count(distinct y) as CNT_DIST_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)").returnsUnordered(new String[]{"SUM_X=8; MIN_Y=a; MAX_Y=c; CNT_Y=5; CNT_DIST_Y=3"}).explainContains("PLAN=EnumerableCalc(expr#0..4=[{inputs}], expr#5=[CAST($t3):BIGINT NOT NULL], proj#0..2=[{exprs}], CNT_Y=[$t5], CNT_DIST_Y=[$t4])\n  EnumerableAggregate(group=[{}], SUM_X=[MIN($1) FILTER $6], MIN_Y=[MIN($2) FILTER $6], MAX_Y=[MIN($3) FILTER $6], CNT_Y=[MIN($4) FILTER $6], CNT_DIST_Y=[COUNT($0) FILTER $5])\n    EnumerableCalc(expr#0..5=[{inputs}], expr#6=[0], expr#7=[=($t5, $t6)], expr#8=[1], expr#9=[=($t5, $t8)], proj#0..4=[{exprs}], $g_0=[$t7], $g_1=[$t9])\n      EnumerableAggregate(group=[{1}], groups=[[{1}, {}]], SUM_X=[$SUM0($0)], MIN_Y=[MIN($1)], MAX_Y=[MAX($1)], CNT_Y=[COUNT()], $g=[GROUPING($1)])\n        EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n");
    }

    @Test
    public void testGroupByOrderByAsc() {
        String sql = "select x, count(*) as CNT_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x\norder by x asc";
        String plan = "";
        String expectedResult = "X=1; CNT_Y=2\nX=2; CNT_Y=3\n";
        this.sql("select x, count(*) as CNT_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x\norder by x asc").returns("X=1; CNT_Y=2\nX=2; CNT_Y=3\n").explainContains("");
    }

    @Test
    public void testGroupByMinMaxCountCountDistinctOrderByAsc() {
        String sql = "select x, min(y) as MIN_Y, max(y) as MAX_Y, count(*) as CNT_Y, count(distinct y) as CNT_DIST_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x\norder by x asc";
        String plan = "PLAN=EnumerableCalc(expr#0..4=[{inputs}], expr#5=[CAST($t1):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#6=[CAST($t2):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#7=[CAST($t3):BIGINT NOT NULL], X=[$t0], MIN_Y=[$t5], MAX_Y=[$t6], CNT_Y=[$t7], CNT_DIST_Y=[$t4])\n  EnumerableSort(sort0=[$0], dir0=[ASC])\n    EnumerableAggregate(group=[{0}], MIN_Y=[MIN($2) FILTER $6], MAX_Y=[MIN($3) FILTER $6], CNT_Y=[MIN($4) FILTER $6], CNT_DIST_Y=[COUNT($1) FILTER $5])\n      EnumerableCalc(expr#0..5=[{inputs}], expr#6=[0], expr#7=[=($t5, $t6)], expr#8=[1], expr#9=[=($t5, $t8)], proj#0..4=[{exprs}], $g_0=[$t7], $g_1=[$t9])\n        EnumerableAggregate(group=[{0, 1}], groups=[[{0, 1}, {0}]], MIN_Y=[MIN($1)], MAX_Y=[MAX($1)], CNT_Y=[COUNT()], $g=[GROUPING($0, $1)])\n          EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=1; MIN_Y=a; MAX_Y=b; CNT_Y=2; CNT_DIST_Y=2\nX=2; MIN_Y=b; MAX_Y=c; CNT_Y=3; CNT_DIST_Y=2\n";
        this.sql("select x, min(y) as MIN_Y, max(y) as MAX_Y, count(*) as CNT_Y, count(distinct y) as CNT_DIST_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x\norder by x asc").returns("X=1; MIN_Y=a; MAX_Y=b; CNT_Y=2; CNT_DIST_Y=2\nX=2; MIN_Y=b; MAX_Y=c; CNT_Y=3; CNT_DIST_Y=2\n").explainContains("PLAN=EnumerableCalc(expr#0..4=[{inputs}], expr#5=[CAST($t1):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#6=[CAST($t2):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#7=[CAST($t3):BIGINT NOT NULL], X=[$t0], MIN_Y=[$t5], MAX_Y=[$t6], CNT_Y=[$t7], CNT_DIST_Y=[$t4])\n  EnumerableSort(sort0=[$0], dir0=[ASC])\n    EnumerableAggregate(group=[{0}], MIN_Y=[MIN($2) FILTER $6], MAX_Y=[MIN($3) FILTER $6], CNT_Y=[MIN($4) FILTER $6], CNT_DIST_Y=[COUNT($1) FILTER $5])\n      EnumerableCalc(expr#0..5=[{inputs}], expr#6=[0], expr#7=[=($t5, $t6)], expr#8=[1], expr#9=[=($t5, $t8)], proj#0..4=[{exprs}], $g_0=[$t7], $g_1=[$t9])\n        EnumerableAggregate(group=[{0, 1}], groups=[[{0, 1}, {0}]], MIN_Y=[MIN($1)], MAX_Y=[MAX($1)], CNT_Y=[COUNT()], $g=[GROUPING($0, $1)])\n          EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testGroupByMiMaxCountCountDistinctOrderByDesc() {
        String sql = "select x, min(y) as MIN_Y, max(y) as MAX_Y, count(*) as CNT_Y, count(distinct y) as CNT_DIST_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x\norder by x desc";
        String plan = "PLAN=EnumerableCalc(expr#0..4=[{inputs}], expr#5=[CAST($t1):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#6=[CAST($t2):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#7=[CAST($t3):BIGINT NOT NULL], X=[$t0], MIN_Y=[$t5], MAX_Y=[$t6], CNT_Y=[$t7], CNT_DIST_Y=[$t4])\n  EnumerableSort(sort0=[$0], dir0=[DESC])\n    EnumerableAggregate(group=[{0}], MIN_Y=[MIN($2) FILTER $6], MAX_Y=[MIN($3) FILTER $6], CNT_Y=[MIN($4) FILTER $6], CNT_DIST_Y=[COUNT($1) FILTER $5])\n      EnumerableCalc(expr#0..5=[{inputs}], expr#6=[0], expr#7=[=($t5, $t6)], expr#8=[1], expr#9=[=($t5, $t8)], proj#0..4=[{exprs}], $g_0=[$t7], $g_1=[$t9])\n        EnumerableAggregate(group=[{0, 1}], groups=[[{0, 1}, {0}]], MIN_Y=[MIN($1)], MAX_Y=[MAX($1)], CNT_Y=[COUNT()], $g=[GROUPING($0, $1)])\n          EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=2; MIN_Y=b; MAX_Y=c; CNT_Y=3; CNT_DIST_Y=2\nX=1; MIN_Y=a; MAX_Y=b; CNT_Y=2; CNT_DIST_Y=2\n";
        this.sql("select x, min(y) as MIN_Y, max(y) as MAX_Y, count(*) as CNT_Y, count(distinct y) as CNT_DIST_Y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x\norder by x desc").returns("X=2; MIN_Y=b; MAX_Y=c; CNT_Y=3; CNT_DIST_Y=2\nX=1; MIN_Y=a; MAX_Y=b; CNT_Y=2; CNT_DIST_Y=2\n").explainContains("PLAN=EnumerableCalc(expr#0..4=[{inputs}], expr#5=[CAST($t1):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#6=[CAST($t2):CHAR(1) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], expr#7=[CAST($t3):BIGINT NOT NULL], X=[$t0], MIN_Y=[$t5], MAX_Y=[$t6], CNT_Y=[$t7], CNT_DIST_Y=[$t4])\n  EnumerableSort(sort0=[$0], dir0=[DESC])\n    EnumerableAggregate(group=[{0}], MIN_Y=[MIN($2) FILTER $6], MAX_Y=[MIN($3) FILTER $6], CNT_Y=[MIN($4) FILTER $6], CNT_DIST_Y=[COUNT($1) FILTER $5])\n      EnumerableCalc(expr#0..5=[{inputs}], expr#6=[0], expr#7=[=($t5, $t6)], expr#8=[1], expr#9=[=($t5, $t8)], proj#0..4=[{exprs}], $g_0=[$t7], $g_1=[$t9])\n        EnumerableAggregate(group=[{0, 1}], groups=[[{0, 1}, {0}]], MIN_Y=[MIN($1)], MAX_Y=[MAX($1)], CNT_Y=[COUNT()], $g=[GROUPING($0, $1)])\n          EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testGroupByHaving() {
        String sql = "select x\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x\nhaving count(*) > 2";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[2], expr#3=[>($t1, $t2)], X=[$t0], $condition=[$t3])\n  EnumerableAggregate(group=[{0}], agg#0=[COUNT()])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=2";
        this.sql("select x\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\ngroup by x\nhaving count(*) > 2").returnsUnordered(new String[]{"X=2"}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[2], expr#3=[>($t1, $t2)], X=[$t0], $condition=[$t3])\n  EnumerableAggregate(group=[{0}], agg#0=[COUNT()])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testUnionAll() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\n union all\nselect *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)";
        String plan = "PLAN=EnumerableUnion(all=[true])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n";
        String expectedResult = "X=1; Y=a\nX=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\n union all\nselect *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)").returnsUnordered(new String[]{"X=1; Y=a\nX=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c"}).explainContains("PLAN=EnumerableUnion(all=[true])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n");
    }

    @Test
    public void testUnion() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\n union\nselect *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)";
        String plan = "PLAN=EnumerableUnion(all=[false])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n";
        String expectedResult = "X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\n union\nselect *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)").returnsUnordered(new String[]{"X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c"}).explainContains("PLAN=EnumerableUnion(all=[false])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n");
    }

    @Test
    public void testIntersect() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\n intersect\nselect *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)";
        String plan = "PLAN=EnumerableIntersect(all=[false])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n";
        String expectedResult = "X=1; Y=a\nX=2; Y=b";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\n intersect\nselect *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)").returnsUnordered(new String[]{"X=1; Y=a\nX=2; Y=b"}).explainContains("PLAN=EnumerableIntersect(all=[false])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n");
    }

    @Test
    public void testSortXAscProjectY() {
        String sql = "select y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by x asc";
        String plan = "PLAN=EnumerableSort(sort0=[$1], dir0=[ASC])\n  EnumerableCalc(expr#0..1=[{inputs}], Y=[$t1], X=[$t0])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "Y=a\nY=b\nY=b\nY=c\nY=c\n";
        this.sql("select y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by x asc").returns("Y=a\nY=b\nY=b\nY=c\nY=c\n").explainContains("PLAN=EnumerableSort(sort0=[$1], dir0=[ASC])\n  EnumerableCalc(expr#0..1=[{inputs}], Y=[$t1], X=[$t0])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testSortXDescYDescProjectY() {
        String sql = "select y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by x desc, y desc";
        String plan = "PLAN=EnumerableSort(sort0=[$1], sort1=[$0], dir0=[DESC], dir1=[DESC])\n  EnumerableCalc(expr#0..1=[{inputs}], Y=[$t1], X=[$t0])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "Y=c\nY=c\nY=b\nY=b\nY=a\n";
        this.sql("select y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by x desc, y desc").returns("Y=c\nY=c\nY=b\nY=b\nY=a\n").explainContains("PLAN=EnumerableSort(sort0=[$1], sort1=[$0], dir0=[DESC], dir1=[DESC])\n  EnumerableCalc(expr#0..1=[{inputs}], Y=[$t1], X=[$t0])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testSortXDescYAscProjectY() {
        String sql = "select y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by x desc, y";
        String plan = "PLAN=EnumerableSort(sort0=[$1], sort1=[$0], dir0=[DESC], dir1=[ASC])\n  EnumerableCalc(expr#0..1=[{inputs}], Y=[$t1], X=[$t0])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "Y=b\nY=c\nY=c\nY=a\nY=b\n";
        this.sql("select y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by x desc, y").returns("Y=b\nY=c\nY=c\nY=a\nY=b\n").explainContains("PLAN=EnumerableSort(sort0=[$1], sort1=[$0], dir0=[DESC], dir1=[ASC])\n  EnumerableCalc(expr#0..1=[{inputs}], Y=[$t1], X=[$t0])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testSortXAscYDescProjectY() {
        String sql = "select y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by x, y desc";
        String plan = "PLAN=EnumerableSort(sort0=[$1], sort1=[$0], dir0=[ASC], dir1=[DESC])\n  EnumerableCalc(expr#0..1=[{inputs}], Y=[$t1], X=[$t0])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "Y=b\nY=a\nY=c\nY=c\nY=b\n";
        this.sql("select y\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by x, y desc").returns("Y=b\nY=a\nY=c\nY=c\nY=b\n").explainContains("PLAN=EnumerableSort(sort0=[$1], sort1=[$0], dir0=[ASC], dir1=[DESC])\n  EnumerableCalc(expr#0..1=[{inputs}], Y=[$t1], X=[$t0])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testJoinProject() {
        String sql = "select t.y, v.z\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\n  join (values (1, 'a'), (2, 'b')) as v(w, z) on t.x = v.w";
        String plan = "PLAN=EnumerableCalc(expr#0..3=[{inputs}], Y=[$t3], Z=[$t1])\n  EnumerableJoin(condition=[=($0, $2)], joinType=[inner])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "Y=a; Z=a\nY=b; Z=a\nY=b; Z=b\nY=c; Z=b\nY=c; Z=b";
        this.sql("select t.y, v.z\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\n  join (values (1, 'a'), (2, 'b')) as v(w, z) on t.x = v.w").returnsUnordered(new String[]{"Y=a; Z=a\nY=b; Z=a\nY=b; Z=b\nY=c; Z=b\nY=c; Z=b"}).explainContains("PLAN=EnumerableCalc(expr#0..3=[{inputs}], Y=[$t3], Z=[$t1])\n  EnumerableJoin(condition=[=($0, $2)], joinType=[inner])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testJoinProjectAliasProject() {
        String sql = "select r.z\nfrom (\n  select *\n  from (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\n    join (values (1, 'a'), (2, 'b')) as v(w, z) on t.x = v.w) as r";
        String plan = "PLAN=EnumerableCalc(expr#0..3=[{inputs}], Z=[$t1])\n  EnumerableJoin(condition=[=($0, $2)], joinType=[inner])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "Z=a\nZ=a\nZ=b\nZ=b\nZ=b";
        this.sql("select r.z\nfrom (\n  select *\n  from (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\n    join (values (1, 'a'), (2, 'b')) as v(w, z) on t.x = v.w) as r").returnsUnordered(new String[]{"Z=a\nZ=a\nZ=b\nZ=b\nZ=b"}).explainContains("PLAN=EnumerableCalc(expr#0..3=[{inputs}], Z=[$t1])\n  EnumerableJoin(condition=[=($0, $2)], joinType=[inner])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testLimit() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x = 1\nlimit 1";
        String plan = "PLAN=EnumerableLimit(fetch=[1])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[=($t0, $t2)], proj#0..1=[{exprs}], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }";
        String expectedResult = "X=1; Y=a";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x = 1\nlimit 1").returnsUnordered(new String[]{"X=1; Y=a"}).explainContains("PLAN=EnumerableLimit(fetch=[1])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[=($t0, $t2)], proj#0..1=[{exprs}], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }");
    }

    @Test
    public void testOrderByLimit() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by y\nlimit 1";
        String plan = "PLAN=EnumerableLimit(fetch=[1])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=1; Y=a\n";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by y\nlimit 1").returns("X=1; Y=a\n").explainContains("PLAN=EnumerableLimit(fetch=[1])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testOrderByOffset() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by y\noffset 2";
        String plan = "PLAN=EnumerableLimit(offset=[2])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=1; Y=b\nX=2; Y=c\nX=2; Y=c\n";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\norder by y\noffset 2").returns("X=1; Y=b\nX=2; Y=c\nX=2; Y=c\n").explainContains("PLAN=EnumerableLimit(offset=[2])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testFilterBetween() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (3, 'b'), (4, 'c'), (2, 'c')) as t(x, y)\nwhere x between 3 and 4";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[3], expr#3=[>=($t0, $t2)], expr#4=[4], expr#5=[<=($t0, $t4)], expr#6=[AND($t3, $t5)], proj#0..1=[{exprs}], $condition=[$t6])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 3, 'b' }, { 4, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=3; Y=b\nX=4; Y=c";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (3, 'b'), (4, 'c'), (2, 'c')) as t(x, y)\nwhere x between 3 and 4").returnsUnordered(new String[]{"X=3; Y=b\nX=4; Y=c"}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[3], expr#3=[>=($t0, $t2)], expr#4=[4], expr#5=[<=($t0, $t4)], expr#6=[AND($t3, $t5)], proj#0..1=[{exprs}], $condition=[$t6])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 3, 'b' }, { 4, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testFilterIsIn() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (3, 'b'), (4, 'c'), (2, 'c')) as t(x, y)\nwhere x in (3, 4)";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[3], expr#3=[=($t0, $t2)], expr#4=[4], expr#5=[=($t0, $t4)], expr#6=[OR($t3, $t5)], proj#0..1=[{exprs}], $condition=[$t6])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 3, 'b' }, { 4, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=3; Y=b\nX=4; Y=c";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (3, 'b'), (4, 'c'), (2, 'c')) as t(x, y)\nwhere x in (3, 4)").returnsUnordered(new String[]{"X=3; Y=b\nX=4; Y=c"}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[3], expr#3=[=($t0, $t2)], expr#4=[4], expr#5=[=($t0, $t4)], expr#6=[OR($t3, $t5)], proj#0..1=[{exprs}], $condition=[$t6])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 3, 'b' }, { 4, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testFilterTrue() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere true";
        String plan = "PLAN=EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere true").returnsUnordered(new String[]{"X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c"}).explainContains("PLAN=EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testFilterFalse() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere false";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[false], proj#0..1=[{exprs}], $condition=[$t2])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere false").returnsUnordered(new String[]{""}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[false], proj#0..1=[{exprs}], $condition=[$t2])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testFilterOr() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x = 1 or x = 2";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[=($t0, $t2)], expr#4=[2], expr#5=[=($t0, $t4)], expr#6=[OR($t3, $t5)], proj#0..1=[{exprs}], $condition=[$t6])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x = 1 or x = 2").returnsUnordered(new String[]{"X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c"}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[=($t0, $t2)], expr#4=[2], expr#5=[=($t0, $t4)], expr#6=[OR($t3, $t5)], proj#0..1=[{exprs}], $condition=[$t6])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testFilterIsNotNull() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x is not null";
        String plan = "PLAN=EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x is not null").returnsUnordered(new String[]{"X=1; Y=a\nX=1; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c"}).explainContains("PLAN=EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testFilterIsNull() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x is null";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[false], proj#0..1=[{exprs}], $condition=[$t2])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x is null").returnsUnordered(new String[]{""}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[false], proj#0..1=[{exprs}], $condition=[$t2])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testUnionWithFilters() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x > 1\n union all\nselect *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x > 1";
        String plan = "PLAN=EnumerableUnion(all=[true])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[>($t0, $t2)], proj#0..1=[{exprs}], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[>($t0, $t2)], proj#0..1=[{exprs}], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n";
        String expectedResult = "X=2; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x > 1\n union all\nselect *\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x > 1").returnsUnordered(new String[]{"X=2; Y=b\nX=2; Y=b\nX=2; Y=c\nX=2; Y=c"}).explainContains("PLAN=EnumerableUnion(all=[true])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[>($t0, $t2)], proj#0..1=[{exprs}], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[>($t0, $t2)], proj#0..1=[{exprs}], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n");
    }

    @Test
    public void testUnionWithFiltersProject() {
        String sql = "select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x > 1\n union\nselect x\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x > 1";
        String plan = "PLAN=EnumerableUnion(all=[false])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[>($t0, $t2)], X=[$t0], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[>($t0, $t2)], X=[$t0], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n";
        String expectedResult = "X=2";
        this.sql("select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x > 1\n union\nselect x\nfrom (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\nwhere x > 1").returnsUnordered(new String[]{"X=2"}).explainContains("PLAN=EnumerableUnion(all=[false])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[>($t0, $t2)], X=[$t0], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[>($t0, $t2)], X=[$t0], $condition=[$t3])\n    EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }, { 1, 'b' }, { 2, 'c' }, { 2, 'c' }]])\n\n");
    }

    @Test
    public void testArithmeticPlus() {
        String sql = "select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x + 1 > 1";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t0, $t2)], expr#4=[>($t3, $t2)], X=[$t0], $condition=[$t4])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n\n";
        String expectedResult = "X=1\nX=2";
        this.sql("select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x + 1 > 1").returnsUnordered(new String[]{"X=1\nX=2"}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t0, $t2)], expr#4=[>($t3, $t2)], X=[$t0], $condition=[$t4])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n\n");
    }

    @Test
    public void testArithmeticMinus() {
        String sql = "select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x - 1 > 0";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[-($t0, $t2)], expr#4=[0], expr#5=[>($t3, $t4)], X=[$t0], $condition=[$t5])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n\n";
        String expectedResult = "X=2";
        this.sql("select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x - 1 > 0").returnsUnordered(new String[]{"X=2"}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[-($t0, $t2)], expr#4=[0], expr#5=[>($t3, $t4)], X=[$t0], $condition=[$t5])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n\n");
    }

    @Test
    public void testArithmeticMul() {
        String sql = "select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x * x > 1";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[*($t0, $t0)], expr#3=[1], expr#4=[>($t2, $t3)], X=[$t0], $condition=[$t4])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n\n";
        String expectedResult = "X=2";
        this.sql("select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x * x > 1").returnsUnordered(new String[]{"X=2"}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[*($t0, $t0)], expr#3=[1], expr#4=[>($t2, $t3)], X=[$t0], $condition=[$t4])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n\n");
    }

    @Test
    public void testArithmeticDiv() {
        String sql = "select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x / x = 1";
        String plan = "PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[/($t0, $t0)], expr#3=[1], expr#4=[=($t2, $t3)], X=[$t0], $condition=[$t4])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n\n";
        String expectedResult = "X=1\nX=2";
        this.sql("select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x / x = 1").returnsUnordered(new String[]{"X=1\nX=2"}).explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[/($t0, $t0)], expr#3=[1], expr#4=[=($t2, $t3)], X=[$t0], $condition=[$t4])\n  EnumerableValues(tuples=[[{ 1, 'a' }, { 2, 'b' }]])\n\n");
    }

    @Ignore(value="[CALCITE-2184] java.lang.ClassCastException: RexSubQuery cannot be cast to RexLocalRef")
    @Test
    public void testFilterExists() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (3, 'b'), (4, 'c'), (2, 'c')) as t(x, y)\nwhere exists (\n  select *\n  from (values (1, 'a'), (2, 'b')) as v(w, z)\n  where w < x\n)";
        String plan = "PLAN=todo\n\n";
        String expectedResult = "X=2; Y=b\nX=2; Y=c\nX=3; Y=b\nX=4; Y=c";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (3, 'b'), (4, 'c'), (2, 'c')) as t(x, y)\nwhere exists (\n  select *\n  from (values (1, 'a'), (2, 'b')) as v(w, z)\n  where w < x\n)").returnsUnordered(new String[]{"X=2; Y=b\nX=2; Y=c\nX=3; Y=b\nX=4; Y=c"}).explainContains("PLAN=todo\n\n");
    }

    @Ignore(value="[CALCITE-2184] java.lang.ClassCastException: RexSubQuery cannot be cast to RexLocalRef")
    @Test
    public void testFilterNotExists() {
        String sql = "select *\nfrom (values (1, 'a'), (2, 'b'), (3, 'b'), (4, 'c'), (2, 'c')) as t(x, y)\nwhere not exists (\n  select *\n  from (values (1, 'a'), (2, 'b')) as v(w, z)\n  where w > x\n)";
        String plan = "PLAN=todo\n\n";
        String expectedResult = "X=1; Y=a";
        this.sql("select *\nfrom (values (1, 'a'), (2, 'b'), (3, 'b'), (4, 'c'), (2, 'c')) as t(x, y)\nwhere not exists (\n  select *\n  from (values (1, 'a'), (2, 'b')) as v(w, z)\n  where w > x\n)").returnsUnordered(new String[]{"X=1; Y=a"}).explainContains("PLAN=todo\n\n");
    }

    @Ignore(value="[CALCITE-2184] java.lang.ClassCastException: RexSubQuery cannot be cast to RexLocalRef")
    @Test
    public void testSubQueryAny() {
        String sql = "select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x <= any (\n  select x\n  from (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\n)";
        String plan = "PLAN=todo\n\n";
        String expectedResult = "X=1\nX=2";
        this.sql("select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x <= any (\n  select x\n  from (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\n)").returnsUnordered(new String[]{"X=1\nX=2"}).explainContains("PLAN=todo\n\n");
    }

    @Ignore(value="[CALCITE-2184] java.lang.ClassCastException: RexSubQuery cannot be cast to RexLocalRef")
    @Test
    public void testSubQueryAll() {
        String sql = "select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x <= all (\n  select x\n  from (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\n)";
        String plan = "PLAN=todo\n\n";
        String expectedResult = "X=2";
        this.sql("select x\nfrom (values (1, 'a'), (2, 'b')) as t(x, y)\nwhere x <= all (\n  select x\n  from (values (1, 'a'), (2, 'b'), (1, 'b'), (2, 'c'), (2, 'c')) as t(x, y)\n)").returnsUnordered(new String[]{"X=2"}).explainContains("PLAN=todo\n\n");
    }
}

