/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;

class PossiblyDecompressedInputStream
extends InputStream {
    private final Decompressor decompressor;
    private final InputStream coreInputStream;

    public PossiblyDecompressedInputStream(Path inputPath, Configuration conf) throws IOException {
        CompressionCodecFactory codecs = new CompressionCodecFactory(conf);
        CompressionCodec inputCodec = codecs.getCodec(inputPath);
        FileSystem ifs = inputPath.getFileSystem(conf);
        FSDataInputStream fileIn = ifs.open(inputPath);
        if (inputCodec == null) {
            this.decompressor = null;
            this.coreInputStream = fileIn;
        } else {
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)inputCodec);
            this.coreInputStream = inputCodec.createInputStream((InputStream)fileIn, this.decompressor);
        }
    }

    @Override
    public int read() throws IOException {
        return this.coreInputStream.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.coreInputStream.read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        if (this.decompressor != null) {
            CodecPool.returnDecompressor((Decompressor)this.decompressor);
        }
        this.coreInputStream.close();
    }
}

