/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.distcp2.mapred.CopyCommitter;

public class CopyOutputFormat<K, V>
extends TextOutputFormat<K, V> {
    public static void setWorkingDirectory(Job job, Path workingDirectory) {
        job.getConfiguration().set("distcp.target.work.path", workingDirectory.toString());
    }

    public static void setCommitDirectory(Job job, Path commitDirectory) {
        job.getConfiguration().set("distcp.target.final.path", commitDirectory.toString());
    }

    public static Path getWorkingDirectory(Job job) {
        return CopyOutputFormat.getWorkingDirectory(job.getConfiguration());
    }

    private static Path getWorkingDirectory(Configuration conf) {
        String workingDirectory = conf.get("distcp.target.work.path");
        if (workingDirectory == null || workingDirectory.isEmpty()) {
            return null;
        }
        return new Path(workingDirectory);
    }

    public static Path getCommitDirectory(Job job) {
        return CopyOutputFormat.getCommitDirectory(job.getConfiguration());
    }

    private static Path getCommitDirectory(Configuration conf) {
        String commitDirectory = conf.get("distcp.target.final.path");
        if (commitDirectory == null || commitDirectory.isEmpty()) {
            return null;
        }
        return new Path(commitDirectory);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        return new CopyCommitter(CopyOutputFormat.getOutputPath((JobContext)context), context);
    }

    public void checkOutputSpecs(JobContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        if (CopyOutputFormat.getCommitDirectory(conf) == null) {
            throw new IllegalStateException("Commit directory not configured");
        }
        Path workingPath = CopyOutputFormat.getWorkingDirectory(conf);
        if (workingPath == null) {
            throw new IllegalStateException("Working directory not configured");
        }
        TokenCache.obtainTokensForNamenodes((Credentials)context.getCredentials(), (Path[])new Path[]{workingPath}, (Configuration)conf);
    }
}

