/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.receivers.xml;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipInputStream;
import javax.swing.ProgressMonitorInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.UtilLoggingLevel;
import org.apache.log4j.receivers.spi.Decoder;
import org.apache.log4j.receivers.xml.UtilLoggingEntityResolver;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.log4j.xml.SAXErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class UtilLoggingXMLDecoder
implements Decoder {
    private static final String BEGIN_PART = "<log>";
    private static final String END_PART = "</log>";
    private DocumentBuilder docBuilder;
    private Map additionalProperties = new HashMap();
    private String partialEvent;
    private static final String RECORD_END = "</record>";
    private Component owner = null;
    private static final String ENCODING = "UTF-8";

    public UtilLoggingXMLDecoder(Component o) {
        this();
        this.owner = o;
    }

    public UtilLoggingXMLDecoder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        try {
            this.docBuilder = dbf.newDocumentBuilder();
            this.docBuilder.setErrorHandler((ErrorHandler)new SAXErrorHandler());
            this.docBuilder.setEntityResolver(new UtilLoggingEntityResolver());
        }
        catch (ParserConfigurationException pce) {
            System.err.println("Unable to get document builder");
        }
    }

    public void setAdditionalProperties(Map properties) {
        this.additionalProperties = properties;
    }

    private Document parse(String data) {
        if (this.docBuilder == null || data == null) {
            return null;
        }
        Document document = null;
        try {
            StringBuffer buf = new StringBuffer(1024);
            if (!data.startsWith("<?xml")) {
                buf.append(BEGIN_PART);
            }
            buf.append(data);
            if (!data.endsWith(END_PART)) {
                buf.append(END_PART);
            }
            InputSource inputSource = new InputSource(new StringReader(buf.toString()));
            document = this.docBuilder.parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector decode(URL url) throws IOException {
        InputStream inputStream;
        boolean isZipFile = url.getPath().toLowerCase().endsWith(".zip");
        if (isZipFile) {
            inputStream = new ZipInputStream(url.openStream());
            ((ZipInputStream)inputStream).getNextEntry();
        } else {
            inputStream = url.openStream();
        }
        LineNumberReader reader = this.owner != null ? new LineNumberReader(new InputStreamReader((InputStream)new ProgressMonitorInputStream(this.owner, "Loading " + url, inputStream), ENCODING)) : new LineNumberReader(new InputStreamReader(inputStream, ENCODING));
        Vector v = new Vector();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                StringBuffer buffer = new StringBuffer(line);
                for (int i = 0; i < 1000; ++i) {
                    buffer.append(reader.readLine()).append("\n");
                }
                Vector events = this.decodeEvents(buffer.toString());
                if (events == null) continue;
                v.addAll(events);
            }
        }
        finally {
            this.partialEvent = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return v;
    }

    public Vector decodeEvents(String document) {
        if (document != null) {
            String newDoc;
            if (document.trim().equals("")) {
                return null;
            }
            String newPartialEvent = null;
            if (document.lastIndexOf(RECORD_END) == -1) {
                this.partialEvent = this.partialEvent + document;
                return null;
            }
            if (document.lastIndexOf(RECORD_END) + RECORD_END.length() < document.length()) {
                newDoc = document.substring(0, document.lastIndexOf(RECORD_END) + RECORD_END.length());
                newPartialEvent = document.substring(document.lastIndexOf(RECORD_END) + RECORD_END.length());
            } else {
                newDoc = document;
            }
            if (this.partialEvent != null) {
                newDoc = this.partialEvent + newDoc;
            }
            this.partialEvent = newPartialEvent;
            Document doc = this.parse(newDoc);
            if (doc == null) {
                return null;
            }
            return this.decodeEvents(doc);
        }
        return null;
    }

    public LoggingEvent decode(String data) {
        Document document = this.parse(data);
        if (document == null) {
            return null;
        }
        Vector events = this.decodeEvents(document);
        if (events.size() > 0) {
            return (LoggingEvent)events.firstElement();
        }
        return null;
    }

    private Vector decodeEvents(Document document) {
        Vector<LoggingEvent> events = new Vector<LoggingEvent>();
        NodeList eventList = document.getElementsByTagName("record");
        for (int eventIndex = 0; eventIndex < eventList.getLength(); ++eventIndex) {
            Node eventNode = eventList.item(eventIndex);
            Logger logger = null;
            long timeStamp = 0L;
            Level level = null;
            String threadName = null;
            String message = null;
            String ndc = null;
            String[] exception = null;
            String className = null;
            String methodName = null;
            String fileName = null;
            String lineNumber = null;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            NodeList list = eventNode.getChildNodes();
            int listLength = list.getLength();
            if (listLength == 0) continue;
            for (int y = 0; y < listLength; ++y) {
                String tagName = list.item(y).getNodeName();
                if (tagName.equalsIgnoreCase("logger")) {
                    logger = Logger.getLogger((String)this.getCData(list.item(y)));
                }
                if (tagName.equalsIgnoreCase("millis")) {
                    timeStamp = Long.parseLong(this.getCData(list.item(y)));
                }
                if (tagName.equalsIgnoreCase("level")) {
                    level = UtilLoggingLevel.toLevel((String)this.getCData(list.item(y)));
                }
                if (tagName.equalsIgnoreCase("thread")) {
                    threadName = this.getCData(list.item(y));
                }
                if (tagName.equalsIgnoreCase("sequence")) {
                    properties.put("log4jid", this.getCData(list.item(y)));
                }
                if (tagName.equalsIgnoreCase("message")) {
                    message = this.getCData(list.item(y));
                }
                if (tagName.equalsIgnoreCase("class")) {
                    className = this.getCData(list.item(y));
                }
                if (tagName.equalsIgnoreCase("method")) {
                    methodName = this.getCData(list.item(y));
                }
                if (!tagName.equalsIgnoreCase("exception")) continue;
                ArrayList<String> exceptionList = new ArrayList<String>();
                NodeList exList = list.item(y).getChildNodes();
                int exlistLength = exList.getLength();
                for (int i2 = 0; i2 < exlistLength; ++i2) {
                    Node exNode = exList.item(i2);
                    String exName = exList.item(i2).getNodeName();
                    if (exName.equalsIgnoreCase("message")) {
                        exceptionList.add(this.getCData(exList.item(i2)));
                    }
                    if (!exName.equalsIgnoreCase("frame")) continue;
                    NodeList exList2 = exNode.getChildNodes();
                    int exlist2Length = exList2.getLength();
                    for (int i3 = 0; i3 < exlist2Length; ++i3) {
                        exceptionList.add(this.getCData(exList2.item(i3)) + "\n");
                    }
                }
                if (exceptionList.size() <= 0) continue;
                exception = exceptionList.toArray(new String[exceptionList.size()]);
            }
            if (this.additionalProperties.size() > 0) {
                if (properties == null) {
                    properties = new Hashtable(this.additionalProperties);
                }
                Iterator i = this.additionalProperties.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    properties.put((String)e.getKey(), (String)e.getValue());
                }
            }
            LocationInfo info = fileName != null || className != null || methodName != null || lineNumber != null ? new LocationInfo(fileName, className, methodName, lineNumber) : LocationInfo.NA_LOCATION_INFO;
            ThrowableInformation throwableInfo = null;
            if (exception != null) {
                throwableInfo = new ThrowableInformation(exception);
            }
            LoggingEvent loggingEvent = new LoggingEvent(null, (Category)logger, timeStamp, level, message, threadName, throwableInfo, ndc, info, properties);
            events.add(loggingEvent);
        }
        return events;
    }

    private String getCData(Node n) {
        StringBuffer buf = new StringBuffer();
        NodeList nl = n.getChildNodes();
        for (int x = 0; x < nl.getLength(); ++x) {
            Node innerNode = nl.item(x);
            if (innerNode.getNodeType() != 3 && innerNode.getNodeType() != 4) continue;
            buf.append(innerNode.getNodeValue());
        }
        return buf.toString();
    }
}

