/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.component.spi;

import org.apache.log4j.Logger;
import org.apache.log4j.component.ULogger;
import org.apache.log4j.component.spi.Component;
import org.apache.log4j.component.spi.Log4JULogger;
import org.apache.log4j.component.spi.NOPULogger;
import org.apache.log4j.component.spi.SimpleULogger;
import org.apache.log4j.spi.LoggerRepository;

public class ComponentBase
implements Component {
    private static final int ERROR_COUNT_LIMIT = 3;
    protected LoggerRepository repository;
    private ULogger logger;
    private int errorCount = 0;

    protected ComponentBase() {
    }

    protected void resetErrorCount() {
        this.errorCount = 0;
    }

    public void setLoggerRepository(LoggerRepository repository) {
        if (this.repository == null) {
            this.repository = repository;
        } else if (this.repository != repository) {
            throw new IllegalStateException("Repository has been already set");
        }
    }

    protected LoggerRepository getLoggerRepository() {
        return this.repository;
    }

    protected ULogger getLogger() {
        if (this.logger == null) {
            Logger l;
            this.logger = this.repository != null ? ((l = this.repository.getLogger(this.getClass().getName())) instanceof ULogger ? (ULogger)l : new Log4JULogger(l)) : SimpleULogger.getLogger(this.getClass().getName());
        }
        return this.logger;
    }

    protected ULogger getNonFloodingLogger() {
        if (this.errorCount++ >= 3) {
            return NOPULogger.NOP_LOGGER;
        }
        return this.getLogger();
    }
}

