/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StaticResourcesTest {
    TestRestConfig config;
    StaticApplication app;
    private Server server;
    String staticContent;

    @BeforeEach
    public void setUp() throws Exception {
        try (InputStreamReader isr = new InputStreamReader(ClassLoader.getSystemResourceAsStream("static/index.html"), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            this.staticContent = br.readLine() + System.lineSeparator();
        }
        Properties props = new Properties();
        props.setProperty("debug", "false");
        this.config = TestRestConfig.maprCompatible(props);
        this.app = new StaticApplication(this.config);
        this.server = this.app.createServer();
        this.server.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testStaticContent() throws Exception {
        this.testGet("/index.html", 200, this.staticContent.trim());
    }

    @Test
    public void testDefaultServletMapsToIndex() throws Exception {
        this.testGet("/", 200, this.staticContent.trim());
    }

    @Test
    public void testDynamic() throws Exception {
        this.testGet("/dynamic", 200, "it works");
    }

    private void testGet(String path, int expectedStatus, String expectedMessage) {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path(path).request().get();
        Assertions.assertEquals((int)expectedStatus, (int)response.getStatus());
        String entity = (String)response.readEntity(String.class);
        Assertions.assertEquals((Object)expectedMessage, (Object)(entity == null ? null : entity.trim()));
    }

    @Produces(value={"application/json"})
    @Path(value="/")
    public static class DynamicResource {
        @GET
        @Path(value="/dynamic")
        public String dynamic() {
            return "it works";
        }
    }

    private static class StaticApplication
    extends Application<TestRestConfig> {
        Configurable resourceConfig;

        StaticApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(DynamicResource.class);
            config.property("jersey.config.servlet.filter.staticContentRegex", (Object)"/(index\\.html|)");
        }

        protected ResourceCollection getStaticResources() {
            return new ResourceCollection(new Resource[]{Resource.newClassPathResource((String)"static")});
        }
    }
}

