/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConnectionLimitTest {
    @Test
    public void testServerConnectionLimitEnabled() throws Exception {
        int serverConnectionLimit = 5;
        FooApplication application = new FooApplication(new FooConfig((Map<String, String>)ImmutableMap.of((Object)"listeners", (Object)"http://localhost:0", (Object)"server.connection.limit", (Object)Integer.toString(serverConnectionLimit))));
        Server server = application.createServer();
        server.start();
        LinkedList<CloseableHttpClient> activeClients = new LinkedList<CloseableHttpClient>();
        for (int i = 0; i < serverConnectionLimit; ++i) {
            CloseableHttpResponse response = ConnectionLimitTest.sendCloseableRequest(server.getURI(), activeClients);
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            executor.submit(() -> ConnectionLimitTest.sendCloseableRequest(server.getURI(), activeClients)).get(2L, TimeUnit.SECONDS);
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof TimeoutException));
        }
        for (CloseableHttpClient client : activeClients) {
            client.close();
        }
        Future<CloseableHttpResponse> future = executor.submit(() -> ConnectionLimitTest.sendCloseableRequest(server.getURI(), activeClients));
        CloseableHttpResponse response = future.get(2L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        executor.shutdown();
        for (CloseableHttpClient client : activeClients) {
            client.close();
        }
        server.stop();
    }

    @Test
    public void testServerConnectionLimitDisabled() throws Exception {
        int serverConnectionLimit = 0;
        FooApplication application = new FooApplication(new FooConfig((Map<String, String>)ImmutableMap.of((Object)"listeners", (Object)"http://localhost:0", (Object)"server.connection.limit", (Object)Integer.toString(serverConnectionLimit))));
        Server server = application.createServer();
        server.start();
        LinkedList<CloseableHttpClient> activeClients = new LinkedList<CloseableHttpClient>();
        for (int i = 0; i < 100; ++i) {
            CloseableHttpResponse response = ConnectionLimitTest.sendCloseableRequest(server.getURI(), activeClients);
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        }
        for (CloseableHttpClient client : activeClients) {
            client.close();
        }
        server.stop();
    }

    private static CloseableHttpResponse sendCloseableRequest(URI serverUri, Queue<CloseableHttpClient> activeConnectionClients) throws IOException {
        CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setKeepAliveStrategy((httpResponse, httpContext) -> -1L).build();
        activeConnectionClients.offer(client);
        HttpGet get = new HttpGet(UriBuilder.fromUri((URI)serverUri).path("/foo").build(new Object[0]));
        return client.execute((HttpUriRequest)get);
    }

    @Path(value="/foo")
    public static final class FooResource {
        @GET
        public String getFoo() {
            return "bar";
        }
    }

    public static final class FooConfig
    extends RestConfig {
        public FooConfig(Map<String, String> configs) {
            super(FooConfig.baseConfigDef(), configs);
        }
    }

    public static final class FooApplication
    extends Application<FooConfig> {
        public FooApplication(FooConfig config) {
            super((RestConfig)config);
        }

        public void setupResources(Configurable<?> config, FooConfig appConfig) {
            config.register(FooResource.class);
        }
    }
}

