/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.NamedURI;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kafka.common.config.ConfigException;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ApplicationServerTest {
    static TestRestConfig testConfig;
    private static ApplicationServer<TestRestConfig> server;

    @BeforeEach
    public void setup() throws Exception {
        Properties props = new Properties();
        props.setProperty("listeners", "http://0.0.0.0:0");
        testConfig = TestRestConfig.maprCompatible(props);
        server = new ApplicationServer((RestConfig)testConfig);
    }

    @AfterEach
    public void tearDown() throws Exception {
        server.stop();
    }

    private TestRestConfig configBasic() {
        Properties props = new Properties();
        props.put("authentication.method", "BASIC");
        props.put("authentication.realm", "c3");
        props.put("authentication.roles", Collections.singletonList("Administrators"));
        return TestRestConfig.maprCompatible(props);
    }

    @Test
    public void testSecurityHandlerIsolation() throws Exception {
        TestApp app1 = new TestApp("/app1");
        TestApp app2 = new TestApp(this.configBasic(), "/app2");
        server.registerApplication((Application)app1);
        server.registerApplication((Application)app2);
        server.start();
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app1/resource"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.OK));
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app2/resource"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.UNAUTHORIZED));
    }

    @Test
    public void testExceptionMapperIsolation() throws Exception {
        TestApp app1 = new TestApp("/app1");
        TestApp app2 = new TestApp("/app2"){

            @Override
            public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
                config.register(RestResource.class);
                config.register(TestExceptionMapper.class);
            }
        };
        server.registerApplication((Application)app1);
        server.registerApplication((Application)app2);
        server.start();
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app1/exception"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.INTERNAL_SERVER_ERROR));
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app2/exception"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.ENHANCE_YOUR_CALM));
    }

    @Test
    public void testStaticResourceIsolation() throws Exception {
        TestApp app1 = new TestApp("/app1");
        TestApp app2 = new TestApp("/app2"){

            @Override
            public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
                config.register(RestResource.class);
                config.property("jersey.config.servlet.filter.staticContentRegex", (Object)"/(index\\.html|)");
            }

            protected ResourceCollection getStaticResources() {
                return new ResourceCollection(new Resource[]{Resource.newClassPathResource((String)"static")});
            }
        };
        server.registerApplication((Application)app1);
        server.registerApplication((Application)app2);
        server.start();
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app1/index.html"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.NOT_FOUND));
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app2/index.html"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.OK));
    }

    List<URL> getListeners(ApplicationServer<TestRestConfig> server) {
        return Arrays.stream(server.getConnectors()).filter(ServerConnector.class::isInstance).map(ServerConnector.class::cast).map(connector -> {
            try {
                String protocol = new HashSet(connector.getProtocols()).stream().map(String::toLowerCase).anyMatch(s -> s.equals("ssl")) ? "https" : "http";
                int localPort = connector.getLocalPort();
                return new URL(protocol, "localhost", localPort, "");
            }
            catch (Exception e) {
                throw new RuntimeException("Malformed listener", e);
            }
        }).collect(Collectors.toList());
    }

    private HttpStatus.Code makeGetRequest(String path) throws Exception {
        return this.makeGetRequest(path, server);
    }

    private HttpStatus.Code makeGetRequest(String path, ApplicationServer<TestRestConfig> server) throws Exception {
        HttpGet httpget = new HttpGet(this.getListeners(server).get(0).toString() + path);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpStatus.Code code;
            block12: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
                try {
                    code = HttpStatus.getCode((int)response.getStatusLine().getStatusCode());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return code;
        }
    }

    @Test
    public void testParseDuplicateUnnamedListeners() throws URISyntaxException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listeners", "http://0.0.0.0:4000,http://0.0.0.0:443");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        List listeners = config.getListeners();
        Assertions.assertEquals((int)2, (int)listeners.size());
        Assertions.assertNull((Object)((NamedURI)listeners.get(0)).getName());
        Assertions.assertEquals((Object)new URI("http://0.0.0.0:4000"), (Object)((NamedURI)listeners.get(0)).getUri());
        Assertions.assertNull((Object)((NamedURI)listeners.get(1)).getName());
        Assertions.assertEquals((Object)new URI("http://0.0.0.0:443"), (Object)((NamedURI)listeners.get(1)).getUri());
    }

    @Test
    public void testParseDuplicateNamedListeners() throws URISyntaxException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listeners", "INTERNAL://0.0.0.0:4000,INTERNAL://0.0.0.0:443");
        props.put("listener.protocol.map", "INTERNAL:http");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        Assertions.assertThrows(ConfigException.class, () -> ((RestConfig)config).getListeners());
    }

    @Test
    public void testParseNamedListeners() throws URISyntaxException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listeners", "INTERNAL://0.0.0.0:4000,EXTERNAL://0.0.0.0:443");
        props.put("listener.protocol.map", "INTERNAL:http,EXTERNAL:https");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        List namedListeners = config.getListeners();
        Assertions.assertEquals((int)2, (int)namedListeners.size());
        Assertions.assertEquals((Object)"internal", (Object)((NamedURI)namedListeners.get(0)).getName());
        Assertions.assertEquals((Object)new URI("http://0.0.0.0:4000"), (Object)((NamedURI)namedListeners.get(0)).getUri());
        Assertions.assertEquals((Object)"external", (Object)((NamedURI)namedListeners.get(1)).getName());
        Assertions.assertEquals((Object)new URI("https://0.0.0.0:443"), (Object)((NamedURI)namedListeners.get(1)).getUri());
    }

    @Test
    public void testParseUnnamedListeners() throws URISyntaxException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listeners", "http://0.0.0.0:4000,https://0.0.0.0:443");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        List namedListeners = config.getListeners();
        Assertions.assertEquals((int)2, (int)namedListeners.size());
        Assertions.assertNull((Object)((NamedURI)namedListeners.get(0)).getName());
        Assertions.assertEquals((Object)new URI("http://0.0.0.0:4000"), (Object)((NamedURI)namedListeners.get(0)).getUri());
        Assertions.assertNull((Object)((NamedURI)namedListeners.get(1)).getName());
        Assertions.assertEquals((Object)new URI("https://0.0.0.0:443"), (Object)((NamedURI)namedListeners.get(1)).getUri());
    }

    @Test
    public void testInvalidThreadPoolConfigQueueCapacityValid() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("request.queue.capacity", "1");
        props.put("request.queue.capacity.init", "9");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        server.stop();
        ApplicationServer applicationServer = new ApplicationServer(config);
        applicationServer.start();
        Assertions.assertEquals((int)9, (int)applicationServer.getQueueCapacity());
        applicationServer.stop();
    }

    @Test
    public void testMaxHeaderSize() throws Exception {
        TestApp app1 = new TestApp("/app");
        String path = "/app/resource?" + String.join((CharSequence)"", Collections.nCopies(8192, "a"));
        server.registerApplication((Application)app1);
        server.start();
        MatcherAssert.assertThat((Object)this.makeGetRequest(path), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.URI_TOO_LONG));
        server.stop();
        Properties props = new Properties();
        props.setProperty("listeners", "http://0.0.0.0:0");
        props.setProperty("max.request.header.size", "16384");
        RestConfig restConfig = new RestConfig(RestConfig.baseConfigDef(), (Map)props);
        ApplicationServer applicationServer = new ApplicationServer(restConfig);
        TestApp app2 = new TestApp("/app");
        applicationServer.registerApplication((Application)app2);
        applicationServer.start();
        MatcherAssert.assertThat((Object)this.makeGetRequest(path, (ApplicationServer<TestRestConfig>)applicationServer), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.OK));
        applicationServer.stop();
    }

    public static class TestExceptionMapper
    implements ExceptionMapper<Throwable> {
        public Response toResponse(Throwable throwable) {
            return Response.status((int)420).entity((Object)throwable.getMessage()).type("application/json").build();
        }
    }

    @Path(value="/")
    @Produces(value={"text/plain"})
    public static class RestResource {
        @GET
        @Path(value="/resource")
        public String get() {
            return "Hello";
        }

        @GET
        @Path(value="/exception")
        public String throwException() throws Throwable {
            throw new Throwable("catch!");
        }
    }

    private static class TestApp
    extends Application<TestRestConfig>
    implements AutoCloseable {
        private static final AtomicBoolean SHUTDOWN_CALLED = new AtomicBoolean(true);

        TestApp(String path) {
            this(testConfig, path);
        }

        TestApp(TestRestConfig config, String path) {
            super((RestConfig)config, path);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register(RestResource.class);
        }

        @Override
        public void close() throws Exception {
            this.stop();
        }

        public void onShutdown() {
            SHUTDOWN_CALLED.set(true);
        }
    }
}

