/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import java.util.Properties;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WebApplicationExceptionMapperTest {
    private WebApplicationExceptionMapper mapper;

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("debug", "false");
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        this.mapper = new WebApplicationExceptionMapper((RestConfig)config);
    }

    @Test
    public void testRestException() {
        Response response = this.mapper.toResponse((WebApplicationException)new RestException("msg", 400, 1000));
        Assertions.assertEquals((int)400, (int)response.getStatus());
        ErrorMessage out = (ErrorMessage)response.getEntity();
        Assertions.assertEquals((Object)"msg", (Object)out.getMessage());
        Assertions.assertEquals((int)1000, (int)out.getErrorCode());
    }

    @Test
    public void testNonRestWebApplicationException() {
        Response response = this.mapper.toResponse(new WebApplicationException("msg", 400));
        Assertions.assertEquals((int)400, (int)response.getStatus());
        ErrorMessage out = (ErrorMessage)response.getEntity();
        Assertions.assertEquals((Object)"msg", (Object)out.getMessage());
        Assertions.assertEquals((int)400, (int)out.getErrorCode());
    }

    @Test
    public void testRestException4xx() {
        Response response = this.mapper.toResponse((WebApplicationException)new RestException("msg", 422, 1000));
        Assertions.assertEquals((int)422, (int)response.getStatus());
        ErrorMessage out = (ErrorMessage)response.getEntity();
        Assertions.assertEquals((Object)"msg", (Object)out.getMessage());
        Assertions.assertEquals((int)1000, (int)out.getErrorCode());
        response = this.mapper.toResponse((WebApplicationException)new RestException("msg", 417, 1000));
        Assertions.assertEquals((int)417, (int)response.getStatus());
        out = (ErrorMessage)response.getEntity();
        Assertions.assertEquals((Object)"msg", (Object)out.getMessage());
        Assertions.assertEquals((int)1000, (int)out.getErrorCode());
        try {
            response = this.mapper.toResponse((WebApplicationException)new RestException("msg", 1000, 1000));
            Assertions.fail((String)"Illegal http status code should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

