/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Context;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslCertReloadTest {
    private static final Logger log = LoggerFactory.getLogger(SslCertReloadTest.class);
    private File watchDir;
    private java.nio.file.Path dataDir;
    private File trustStore;
    private File clientKeystore;
    private File serverKeystore;
    private File serverKeystoreErr;
    private java.nio.file.Path serverKeystorePath;
    public static final String SSL_PASSWORD = "test1234";
    public static final String EXPECTED_200_MSG = "Response status must be 200.";

    @BeforeEach
    public void setUp() throws Exception {
        try {
            this.watchDir = Files.createTempDirectory("SslCertReloadTest", new FileAttribute[0]).toFile();
            this.watchDir.deleteOnExit();
            this.dataDir = Paths.get(this.watchDir.getAbsolutePath(), "..data");
            java.nio.file.Path oldDir = Files.createDirectory(Paths.get(this.watchDir.getAbsolutePath(), "old"), new FileAttribute[0]);
            this.trustStore = Files.createFile(oldDir.resolve("truststore.jks"), new FileAttribute[0]).toFile();
            this.clientKeystore = Files.createFile(oldDir.resolve("client-keystore.jks"), new FileAttribute[0]).toFile();
            this.serverKeystore = Files.createFile(oldDir.resolve("server-keystore.jks"), new FileAttribute[0]).toFile();
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            this.createKeystoreWithCert(this.clientKeystore, "client", certs);
            this.createKeystoreWithCert(this.serverKeystore, "server", certs);
            TestSslUtils.createTrustStore((String)this.trustStore.getAbsolutePath(), (Password)new Password(SSL_PASSWORD), certs);
            java.nio.file.Path errDir = Files.createDirectory(Paths.get(this.watchDir.getAbsolutePath(), "err"), new FileAttribute[0]);
            Files.copy(oldDir.resolve("truststore.jks"), errDir.resolve("truststore.jks"), new CopyOption[0]);
            Files.copy(oldDir.resolve("client-keystore.jks"), errDir.resolve("client-keystore.jks"), new CopyOption[0]);
            this.serverKeystoreErr = Files.createFile(errDir.resolve("server-keystore.jks"), new FileAttribute[0]).toFile();
            certs = new HashMap();
            this.createWrongKeystoreWithCert(this.serverKeystoreErr, "server", certs);
            java.nio.file.Path newDir = Files.createDirectory(Paths.get(this.watchDir.getAbsolutePath(), "new"), new FileAttribute[0]);
            Files.copy(oldDir.resolve("truststore.jks"), newDir.resolve("truststore.jks"), new CopyOption[0]);
            Files.copy(oldDir.resolve("client-keystore.jks"), newDir.resolve("client-keystore.jks"), new CopyOption[0]);
            Files.copy(oldDir.resolve("server-keystore.jks"), newDir.resolve("server-keystore.jks"), new CopyOption[0]);
            Files.createSymbolicLink(Paths.get(this.watchDir.getAbsolutePath(), "truststore.jks"), Paths.get("..data", "truststore.jks"), new FileAttribute[0]);
            Files.createSymbolicLink(Paths.get(this.watchDir.getAbsolutePath(), "client-keystore.jks"), Paths.get("..data", "client-keystore.jks"), new FileAttribute[0]);
            this.serverKeystorePath = Files.createSymbolicLink(Paths.get(this.watchDir.getAbsolutePath(), "server-keystore.jks"), Paths.get("..data", "server-keystore.jks"), new FileAttribute[0]);
            Files.createSymbolicLink(this.dataDir, Paths.get("old", new String[0]), new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create temporary files for truststores and keystores.", ioe);
        }
    }

    private void createKeystoreWithCert(File file, String alias, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        TestSslUtils.CertificateBuilder certificateBuilder = new TestSslUtils.CertificateBuilder(30, "SHA1withRSA");
        X509Certificate cCert = certificateBuilder.sanDnsNames(new String[]{"localhost"}).generate("CN=mymachine.local, O=A client", keypair);
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(SSL_PASSWORD), (Password)new Password(SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cCert);
        certs.put(alias, cCert);
    }

    private void createWrongKeystoreWithCert(File file, String alias, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        TestSslUtils.CertificateBuilder certificateBuilder = new TestSslUtils.CertificateBuilder(30, "SHA1withRSA");
        X509Certificate cCert = certificateBuilder.sanDnsNames(new String[]{"fail"}).generate("CN=mymachine.local, O=A client", keypair);
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(SSL_PASSWORD), (Password)new Password(SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cCert);
        certs.put(alias, cCert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsWithAutoReload() throws Exception {
        Properties props = new Properties();
        String httpsUri = "https://localhost:8082";
        props.put("listeners", httpsUri);
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        props.put("ssl.keystore.location", this.serverKeystorePath.toString());
        props.put("ssl.keystore.password", SSL_PASSWORD);
        props.put("ssl.key.password", SSL_PASSWORD);
        props.put("ssl.keystore.watch.location", this.dataDir.toString());
        props.put("ssl.keystore.reload", "true");
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        SslTestApplication app = new SslTestApplication(config);
        try {
            int i;
            app.start();
            int statusCode = this.makeGetRequest(httpsUri + "/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            this.serverKeystore.delete();
            Files.delete(this.dataDir);
            Files.createSymbolicLink(this.dataDir, Paths.get("err", new String[0]), new FileAttribute[0]);
            boolean hitError = false;
            for (i = 0; i < 10; ++i) {
                Thread.sleep(5000L);
                try {
                    this.makeGetRequest(httpsUri + "/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
                    continue;
                }
                catch (Exception e) {
                    log.info("Exception with broken server cert: {}", (Object)e.toString());
                    hitError = true;
                    break;
                }
            }
            Assertions.assertTrue((boolean)hitError, (String)"expect hit error with broken server cert");
            this.serverKeystoreErr.delete();
            Files.delete(this.dataDir);
            Files.createSymbolicLink(this.dataDir, Paths.get("new", new String[0]), new FileAttribute[0]);
            for (i = 0; i < 10; ++i) {
                Thread.sleep(5000L);
                try {
                    statusCode = this.makeGetRequest(httpsUri + "/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
                    Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
                    hitError = false;
                    break;
                }
                catch (Exception e) {
                    log.info("Exception waiting for correct server cert: {}", (Object)e.toString());
                    continue;
                }
            }
            Assertions.assertTrue((!hitError ? 1 : 0) != 0, (String)"expect no hit error with correct server cert");
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int makeGetRequest(String url, String clientKeystoreLocation, String clientKeystorePassword, String clientKeyPassword) throws Exception {
        CloseableHttpClient httpclient;
        log.debug("Making GET " + url);
        HttpGet httpget = new HttpGet(url);
        if (url.startsWith("http://")) {
            httpclient = HttpClients.createDefault();
        } else {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            if (clientKeystoreLocation != null) {
                sslContextBuilder.loadKeyMaterial(new File(clientKeystoreLocation), clientKeystorePassword.toCharArray(), clientKeyPassword.toCharArray());
            }
            SSLContext sslContext = sslContextBuilder.build();
            SSLConnectionSocketFactory sslSf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSf).build();
        }
        int statusCode = -1;
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpget);
            statusCode = response.getStatusLine().getStatusCode();
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpclient.close();
        }
        return statusCode;
    }

    @Path(value="/test")
    @Produces(value={"application/test.v1+json"})
    public static class SslTestResource {
        @Context
        HttpServletRequest request;

        @GET
        public TestResponse hello() {
            return new TestResponse();
        }

        public static class TestResponse {
            @JsonProperty
            public String getMessage() {
                return "foo";
            }
        }
    }

    private static class SslTestApplication
    extends Application<TestRestConfig> {
        public SslTestApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new SslTestResource());
        }
    }
}

