/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.JettyDosFilterMultiListener;
import io.confluent.rest.NamedURI;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import io.confluent.rest.exceptions.ConstraintViolationExceptionMapper;
import io.confluent.rest.exceptions.GenericExceptionMapper;
import io.confluent.rest.exceptions.JsonMappingExceptionMapper;
import io.confluent.rest.exceptions.JsonParseExceptionMapper;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import io.confluent.rest.extension.ResourceExtension;
import io.confluent.rest.filters.CsrfTokenProtectionFilter;
import io.confluent.rest.handlers.SniHandler;
import io.confluent.rest.impersonation.ImpersonationUtils;
import io.confluent.rest.metrics.Jetty429MetricsDosFilterListener;
import io.confluent.rest.metrics.JettyRequestMetricsFilter;
import io.confluent.rest.metrics.MetricsResourceMethodApplicationListener;
import io.confluent.rest.util.HeadersFilter;
import io.confluent.rest.validation.JacksonMessageBodyProvider;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.ws.rs.core.Configurable;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.servlets.DoSFilter;
import org.eclipse.jetty.servlets.HeaderFilter;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.validation.ValidationFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Application<T extends RestConfig> {
    protected T config;
    private final String path;
    private final String listenerName;
    protected ApplicationServer<?> server;
    protected Metrics metrics;
    protected final RequestLog requestLog;
    protected final DoSFilter.Listener jetty429MetricsListener;
    protected CountDownLatch shutdownLatch = new CountDownLatch(1);
    protected final List<ResourceExtension> resourceExtensions = new ArrayList<ResourceExtension>();
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private final List<DoSFilter.Listener> globalDosfilterListeners = new ArrayList<DoSFilter.Listener>();
    private final List<DoSFilter.Listener> nonGlobalDosfilterListeners = new ArrayList<DoSFilter.Listener>();

    public Application(T config) {
        this(config, "/");
    }

    public Application(T config, String path) {
        this(config, path, null);
    }

    public Application(T config, String path, String listenerName) {
        this(config, path, listenerName, null);
    }

    public Application(T config, String path, String listenerName, RequestLog customRequestLog) {
        this.config = config;
        this.path = Objects.requireNonNull(path);
        this.listenerName = listenerName;
        this.metrics = this.configureMetrics();
        this.getMetricsTags().putAll(((RestConfig)((Object)config)).getMap("metrics.tag.map"));
        this.jetty429MetricsListener = new Jetty429MetricsDosFilterListener(this.metrics, this.getMetricsTags(), config.getString("metrics.jmx.prefix"));
        if (customRequestLog == null) {
            Slf4jRequestLogWriter logWriter = new Slf4jRequestLogWriter();
            logWriter.setLoggerName(config.getString("request.logger.name"));
            this.requestLog = new CustomRequestLog((RequestLog.Writer)logWriter, this.requestLogFormat());
        } else {
            this.requestLog = customRequestLog;
        }
        ImpersonationUtils.initialize(config);
    }

    public void addGlobalDosfilterListener(DoSFilter.Listener listener) {
        this.globalDosfilterListeners.add(Objects.requireNonNull(listener));
    }

    public void addNonGlobalDosfilterListener(DoSFilter.Listener listener) {
        this.nonGlobalDosfilterListeners.add(Objects.requireNonNull(listener));
    }

    protected String requestLogFormat() {
        return "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\" %{ms}T";
    }

    public final String getPath() {
        return this.path;
    }

    public final String getListenerName() {
        return this.listenerName;
    }

    private List<MetricsReporter> configureMetricsReporters(T appConfig) {
        List reporters = appConfig.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        reporters.add(new JmxReporter());
        Map reporterConfigs = appConfig.originals();
        reporterConfigs.putAll(((RestConfig)((Object)appConfig)).metricsReporterConfig());
        reporters.forEach(r -> r.configure(reporterConfigs));
        return reporters;
    }

    protected Metrics configureMetrics() {
        T appConfig = this.getConfiguration();
        MetricConfig metricConfig = new MetricConfig().samples(appConfig.getInt("metrics.num.samples").intValue()).timeWindow(appConfig.getLong("metrics.sample.window.ms").longValue(), TimeUnit.MILLISECONDS);
        return new Metrics(metricConfig, this.configureMetricsReporters(appConfig), ((RestConfig)((Object)appConfig)).getTime(), (MetricsContext)((RestConfig)((Object)appConfig)).getMetricsContext());
    }

    public final Metrics getMetrics() {
        return this.metrics;
    }

    public abstract void setupResources(Configurable<?> var1, T var2);

    protected ResourceCollection getStaticResources() {
        return null;
    }

    protected void configurePreResourceHandling(ServletContextHandler context) {
    }

    @Deprecated
    protected SslContextFactory getSslContextFactory() {
        return this.server.getSslContextFactory();
    }

    protected void configurePostResourceHandling(ServletContextHandler context) {
    }

    protected void configureWebSocketPostResourceHandling(ServletContextHandler context) {
    }

    public Map<String, String> getMetricsTags() {
        return new LinkedHashMap<String, String>();
    }

    public Server createServer() throws ServletException {
        if (this.server == null) {
            this.server = new ApplicationServer<T>(this.config);
            this.server.registerApplication(this);
        }
        return this.server;
    }

    final void setServer(ApplicationServer<?> server) {
        this.server = Objects.requireNonNull(server);
    }

    final ApplicationServer<?> getServer() {
        return this.server;
    }

    public Handler configureHandler() {
        ResourceConfig resourceConfig = new ResourceConfig();
        this.configureBaseApplication((Configurable<?>)resourceConfig, this.getMetricsTags());
        this.configureResourceExtensions(resourceConfig);
        this.setupResources((Configurable<?>)resourceConfig, this.getConfiguration());
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        FilterHolder servletHolder = new FilterHolder((Filter)servletContainer);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(this.path);
        if (this.listenerName != null && !this.listenerName.isEmpty()) {
            log.info("Binding {} to listener {}.", (Object)this.getClass().getSimpleName(), (Object)this.listenerName);
            context.setVirtualHosts(new String[]{"@" + this.listenerName});
        } else {
            log.info("Binding {} to all listeners.", (Object)this.getClass().getSimpleName());
        }
        ServletHolder defaultHolder = new ServletHolder("default", DefaultServlet.class);
        defaultHolder.setInitParameter("dirAllowed", "false");
        ResourceCollection staticResources = this.getStaticResources();
        if (staticResources != null) {
            context.setBaseResource((Resource)staticResources);
        }
        this.configureSecurityHandler(context);
        this.maybeAddMultiAuthFilter(context);
        this.maybeAddSecurityHeaders(context);
        if (this.isCorsEnabled()) {
            String allowedOrigins = this.config.getString("access.control.allow.origin");
            FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
            filterHolder.setName("cross-origin");
            filterHolder.setInitParameter("allowedOrigins", allowedOrigins);
            String allowedMethods = this.config.getString("access.control.allow.methods");
            String allowedHeaders = this.config.getString("access.control.allow.headers");
            if (allowedMethods != null && !allowedMethods.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedMethods", allowedMethods);
            }
            if (allowedHeaders != null && !allowedHeaders.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedHeaders", allowedHeaders);
            }
            filterHolder.setInitParameter("chainPreflight", "false");
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        if (this.isNoSniffProtectionEnabled()) {
            FilterHolder filterHolder = new FilterHolder((Filter)new HeaderFilter());
            filterHolder.setInitParameter("headerConfig", "set X-Content-Type-Options: nosniff");
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        if (this.isCsrfProtectionEnabled()) {
            String csrfEndpoint = this.config.getString("csrf.prevention.token.endpoint");
            int csrfTokenExpiration = this.config.getInt("csrf.prevention.token.expiration.minutes");
            int csrfTokenMaxEntries = this.config.getInt("csrf.prevention.token.max.entries");
            FilterHolder filterHolder = new FilterHolder(CsrfTokenProtectionFilter.class);
            filterHolder.setName("cross-site-request-forgery-prevention");
            filterHolder.setInitParameter("csrf.prevention.token.endpoint", csrfEndpoint);
            filterHolder.setInitParameter("csrf.prevention.token.expiration.minutes", String.valueOf(csrfTokenExpiration));
            filterHolder.setInitParameter("csrf.prevention.token.max.entries", String.valueOf(csrfTokenMaxEntries));
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        if (this.config.getString("response.http.headers.config") != null && !this.config.getString("response.http.headers.config").isEmpty()) {
            this.configureHttpResponseHeaderFilter(context);
        }
        this.configureJettyRequestMetricsFilter(context);
        this.configureDosFilters(context);
        this.configurePreResourceHandling(context);
        context.addFilter(servletHolder, "/*", null);
        this.configurePostResourceHandling(context);
        context.addServlet(defaultHolder, "/*");
        this.applyCustomConfiguration(context, "rest.servlet.initializor.classes");
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog(this.requestLog);
        context.insertHandler((HandlerWrapper)requestLogHandler);
        if (((RestConfig)((Object)this.config)).getSniCheckEnable()) {
            context.insertHandler((HandlerWrapper)new SniHandler());
        }
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{context});
        return handlers;
    }

    public Handler configureWebSocketHandler() throws ServletException {
        ServletContextHandler webSocketContext = new ServletContextHandler(1);
        webSocketContext.setContextPath(this.config.getString("websocket.path.prefix"));
        this.configureSecurityHandler(webSocketContext);
        this.maybeAddMultiAuthFilter(webSocketContext);
        ServerContainer container = WebSocketServerContainerInitializer.initialize((ServletContextHandler)webSocketContext);
        this.registerWebSocketEndpoints(container);
        this.configureWebSocketPostResourceHandling(webSocketContext);
        this.applyCustomConfiguration(webSocketContext, "websocket.servlet.initializor.classes");
        return webSocketContext;
    }

    public static Map<String, String> parseListToMap(List<String> list) {
        HashMap<String, String> configuredTags = new HashMap<String, String>();
        for (String entry : list) {
            String[] keyValue = entry.split("\\s*:\\s*", -1);
            if (keyValue.length != 2) {
                throw new ConfigException("Map entry should be of form <key>:<value");
            }
            configuredTags.put(keyValue[0], keyValue[1]);
        }
        return configuredTags;
    }

    private boolean isCorsEnabled() {
        return AuthUtil.isCorsEnabled(this.config);
    }

    private boolean isNoSniffProtectionEnabled() {
        return this.config.getBoolean("nosniff.prevention.enable");
    }

    private boolean isCsrfProtectionEnabled() {
        return this.config.getBoolean("csrf.prevention.enable");
    }

    private void configureResourceExtensions(ResourceConfig resourceConfig) {
        this.resourceExtensions.addAll(this.getConfiguration().getConfiguredInstances("resource.extension.classes", ResourceExtension.class));
        this.resourceExtensions.forEach(ext -> {
            try {
                ext.register((Configurable<?>)resourceConfig, this);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception throw by resource extension. ext:" + ext, e);
            }
        });
    }

    private void applyCustomConfiguration(ServletContextHandler context, String initializerConfigName) {
        this.getConfiguration().getConfiguredInstances(initializerConfigName, Consumer.class).forEach(initializer -> {
            try {
                initializer.accept(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception from custom initializer. config:" + initializerConfigName + ", initializer" + initializer, e);
            }
        });
    }

    protected void configureSecurityHandler(ServletContextHandler context) {
        String authMethod = this.config.getString("authentication.method");
        if (Application.enableBasicAuth(authMethod)) {
            context.setSecurityHandler((SecurityHandler)this.createBasicSecurityHandler());
        } else if (Application.enableBearerAuth(authMethod)) {
            context.setSecurityHandler((SecurityHandler)this.createBearerSecurityHandler());
        } else {
            AuthUtil.createDisableOptionsConstraint(this.config).ifPresent(optionsConstraint -> {
                ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
                securityHandler.addConstraintMapping(optionsConstraint);
                context.setSecurityHandler((SecurityHandler)securityHandler);
            });
        }
    }

    protected void maybeAddSecurityHeaders(ServletContextHandler context) {
        String headersFile = this.config.getString("headers.file");
        if (headersFile == null || headersFile.isEmpty()) {
            return;
        }
        FilterHolder holder = new FilterHolder((Filter)new HeadersFilter());
        holder.setInitParameter("headers.file", headersFile);
        context.addFilter(holder, "/*", EnumSet.allOf(DispatcherType.class));
    }

    private void maybeAddMultiAuthFilter(ServletContextHandler context) {
        boolean isAuthenticationEnabled = this.config.getBoolean("authentication.enable");
        if (!isAuthenticationEnabled) {
            return;
        }
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter());
        holder.setInitParameter("type", "org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler");
        List authenticationTypes = this.config.getList("hadoop.http.authentication.types");
        ListIterator authenticationTypesIterator = authenticationTypes.listIterator();
        while (authenticationTypesIterator.hasNext()) {
            holder.setInitParameter("type" + authenticationTypesIterator.nextIndex(), (String)authenticationTypesIterator.next());
        }
        Long cookiesExpirationTime = this.config.getLong("authentication.cookie.expiration");
        holder.setInitParameter("token.validity", cookiesExpirationTime.toString());
        context.addFilter(holder, "/*", EnumSet.allOf(DispatcherType.class));
    }

    public Handler wrapWithGzipHandler(Handler handler) {
        return ApplicationServer.wrapWithGzipHandler(this.config, handler);
    }

    public static List<URI> parseListeners(List<String> listenersConfig, int deprecatedPort, List<String> supportedSchemes, String defaultScheme) {
        return RestConfig.parseListeners(listenersConfig, Collections.emptyMap(), deprecatedPort, supportedSchemes, defaultScheme).stream().map(NamedURI::getUri).collect(Collectors.toList());
    }

    protected void registerWebSocketEndpoints(ServerContainer container) {
    }

    static boolean enableBasicAuth(String authMethod) {
        return "BASIC".equals(authMethod);
    }

    static boolean enableBearerAuth(String authMethod) {
        return "BEARER".equals(authMethod);
    }

    protected LoginAuthenticator createAuthenticator() {
        String method = this.config.getString("authentication.method");
        if (Application.enableBasicAuth(method)) {
            return new BasicAuthenticator();
        }
        if (Application.enableBearerAuth(method)) {
            throw new UnsupportedOperationException("Must implement Application.createAuthenticator() when using 'authentication.method=BEARER'.");
        }
        return null;
    }

    protected LoginService createLoginService() {
        String realm = this.config.getString("authentication.realm");
        String method = this.config.getString("authentication.method");
        if (Application.enableBasicAuth(method)) {
            return new JAASLoginService(realm);
        }
        if (Application.enableBearerAuth(method)) {
            throw new UnsupportedOperationException("Must implement Application.createLoginService() when using 'authentication.method=BEARER'.");
        }
        return null;
    }

    protected IdentityService createIdentityService() {
        String method = this.config.getString("authentication.method");
        if (Application.enableBasicAuth(method) || Application.enableBearerAuth(method)) {
            return new DefaultIdentityService();
        }
        return null;
    }

    protected ConstraintSecurityHandler createBasicSecurityHandler() {
        return this.createSecurityHandler();
    }

    protected ConstraintSecurityHandler createBearerSecurityHandler() {
        return this.createSecurityHandler();
    }

    protected ConstraintSecurityHandler createSecurityHandler() {
        String realm = this.config.getString("authentication.realm");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(this.createGlobalAuthConstraint());
        securityHandler.setAuthenticator((Authenticator)this.createAuthenticator());
        securityHandler.setLoginService(this.createLoginService());
        securityHandler.setIdentityService(this.createIdentityService());
        securityHandler.setRealmName(realm);
        AuthUtil.createUnsecuredConstraints(this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        AuthUtil.createDisableOptionsConstraint(this.config).ifPresent(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        return securityHandler;
    }

    protected ConstraintMapping createGlobalAuthConstraint() {
        return AuthUtil.createGlobalAuthConstraint(this.config);
    }

    public void configureBaseApplication(Configurable<?> config) {
        this.configureBaseApplication(config, null);
    }

    public void configureBaseApplication(Configurable<?> config, Map<String, String> metricTags) {
        T restConfig = this.getConfiguration();
        this.registerJsonProvider(config, restConfig, true);
        this.registerFeatures(config, restConfig);
        this.registerExceptionMappers(config, restConfig);
        config.register((Object)new MetricsResourceMethodApplicationListener(this.getMetrics(), "jersey", metricTags, ((RestConfig)((Object)restConfig)).getTime(), restConfig.getBoolean("metrics.latency.slo.sla.enable"), restConfig.getLong("metrics.latency.slo.ms"), restConfig.getLong("metrics.latency.sla.ms"), restConfig.getBoolean("metrics.global.stats.request.tags.enable")));
        config.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true);
        config.property("jersey.config.server.wadl.disableWadl", (Object)true);
    }

    protected void registerJsonProvider(Configurable<?> config, T restConfig, boolean registerExceptionMapper) {
        ObjectMapper jsonMapper = this.getJsonMapper();
        JacksonMessageBodyProvider jsonProvider = new JacksonMessageBodyProvider(jsonMapper);
        config.register((Object)jsonProvider);
        if (registerExceptionMapper) {
            config.register(JsonParseExceptionMapper.class);
            config.register(JsonMappingExceptionMapper.class);
        }
    }

    protected void registerFeatures(Configurable<?> config, T restConfig) {
        config.register(ValidationFeature.class);
    }

    protected void registerExceptionMappers(Configurable<?> config, T restConfig) {
        config.register(ConstraintViolationExceptionMapper.class);
        config.register(JsonMappingExceptionMapper.class);
        config.register(JsonParseExceptionMapper.class);
        config.register((Object)new WebApplicationExceptionMapper((RestConfig)((Object)restConfig)));
        config.register((Object)new GenericExceptionMapper((RestConfig)((Object)restConfig)));
    }

    protected void configureHttpResponseHeaderFilter(ServletContextHandler context) {
        String headerConfig = this.config.getString("response.http.headers.config");
        log.debug("headerConfig : " + headerConfig);
        String[] configs = StringUtil.csvSplit((String)headerConfig);
        Arrays.stream(configs).forEach(RestConfig::validateHttpResponseHeaderConfig);
        FilterHolder headerFilterHolder = new FilterHolder(HeaderFilter.class);
        headerFilterHolder.setInitParameter("headerConfig", headerConfig);
        context.addFilter(headerFilterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void configureJettyRequestMetricsFilter(ServletContextHandler context) {
        JettyRequestMetricsFilter filter = new JettyRequestMetricsFilter(this.metrics, this.getMetricsTags(), this.config.getString("metrics.jmx.prefix"));
        FilterHolder filterHolder = new FilterHolder((Filter)filter);
        context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void configureDosFilters(ServletContextHandler context) {
        if (!((RestConfig)((Object)this.config)).isDosFilterEnabled()) {
            return;
        }
        this.configureNonGlobalDosFilter(context);
        this.configureGlobalDosFilter(context);
    }

    private void configureNonGlobalDosFilter(ServletContextHandler context) {
        DoSFilter dosFilter = new DoSFilter();
        this.nonGlobalDosfilterListeners.add(this.jetty429MetricsListener);
        JettyDosFilterMultiListener multiListener = new JettyDosFilterMultiListener(this.nonGlobalDosfilterListeners);
        dosFilter.setListener((DoSFilter.Listener)multiListener);
        FilterHolder filterHolder = this.configureDosFilter(dosFilter, String.valueOf(((RestConfig)((Object)this.config)).getDosFilterMaxRequestsPerConnectionPerSec()));
        context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void configureGlobalDosFilter(ServletContextHandler context) {
        GlobalDosFilter dosFilter = new GlobalDosFilter();
        this.globalDosfilterListeners.add(this.jetty429MetricsListener);
        JettyDosFilterMultiListener multiListener = new JettyDosFilterMultiListener(this.globalDosfilterListeners);
        dosFilter.setListener(multiListener);
        String globalLimit = String.valueOf(((RestConfig)((Object)this.config)).getDosFilterMaxRequestsGlobalPerSec());
        FilterHolder filterHolder = this.configureDosFilter(dosFilter, globalLimit);
        context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private FilterHolder configureDosFilter(DoSFilter dosFilter, String rate) {
        FilterHolder filterHolder = new FilterHolder((Filter)dosFilter);
        filterHolder.setInitParameter("maxRequestsPerSec", rate);
        filterHolder.setInitParameter("delayMs", String.valueOf(((RestConfig)((Object)this.config)).getDosFilterDelayMs().toMillis()));
        filterHolder.setInitParameter("maxWaitMs", String.valueOf(((RestConfig)((Object)this.config)).getDosFilterMaxWaitMs().toMillis()));
        filterHolder.setInitParameter("throttledRequests", String.valueOf(((RestConfig)((Object)this.config)).getDosFilterThrottledRequests()));
        filterHolder.setInitParameter("throttleMs", String.valueOf(((RestConfig)((Object)this.config)).getDosFilterThrottleMs().toMillis()));
        filterHolder.setInitParameter("maxRequestMs", String.valueOf(((RestConfig)((Object)this.config)).getDosFilterMaxRequestMs().toMillis()));
        filterHolder.setInitParameter("maxIdleTrackerMs", String.valueOf(((RestConfig)((Object)this.config)).getDosFilterMaxIdleTrackerMs().toMillis()));
        filterHolder.setInitParameter("insertHeaders", String.valueOf(((RestConfig)((Object)this.config)).getDosFilterInsertHeaders()));
        filterHolder.setInitParameter("trackSessions", "false");
        filterHolder.setInitParameter("remotePort", String.valueOf("false"));
        filterHolder.setInitParameter("ipWhitelist", String.valueOf(((RestConfig)((Object)this.config)).getDosFilterIpWhitelist()));
        filterHolder.setInitParameter("managedAttr", String.valueOf(((RestConfig)((Object)this.config)).getDosFilterManagedAttr()));
        return filterHolder;
    }

    public T getConfiguration() {
        return this.config;
    }

    protected ObjectMapper getJsonMapper() {
        return new ObjectMapper();
    }

    public void start() throws Exception {
        this.createServer();
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
        this.shutdownLatch.await();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    final void doShutdown() {
        this.resourceExtensions.forEach(ext -> {
            try {
                ext.close();
            }
            catch (IOException e) {
                log.error("Error closing the extension resource. ext:" + ext, (Throwable)e);
            }
        });
        this.shutdownLatch.countDown();
        this.onShutdown();
    }

    public void onShutdown() {
    }

    private static final class GlobalDosFilter
    extends DoSFilter {
        private GlobalDosFilter() {
        }

        protected String extractUserId(ServletRequest request) {
            return "GLOBAL";
        }
    }
}

