/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.ApplicationServerTest;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ProxyProtocolTest {
    private static TestRestConfig testConfig;
    private Properties props;
    private ApplicationServer<TestRestConfig> server;
    private File clientKeystore;
    public static final String SSL_PASSWORD = "test1234";

    @BeforeEach
    public void setup() throws Exception {
        this.props = new Properties();
        this.props.setProperty("proxy.protocol.enabled", "true");
    }

    private void createKeystoreWithCert(File file, String alias, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        TestSslUtils.CertificateBuilder certificateBuilder = new TestSslUtils.CertificateBuilder(30, "SHA1withRSA");
        X509Certificate cCert = certificateBuilder.sanDnsNames(new String[]{"localhost"}).generate("CN=mymachine.local, O=A client", keypair);
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(SSL_PASSWORD), (Password)new Password(SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cCert);
        certs.put(alias, cCert);
    }

    private void configServerKeystore(Properties props, File serverKeystore) {
        props.put("ssl.keystore.location", serverKeystore.getAbsolutePath());
        props.put("ssl.keystore.password", SSL_PASSWORD);
        props.put("ssl.key.password", SSL_PASSWORD);
    }

    private void configServerTruststore(Properties props, File trustStore) {
        props.put("ssl.truststore.location", trustStore.getAbsolutePath());
        props.put("ssl.truststore.password", SSL_PASSWORD);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
    }

    @Test
    public void testConnectionFactoriesHttp() throws Exception {
        this.testConnectionFactories("http", false);
    }

    @Test
    public void testConnectionFactoriesHttpWithHttp2() throws Exception {
        this.testConnectionFactories("http", true);
    }

    @Test
    public void testConnectionFactoriesHttps() throws Exception {
        this.testConnectionFactories("https", false);
    }

    @Test
    public void testConnectionFactoriesHttpsWithHttp2() throws Exception {
        this.testConnectionFactories("https", true);
    }

    private void testConnectionFactories(String scheme, boolean http2Enabled) throws Exception {
        String url = scheme + "://localhost:9000";
        this.props.setProperty("listeners", url);
        this.props.setProperty("http2.enabled", Boolean.toString(http2Enabled));
        if (scheme.equals("https")) {
            File serverKeystore;
            File trustStore;
            try {
                trustStore = File.createTempFile("SslTest-truststore", ".jks");
                this.clientKeystore = File.createTempFile("SslTest-client-keystore", ".jks");
                serverKeystore = File.createTempFile("SslTest-server-keystore", ".jks");
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to create temporary files for trust stores and keystores.");
            }
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            this.createKeystoreWithCert(this.clientKeystore, "client", certs);
            this.createKeystoreWithCert(serverKeystore, "server", certs);
            TestSslUtils.createTrustStore((String)trustStore.getAbsolutePath(), (Password)new Password(SSL_PASSWORD), certs);
            this.configServerKeystore(this.props, serverKeystore);
            this.configServerTruststore(this.props, trustStore);
        }
        testConfig = TestRestConfig.maprCompatible(this.props);
        this.server = new ApplicationServer((RestConfig)testConfig);
        ProxyTestApp app = new ProxyTestApp("/app");
        this.server.registerApplication((Application)app);
        this.server.start();
        boolean proxyConnectionFactoryFound = false;
        for (ConnectionFactory factory : this.server.getConnectors()[0].getConnectionFactories()) {
            if (!(factory instanceof ProxyConnectionFactory)) continue;
            proxyConnectionFactoryFound = true;
            break;
        }
        MatcherAssert.assertThat((String)"ProxyConnectionFactory was not found in server's connection factories", (boolean)proxyConnectionFactoryFound);
        MatcherAssert.assertThat((Object)this.makeGetRequest(url + "/app/resource"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.OK.getCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int makeGetRequest(String url) throws Exception {
        int statusCode;
        CloseableHttpClient httpclient;
        HttpGet httpget = new HttpGet(url);
        if (url.startsWith("http://")) {
            httpclient = HttpClients.createDefault();
        } else {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            sslContextBuilder.loadKeyMaterial(new File(this.clientKeystore.getAbsolutePath()), SSL_PASSWORD.toCharArray(), SSL_PASSWORD.toCharArray());
            SSLContext sslContext = sslContextBuilder.build();
            SSLConnectionSocketFactory sslSf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSf).build();
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpget);
            statusCode = response.getStatusLine().getStatusCode();
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpclient.close();
        }
        return statusCode;
    }

    @Path(value="/")
    @Produces(value={"text/plain"})
    public static class RestResource {
        @GET
        @Path(value="/resource")
        public String get() {
            return "Hello";
        }
    }

    private static class ProxyTestApp
    extends Application<TestRestConfig>
    implements AutoCloseable {
        private static final AtomicBoolean SHUTDOWN_CALLED = new AtomicBoolean(true);

        ProxyTestApp(String path) {
            this(testConfig, path);
        }

        ProxyTestApp(TestRestConfig config, String path) {
            super((RestConfig)config, path);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register(ApplicationServerTest.RestResource.class);
        }

        @Override
        public void close() throws Exception {
            this.stop();
        }

        public void onShutdown() {
            SHUTDOWN_CALLED.set(true);
        }
    }
}

