/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.FileWatcher;
import io.confluent.rest.KafkaRestSslPropertiesReader;
import io.confluent.rest.SslConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigException;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslFactory {
    private static final Logger log = LoggerFactory.getLogger(SslFactory.class);

    private SslFactory() {
    }

    public static SslContextFactory createSslContextFactory(SslConfig sslConfig) {
        List<String> excludedCipherSuites;
        List<String> disabledProtocols;
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (!sslConfig.getKeyStoreType().isEmpty()) {
            sslContextFactory.setKeyStoreType(sslConfig.getKeyStoreType());
        } else {
            String clusterSslKeystoreType = KafkaRestSslPropertiesReader.getServerKeystoreType();
            if (clusterSslKeystoreType == null) {
                throw new ConfigException("ssl.keystore.type");
            }
            sslContextFactory.setKeyStoreType(clusterSslKeystoreType);
            if (clusterSslKeystoreType.equalsIgnoreCase("BCFKS")) {
                Security.addProvider((Provider)new BouncyCastleFipsProvider());
                Security.addProvider((Provider)new BouncyCastleJsseProvider());
                sslContextFactory.setProvider("BCJSSE");
            }
        }
        if (!sslConfig.getKeyStorePath().isEmpty()) {
            sslContextFactory.setKeyStorePath(sslConfig.getKeyStorePath());
        } else {
            String clusterSslKeystoreLocation = KafkaRestSslPropertiesReader.getServerKeystoreLocation();
            if (clusterSslKeystoreLocation == null) {
                throw new ConfigException("ssl.keystore.location");
            }
            sslContextFactory.setKeyStorePath(clusterSslKeystoreLocation);
        }
        String sslKeystorePassword = sslConfig.getKeyStorePassword();
        if (!Objects.equals(sslKeystorePassword, "")) {
            sslContextFactory.setKeyStorePassword(sslKeystorePassword);
        } else {
            String clusterSslKeystorePassword = KafkaRestSslPropertiesReader.getServerKeystorePassword();
            if (Objects.equals(clusterSslKeystorePassword, "")) {
                throw new ConfigException("ssl.keystore.password");
            }
            sslContextFactory.setKeyStorePassword(clusterSslKeystorePassword);
        }
        String sslKeyPassword = sslConfig.getKeyManagerPassword();
        if (!Objects.equals(sslKeyPassword, "")) {
            sslContextFactory.setKeyManagerPassword(sslKeyPassword);
        } else {
            String clusterSslKeyPassword = KafkaRestSslPropertiesReader.getServerKeyPassword();
            if (Objects.equals(clusterSslKeyPassword, "")) {
                throw new ConfigException("ssl.key.password");
            }
            sslContextFactory.setKeyManagerPassword(clusterSslKeyPassword);
        }
        if (!sslConfig.getKeyManagerFactoryAlgorithm().isEmpty()) {
            sslContextFactory.setKeyManagerFactoryAlgorithm(sslConfig.getKeyManagerFactoryAlgorithm());
        }
        if (sslConfig.getReloadOnKeyStoreChange()) {
            Path watchLocation = Paths.get(sslConfig.getReloadOnKeyStoreChangePath(), new String[0]);
            try {
                FileWatcher.onFileChange(watchLocation, () -> {
                    sslContextFactory.setKeyStorePath(sslConfig.getKeyStorePath());
                    sslContextFactory.reload(scf -> log.info("SSL cert auto reload begun: " + scf.getKeyStorePath()));
                    log.info("SSL cert auto reload complete");
                });
                log.info("Enabled SSL cert auto reload for: " + watchLocation);
            }
            catch (IOException e) {
                log.error("Cannot enable SSL cert auto reload", (Throwable)e);
            }
        }
        SslFactory.configureClientAuth(sslContextFactory, sslConfig);
        if (!sslConfig.getIncludeProtocols().isEmpty()) {
            sslContextFactory.setIncludeProtocols(sslConfig.getIncludeProtocols().toArray(new String[0]));
        }
        if (!(disabledProtocols = sslConfig.getExcludeProtocols()).isEmpty()) {
            sslContextFactory.setExcludeProtocols(disabledProtocols.toArray(new String[0]));
        }
        if (!sslConfig.getIncludeCipherSuites().isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(sslConfig.getIncludeCipherSuites().toArray(new String[0]));
        }
        if (!(excludedCipherSuites = sslConfig.getExcludeCipherSuites()).isEmpty()) {
            sslContextFactory.setExcludeCipherSuites(excludedCipherSuites.toArray(new String[0]));
        }
        if (sslConfig.getEndpointIdentificationAlgorithm() != null) {
            sslContextFactory.setEndpointIdentificationAlgorithm(sslConfig.getEndpointIdentificationAlgorithm());
        }
        if (!sslConfig.getTrustStoreType().isEmpty()) {
            sslContextFactory.setTrustStoreType(sslConfig.getTrustStoreType());
        } else {
            String clusterSslTruststoreType = KafkaRestSslPropertiesReader.getServerTruststoreType();
            if (clusterSslTruststoreType == null) {
                throw new ConfigException("ssl.truststore.type");
            }
            sslContextFactory.setTrustStoreType(clusterSslTruststoreType);
        }
        if (!sslConfig.getTrustStorePath().isEmpty()) {
            sslContextFactory.setTrustStorePath(sslConfig.getTrustStorePath());
            sslContextFactory.setTrustStorePassword(sslConfig.getTrustStorePassword());
            if (!sslConfig.getTrustManagerFactoryAlgorithm().isEmpty()) {
                sslContextFactory.setTrustManagerFactoryAlgorithm(sslConfig.getTrustManagerFactoryAlgorithm());
            }
        }
        sslContextFactory.setProtocol(sslConfig.getProtocol());
        if (!sslConfig.getProvider().isEmpty()) {
            SslFactory.configureSecurityProvider(sslContextFactory, sslConfig);
        }
        sslContextFactory.setRenegotiationAllowed(false);
        return sslContextFactory;
    }

    private static void configureClientAuth(SslContextFactory.Server sslContextFactory, SslConfig config) {
        switch (config.getClientAuth()) {
            case NEED: {
                sslContextFactory.setNeedClientAuth(true);
                break;
            }
            case WANT: {
                sslContextFactory.setWantClientAuth(true);
                break;
            }
        }
    }

    private static void configureSecurityProvider(SslContextFactory.Server sslContextFactory, SslConfig sslConfig) {
        sslContextFactory.setProvider(sslConfig.getProvider());
        if ("Conscrypt".equalsIgnoreCase(sslConfig.getProvider())) {
            Security.addProvider((Provider)new OpenSSLProvider());
        }
    }
}

