/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.impersonation;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.RestConfig;
import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.exceptions.RestServerErrorException;
import io.confluent.rest.impersonation.Errors;
import io.confluent.rest.impersonation.ImpersonationUtils;
import io.confluent.rest.mapr.test.MaprHomeSupport;
import io.confluent.rest.mapr.test.MaprTestLoginModule;
import io.confluent.rest.mapr.test.MaprTestLoginRule;
import io.confluent.rest.mapr.test.TestUtils;
import io.confluent.rest.mapr.test.ThrowingAction;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.UserGroupInformation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;

public class ImpersonationUtilsTest {
    @Rule
    public final MaprTestLoginRule loginRule = MaprTestLoginRule.forHadoopSimpleAndJpam();
    private static final String ANY_USER = "user";

    @Before
    public void setUp() {
        this.configure(true);
    }

    private void configure(boolean enabled) {
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), (Map)ImmutableMap.of((Object)"impersonation.enable", (Object)Boolean.toString(enabled)));
        ImpersonationUtils.initialize((RestConfig)config);
    }

    @Test
    public void enablesImpersonationWhenConfiguredTrue() {
        this.configure(true);
        Assert.assertTrue((boolean)ImpersonationUtils.isImpersonationEnabled());
    }

    @Test
    public void disablesImpersonationWhenConfiguredFalse() {
        this.configure(false);
        Assert.assertFalse((boolean)ImpersonationUtils.isImpersonationEnabled());
    }

    @Test
    public void whenEnabledImpersonatesRunner() {
        this.configure(true);
        UserGroupInformation user = (UserGroupInformation)ImpersonationUtils.runAsUserIfImpersonationEnabled(this::getCurrentUser, (String)this.basicAuth(ANY_USER), (String)this.cookieAuth(ANY_USER));
        Assert.assertEquals((Object)ANY_USER, (Object)user.getUserName());
    }

    @Test
    public void whenDisabledRunsActionAsSameUser() {
        this.configure(false);
        UserGroupInformation user = (UserGroupInformation)ImpersonationUtils.runAsUserIfImpersonationEnabled(this::getCurrentUser, (String)this.basicAuth("ignored-basic-auth-user"), (String)this.cookieAuth("ignored-cookie-user"));
        Assert.assertSame((Object)this.getCurrentUser(), (Object)user);
    }

    @Test
    public void whenForcedImpersonatesRunner() {
        this.configure(false);
        UserGroupInformation user = (UserGroupInformation)ImpersonationUtils.runAsUser(this::getCurrentUser, (String)this.basicAuth(ANY_USER), (String)this.cookieAuth(ANY_USER));
        Assert.assertEquals((Object)ANY_USER, (Object)user.getUserName());
    }

    @Test
    public void throwsRestExceptionOnIOException() throws IOException {
        MaprTestLoginModule.restrict(UserGroupInformation.getLoginUser().getUserName(), password -> {
            throw new LoginException();
        });
        UserGroupInformation.reset();
        ThrowingAction action = () -> ImpersonationUtils.runAsUser(this::getCurrentUser, (String)this.basicAuth("whatever"), (String)this.cookieAuth("whatever"));
        TestUtils.assertThatThrownRestException(action, (Matcher<RestException>)CoreMatchers.allOf(TestUtils.hasSameRestAttributesAs((RestException)Errors.serverLoginException((Throwable)new IOException())), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(IOException.class))));
    }

    @Test
    public void wrapsRestServerExceptions() {
        RestServerErrorException causeException = new RestServerErrorException("Some server error", 0);
        PrivilegedAction<UserGroupInformation> impersonatedAction = () -> {
            throw causeException;
        };
        ThrowingAction action = () -> ImpersonationUtils.runAsUser((PrivilegedAction)impersonatedAction, (String)this.basicAuth("whatever"), (String)this.cookieAuth("whatever"));
        TestUtils.assertThatThrownRestException(action, (Matcher<RestException>)CoreMatchers.allOf(TestUtils.hasSameRestAttributesAs((RestException)Errors.serverLoginException((String)"whatever", (Throwable)causeException)), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.sameInstance((Object)causeException))));
    }

    private UserGroupInformation getCurrentUser() {
        try {
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String cookieAuth(String username) {
        return "hadoop.auth=whatever&u=" + username;
    }

    private String basicAuth(String username) {
        return "Basic " + Base64.encodeBase64String((byte[])(username + ":any-pass").getBytes());
    }

    static {
        MaprHomeSupport.activate();
    }
}

