/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.mapr.test.MaprHomeSupport;
import java.util.HashMap;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IdleTimeoutConfigTest {
    @Test
    public void testIdleTimeoutConfigIsApplied() throws Exception {
        long expectedIdleTimeout = 1000L;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("idle.timeout.ms", String.valueOf(expectedIdleTimeout));
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        Server server = new TestApp(config).createServer();
        server.start();
        Assertions.assertEquals((long)expectedIdleTimeout, (long)server.getConnectors()[0].getIdleTimeout());
        server.stop();
    }

    static {
        MaprHomeSupport.activate();
    }

    public static class TestApp
    extends Application<RestConfig> {
        public TestApp(RestConfig config) {
            super(config);
        }

        public void setupResources(Configurable<?> config, RestConfig appConfig) {
        }
    }
}

