/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.NamedURI;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ApplicationGroupTest {
    static TestRestConfig testConfig;
    private static ApplicationServer server;

    @Before
    public void setup() throws Exception {
        Properties props = new Properties();
        props.setProperty("listeners", "http://0.0.0.0:0");
        testConfig = TestRestConfig.maprCompatible(props);
        server = new ApplicationServer((RestConfig)testConfig);
    }

    @After
    public void tearDown() throws Exception {
        server.stop();
    }

    private TestRestConfig configAuthentication() {
        Properties props = new Properties();
        props.put("authentication.enable", "true");
        props.put("authentication.realm", "c3");
        props.put("authentication.roles", Collections.singletonList("Administrators"));
        return TestRestConfig.maprCompatible(props);
    }

    @Test
    public void testSecurityHandlerIsolation() throws Exception {
        TestApp app1 = new TestApp("/app1");
        TestApp app2 = new TestApp(this.configAuthentication(), "/app2");
        server.registerApplication((Application)app1);
        server.registerApplication((Application)app2);
        server.start();
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app1/resource"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.OK));
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app2/resource"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.UNAUTHORIZED));
    }

    @Test
    public void testExceptionMapperIsolation() throws Exception {
        TestApp app1 = new TestApp("/app1");
        TestApp app2 = new TestApp("/app2"){

            @Override
            public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
                config.register(RestResource.class);
                config.register(TestExceptionMapper.class);
            }
        };
        server.registerApplication((Application)app1);
        server.registerApplication((Application)app2);
        server.start();
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app1/exception"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.INTERNAL_SERVER_ERROR));
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app2/exception"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.ENHANCE_YOUR_CALM));
    }

    @Test
    public void testStaticResourceIsolation() throws Exception {
        TestApp app1 = new TestApp("/app1");
        TestApp app2 = new TestApp("/app2"){

            @Override
            public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
                config.register(RestResource.class);
                config.property("jersey.config.servlet.filter.staticContentRegex", (Object)"/(index\\.html|)");
            }

            protected ResourceCollection getStaticResources() {
                return new ResourceCollection(new Resource[]{Resource.newClassPathResource((String)"static")});
            }
        };
        server.registerApplication((Application)app1);
        server.registerApplication((Application)app2);
        server.start();
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app1/index.html"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.NOT_FOUND));
        MatcherAssert.assertThat((Object)this.makeGetRequest("/app2/index.html"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.OK));
    }

    private HttpStatus.Code makeGetRequest(String path) throws Exception {
        HttpGet httpget = new HttpGet(((NamedURI)testConfig.getListeners().get(0)).toString() + path);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpStatus.Code code;
            block12: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
                try {
                    code = HttpStatus.getCode((int)response.getStatusLine().getStatusCode());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return code;
        }
    }

    public static class TestExceptionMapper
    implements ExceptionMapper<Throwable> {
        public Response toResponse(Throwable throwable) {
            return Response.status((int)420).entity((Object)throwable.getMessage()).type("application/json").build();
        }
    }

    @Path(value="/")
    @Produces(value={"text/plain"})
    public static class RestResource {
        @GET
        @Path(value="/resource")
        public String get() {
            return "Hello";
        }

        @GET
        @Path(value="/exception")
        public String throwException() throws Throwable {
            throw new Throwable("catch!");
        }
    }

    private static class TestApp
    extends Application<TestRestConfig>
    implements AutoCloseable {
        private static final AtomicBoolean SHUTDOWN_CALLED = new AtomicBoolean(true);

        TestApp(String path) {
            this(testConfig, path);
        }

        TestApp(TestRestConfig config, String path) {
            super((RestConfig)config, path);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register(RestResource.class);
        }

        @Override
        public void close() throws Exception {
            this.stop();
        }

        public void onShutdown() {
            SHUTDOWN_CALLED.set(true);
        }
    }
}

