/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.impersonation;

import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.exceptions.RestServerErrorException;
import io.confluent.rest.impersonation.Errors;
import io.confluent.rest.impersonation.ImpersonatedExecutor;
import io.confluent.rest.mapr.test.MaprHomeSupport;
import io.confluent.rest.mapr.test.MaprTestLoginModule;
import io.confluent.rest.mapr.test.MaprTestLoginRule;
import io.confluent.rest.mapr.test.TestUtils;
import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.security.UserGroupInformation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;

public class ImpersonatedExecutorTest {
    @Rule
    public final MaprTestLoginRule loginRule = MaprTestLoginRule.forHadoopSimpleAndJpam();
    private ImpersonatedExecutor executor;

    @Before
    public void setUp() {
        this.executor = new ImpersonatedExecutor();
    }

    @Test
    public void executesActionAsAnotherUser() {
        String username = "another-user";
        UserGroupInformation ugi = (UserGroupInformation)this.executor.runAs(username, () -> {
            try {
                return UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Assert.assertThat((Object)ugi.getUserName(), (Matcher)CoreMatchers.equalTo((Object)username));
    }

    @Test
    public void executesActionAsSameUser() throws IOException {
        String currentUserName = UserGroupInformation.getCurrentUser().getUserName();
        UserGroupInformation ugi = (UserGroupInformation)this.executor.runAs(currentUserName, () -> {
            try {
                return UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Assert.assertThat((Object)ugi.getUserName(), (Matcher)CoreMatchers.equalTo((Object)currentUserName));
    }

    @Test
    public void executeThrowingActionAsAnotherUser() throws Exception {
        String username = "another-user";
        UserGroupInformation ugi = (UserGroupInformation)this.executor.runThrowingAs(username, UserGroupInformation::getCurrentUser);
        Assert.assertThat((Object)ugi.getUserName(), (Matcher)CoreMatchers.equalTo((Object)username));
    }

    @Test
    public void executesThrowingActionAsSameUser() throws Exception {
        String currentUserName = UserGroupInformation.getCurrentUser().getUserName();
        UserGroupInformation ugi = (UserGroupInformation)this.executor.runThrowingAs(currentUserName, () -> {
            try {
                return UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Assert.assertThat((Object)ugi.getUserName(), (Matcher)CoreMatchers.equalTo((Object)currentUserName));
    }

    @Test
    public void executeFailedThrowingActionAsAnotherUser() {
        String username = "another-user";
        TestUtils.assertThatThrownException(() -> this.executor.runThrowingAs(username, () -> {
            throw new IOException();
        }), (Matcher<Exception>)CoreMatchers.instanceOf(IOException.class));
    }

    @Test
    public void wrapsRestServerExceptionsForAction() {
        String username = "another-user";
        RestServerErrorException exception = new RestServerErrorException("", 0);
        TestUtils.assertThatThrownRestException(() -> this.executor.runAs(username, () -> {
            throw exception;
        }), (Matcher<RestException>)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.sameInstance((Object)exception)));
    }

    @Test
    public void wrapsRestServerExceptionsForThrowingAction() {
        String username = "another-user";
        RestServerErrorException exception = new RestServerErrorException("", 0);
        TestUtils.assertThatThrownRestException(() -> this.executor.runThrowingAs(username, () -> {
            throw exception;
        }), (Matcher<RestException>)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.sameInstance((Object)exception)));
    }

    @Test
    public void unwrapsUndeclaredExceptionForThrowingAction() {
        String username = "another-user";
        Exception exception = new Exception();
        TestUtils.assertThatThrownException(() -> this.executor.runThrowingAs(username, () -> {
            throw exception;
        }), (Matcher<Exception>)CoreMatchers.sameInstance((Object)exception));
    }

    @Test
    public void wrapsIOExceptionOnBuildingUser() throws IOException {
        UserGroupInformation loginUser = UserGroupInformation.getCurrentUser();
        MaprTestLoginModule.restrict(loginUser.getUserName(), password -> {
            throw new LoginException();
        });
        UserGroupInformation.reset();
        TestUtils.assertThatThrownRestException(() -> this.executor.getImpersonatedUser("any-user"), (Matcher<RestException>)CoreMatchers.allOf(TestUtils.hasSameRestAttributesAs((RestException)Errors.serverLoginException((Throwable)new IOException())), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(IOException.class))));
    }

    static {
        MaprHomeSupport.activate();
    }
}

