/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import io.confluent.rest.metrics.RestMetricsContext;
import java.util.Map;

public final class TestRestMetricsContext {
    private final RestMetricsContext metricsContext;
    public static final String RESOURCE_LABEL_PREFIX = "resource.";
    public static final String RESOURCE_LABEL_TYPE = "resource.type";

    public TestRestMetricsContext(String namespace, Map<String, Object> config) {
        this.metricsContext = new RestMetricsContext(namespace, config);
        this.setResourceLabel(RESOURCE_LABEL_TYPE, namespace);
    }

    public void setLabel(String labelKey, String labelValue) {
        if (labelKey.startsWith(RESOURCE_LABEL_PREFIX)) {
            this.setResourceLabel(labelKey, labelValue);
        }
        this.metricsContext.setLabel(labelKey, labelValue);
    }

    private void setResourceLabel(String resource, String value) {
        if (this.metricsContext.getLabel(resource) == null) {
            this.metricsContext.setLabel(resource, value);
        }
    }

    public RestMetricsContext metricsContext() {
        return this.metricsContext;
    }
}

