/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import io.confluent.rest.TestRestConfig;
import io.confluent.rest.metrics.RestMetricsContext;
import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class RestMetricsContextTest {
    @Test
    public void testDefaultMetricsContext() throws Exception {
        TestRestConfig config = TestRestConfig.maprCompatible(new Properties());
        RestMetricsContext context = config.getMetricsContext();
        Assert.assertEquals((Object)context.getLabel("resource.type"), (Object)"rest-utils");
        Assert.assertEquals((Object)context.getLabel("_namespace"), (Object)"rest-utils");
    }

    @Test
    public void testMetricsContextResourceOverride() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("metrics.context.resource.type", "root");
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        RestMetricsContext context = config.getMetricsContext();
        Assert.assertEquals((Object)context.getLabel("resource.type"), (Object)"root");
        Assert.assertEquals((Object)context.getLabel("_namespace"), (Object)"rest-utils");
    }

    @Test
    public void testMetricsContextJMXPrefixPropagation() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("metrics.jmx.prefix", "FooApp");
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        RestMetricsContext context = config.getMetricsContext();
        Assert.assertEquals((Object)context.getLabel("_namespace"), (Object)"FooApp");
    }

    @Test
    public void testMetricsContextPutNamespaceLabelStripResourcePrefix() throws Exception {
        HashMap props = new HashMap();
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        RestMetricsContext context = config.getMetricsContext();
        Assert.assertEquals((Object)"rest-utils", (Object)context.getLabel("_namespace"));
    }

    @Test
    public void testMetricsContextResourceLabelNew() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("metrics.context.resource.type", "root");
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        RestMetricsContext context = config.getMetricsContext();
        String RESOURCE_CLUSTER_ID = "resource.cluster.id";
        context.setLabel(RESOURCE_CLUSTER_ID, "rest-utils-bootstrap");
        Assert.assertEquals((Object)context.getLabel("resource.type"), (Object)"root");
        Assert.assertEquals((Object)context.getLabel("_namespace"), (Object)"rest-utils");
        Assert.assertEquals((Object)context.getLabel(RESOURCE_CLUSTER_ID), (Object)"rest-utils-bootstrap");
    }

    @Test
    public void testMetricsContextResourceNonStringValue() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("metrics.context.resource.type", "root");
        props.put("metrics.context.notString", this.getClass());
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        RestMetricsContext context = config.getMetricsContext();
        Assert.assertEquals((Object)context.getLabel("resource.type"), (Object)"root");
        Assert.assertEquals((Object)context.getLabel("_namespace"), (Object)"rest-utils");
        Assert.assertEquals((Object)context.getLabel("notString"), (Object)this.getClass().toString());
    }
}

